<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use App\Models\RoiSchedule;

class TestProfitBalance extends Command
{
    protected $signature = 'roi:test-profit-balance {username}';
    protected $description = 'Test profit balance update for a user';

    public function handle()
    {
        $username = $this->argument('username');
        
        $user = User::where('username', $username)->first();
        
        if (!$user) {
            $this->error("User '{$username}' not found!");
            return Command::FAILURE;
        }
        
        $this->info("Testing profit balance for user: {$user->username}");
        $this->info("Current profit_balance: {$user->profit_balance}");
        
        // Test increment
        $testAmount = 10.50;
        $this->info("Adding {$testAmount} to profit balance...");
        
        $user->increment('profit_balance', $testAmount);
        $user->refresh();
        
        $this->info("New profit_balance: {$user->profit_balance}");
        
        // Test direct update
        $this->info("Testing direct update...");
        $currentBalance = $user->profit_balance;
        $user->update(['profit_balance' => $currentBalance + 5.25]);
        $user->refresh();
        
        $this->info("After direct update: {$user->profit_balance}");
        
        // Check if there are any ready ROI schedules
        $readySchedules = RoiSchedule::where('user_id', $user->id)
            ->where('status', 'ready')
            ->get();
            
        $this->info("Ready ROI schedules: " . $readySchedules->count());
        
        foreach ($readySchedules as $schedule) {
            $this->info("Schedule ID: {$schedule->id}, Amount: {$schedule->roi_amount}, Status: {$schedule->status}");
        }
        
        return Command::SUCCESS;
    }
}
