<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use App\Models\RoiSchedule;
use App\Models\Invest;

class TestRoiCollection extends Command
{
    protected $signature = 'roi:test-collection {username}';
    protected $description = 'Test ROI collection for specific user';

    public function handle()
    {
        $username = $this->argument('username');
        
        $this->info("🧪 Testing ROI Collection for user: {$username}");
        
        // Find user
        $user = User::where('username', $username)->first();
        
        if (!$user) {
            $this->error("❌ User '{$username}' not found!");
            return Command::FAILURE;
        }
        
        $this->info("✅ User found: {$user->first_name} {$user->last_name}");
        $this->info("💰 Current Profit Balance: {$user->profit_balance}");
        
        // Get user's ROI schedules
        $roiSchedules = RoiSchedule::where('user_id', $user->id)->get();
        
        $this->info("📊 Found {$roiSchedules->count()} ROI schedules");
        
        foreach ($roiSchedules as $schedule) {
            $this->line("Schedule ID: {$schedule->id}, Status: {$schedule->status}, Amount: {$schedule->roi_amount}, End Time: {$schedule->roi_end_time}");
        }
        
        // Find pending schedules
        $pendingSchedules = RoiSchedule::where('user_id', $user->id)
            ->where('status', 'pending')
            ->get();
            
        if ($pendingSchedules->count() > 0) {
            $this->info("🔄 Found {$pendingSchedules->count()} pending schedules, marking as ready...");
            
            foreach ($pendingSchedules as $schedule) {
                $schedule->update([
                    'status' => 'ready',
                    'roi_ready_time' => now()
                ]);
                $this->line("✅ Marked Schedule ID: {$schedule->id} as ready");
            }
        }
        
        // Find ready schedules
        $readySchedules = RoiSchedule::where('user_id', $user->id)
            ->where('status', 'ready')
            ->get();
            
        if ($readySchedules->count() > 0) {
            $this->info("🎯 Found {$readySchedules->count()} ready schedules");
            
            foreach ($readySchedules as $schedule) {
                $this->line("Ready Schedule ID: {$schedule->id}, Amount: {$schedule->roi_amount}");
            }
        } else {
            $this->warn("⚠️  No ready schedules found");
        }
        
        $this->info("✅ Test completed!");
        
        return Command::SUCCESS;
    }
}
