<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Schema;
use Illuminate\Http\Request;

class SchemaOrderController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:schema-edit');
    }

    public function reorder(Request $request)
    {
        $data = $request->validate([
            'order' => 'required|array',
            'order.*.id' => 'required|integer|exists:schemas,id',
            'order.*.order' => 'required|integer',
        ]);

        foreach ($data['order'] as $row) {
            Schema::where('id', $row['id'])->update(['display_order' => $row['order']]);
        }

        return response()->json(['success' => true, 'message' => 'Order updated']);
    }
}



