<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Announcement;
use Illuminate\Http\Request;

class AnnouncementController extends Controller
{
    /**
     * Get active popup announcements
     */
    public function getPopupAnnouncements()
    {
        $announcements = Announcement::active()
            ->popup()
            ->orderBy('created_at', 'desc')
            ->get();

        return response()->json([
            'success' => true,
            'announcements' => $announcements
        ]);
    }

    /**
     * Get all active announcements
     */
    public function getActiveAnnouncements()
    {
        $announcements = Announcement::active()
            ->orderBy('created_at', 'desc')
            ->get();

        return response()->json([
            'success' => true,
            'announcements' => $announcements
        ]);
    }

    /**
     * Get announcements by type
     */
    public function getAnnouncementsByType($type)
    {
        $announcements = Announcement::active()
            ->where('type', $type)
            ->orderBy('created_at', 'desc')
            ->get();

        return response()->json([
            'success' => true,
            'announcements' => $announcements
        ]);
    }
}

