<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ProfileCompletionWithdraw
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $user = Auth::user();
        
        // Check if user profile is complete for withdrawal
        if (!$user || !$this->isProfileCompleteForWithdraw($user)) {
            return redirect()->route('user.setting.show')->with('error', 'Please complete your profile to access withdrawal features.');
        }
        
        return $next($request);
    }
    
    /**
     * Check if user profile is complete for withdrawal
     */
    private function isProfileCompleteForWithdraw($user)
    {
        // Check required fields for withdrawal
        $requiredFields = [
            'first_name',
            'last_name', 
            'email',
            'phone',
            'address',
            'city',
            'zip_code',
            'country'
        ];
        
        foreach ($requiredFields as $field) {
            if (empty($user->$field)) {
                return false;
            }
        }
        
        return true;
    }
}
