<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ManualPaymentGateway extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'code',
        'wallet_address',
        'qr_code',
        'payment_instructions',
        'network',
        'minimum_amount',
        'maximum_amount',
        'fee_percentage',
        'fee_fixed',
        'currency',
        'currency_symbol',
        'status',
        'sort_order'
    ];

    protected $casts = [
        'minimum_amount' => 'decimal:2',
        'maximum_amount' => 'decimal:2',
        'fee_percentage' => 'decimal:2',
        'fee_fixed' => 'decimal:2',
        'status' => 'boolean',
        'sort_order' => 'integer'
    ];

    // Scope for active gateways
    public function scopeActive($query)
    {
        return $query->where('status', true);
    }

    // Scope for ordering
    public function scopeOrdered($query)
    {
        return $query->orderBy('sort_order')->orderBy('name');
    }

    // Get QR code URL or generate one
    public function getQrCodeUrlAttribute()
    {
        if ($this->qr_code) {
            return $this->qr_code;
        }
        
        // Generate QR code URL if not provided
        return 'https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=' . urlencode($this->wallet_address);
    }
}
