<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Add balance field if it doesn't exist
            if (!Schema::hasColumn('users', 'balance')) {
                $table->decimal('balance', 20, 2)->default(0)->after('address');
            }
            
            // Add profit_balance field if it doesn't exist
            if (!Schema::hasColumn('users', 'profit_balance')) {
                $table->decimal('profit_balance', 20, 2)->default(0)->after('balance');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            if (Schema::hasColumn('users', 'balance')) {
                $table->dropColumn('balance');
            }
            
            if (Schema::hasColumn('users', 'profit_balance')) {
                $table->dropColumn('profit_balance');
            }
        });
    }
};
