<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('withdraw_methods', function (Blueprint $table) {
            if (!Schema::hasColumn('withdraw_methods', 'is_active')) {
                $table->boolean('is_active')->default(true)->after('sort_order');
            }
            if (!Schema::hasColumn('withdraw_methods', 'sort_order')) {
                $table->integer('sort_order')->default(0)->after('is_active');
            }
            if (!Schema::hasColumn('withdraw_methods', 'required_fields')) {
                $table->json('required_fields')->nullable()->after('fee_fixed');
            }
            if (!Schema::hasColumn('withdraw_methods', 'instructions')) {
                $table->text('instructions')->nullable()->after('required_fields');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('withdraw_methods', function (Blueprint $table) {
            if (Schema::hasColumn('withdraw_methods', 'instructions')) {
                $table->dropColumn('instructions');
            }
            if (Schema::hasColumn('withdraw_methods', 'required_fields')) {
                $table->dropColumn('required_fields');
            }
            if (Schema::hasColumn('withdraw_methods', 'sort_order')) {
                $table->dropColumn('sort_order');
            }
            if (Schema::hasColumn('withdraw_methods', 'is_active')) {
                $table->dropColumn('is_active');
            }
        });
    }
};

