<?php

namespace Database\Seeders;

use App\Models\Ranking;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class AchievementRankingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Don't truncate - use updateOrCreate instead
        
        // Create Level 0: NO RANK (Default for new users)
        Ranking::updateOrCreate(
            ['id' => 0],
            [
            'icon' => 'fas fa-user',
            'ranking' => 0,
            'ranking_name' => 'NO RANK',
            'minimum_earnings' => 0,
            'minimum_deposit' => 0,
            'minimum_invest' => 0,
            'minimum_referral' => 0,
            'minimum_referral_deposit' => 0,
            'minimum_referral_invest' => 0,
            'bonus' => 0,
            'salary' => 0,
            'description' => 'Default rank for new users. Complete requirements to achieve higher ranks.',
            'status' => 1,
            ]
        );
        
        // Create Level 1: Struggler
        Ranking::updateOrCreate(
            ['id' => 1],
            [
            'icon' => 'fas fa-seedling',
            'ranking' => 1,
            'ranking_name' => 'STRUGGLER',
            'minimum_earnings' => 0,
            'minimum_deposit' => 0,
            'minimum_invest' => 100,
            'minimum_referral' => 1,
            'minimum_referral_deposit' => 0,
            'minimum_referral_invest' => 0,
            'bonus' => 50,
            'salary' => 0,
            'description' => 'Get 1 referral and make $100 investment to unlock this rank',
            'status' => 1,
            ]
        );
        
        // Create Level 2: Team Leader
        Ranking::updateOrCreate(
            ['id' => 2],
            [
            'icon' => 'fas fa-crown',
            'ranking' => 2,
            'ranking_name' => 'TEAM LEADER',
            'minimum_earnings' => 0,
            'minimum_deposit' => 0,
            'minimum_invest' => 3000,
            'minimum_referral' => 4,
            'minimum_referral_deposit' => 0,
            'minimum_referral_invest' => 3000,
            'bonus' => 300,
            'salary' => 40,
            'description' => 'Get 4 referrals and have team invest $3000 total to unlock this rank',
            'status' => 1,
        
        
        echo "Achievement rankings created successfully!\n";
        echo "- Level 0: NO RANK (Default for new users)\n";
        echo "- Level 1: STRUGGLER (1 referral, $100 investment, $50 bonus)\n";
        echo "- Level 2: TEAM LEADER (4 referrals, $3000 team investment, $300 bonus, $40 monthly salary)\n";
    }
}