<?php

namespace Database\Seeders;

use App\Models\Ranking;
use Illuminate\Database\Seeder;

class FinalRankingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Don't truncate - use updateOrCreate instead
        
        // Create Level 1: TEAM LEADER (Default starting rank with requirements)
        Ranking::updateOrCreate(
            ['id' => 1],
            [
            'icon' => 'fas fa-crown',
            'ranking' => 1,
            'ranking_name' => 'TEAM LEADER',
            'minimum_earnings' => 0,
            'minimum_deposit' => 0,
            'minimum_invest' => 0,
            'minimum_referral' => 4,
            'minimum_referral_deposit' => 0,
            'minimum_referral_invest' => 14400,
            'bonus' => 300,
            'salary' => 40,
            'description' => 'Get 4 referrals and have team invest $14,400 to unlock salary and bonus.',
            'status' => 1,
            ]
        );
        
        // Create Level 2: Senior Team Leader (First achievable rank with requirements)
        Ranking::updateOrCreate(
            ['id' => 2],
            [
            'icon' => 'fas fa-star',
            'ranking' => 2,
            'ranking_name' => 'Senior Team Leader',
            'minimum_earnings' => 1000,
            'minimum_deposit' => 0,
            'minimum_invest' => 0,
            'minimum_referral' => 1,
            'minimum_referral_deposit' => 0,
            'minimum_referral_invest' => 0,
            'bonus' => 100,
            'salary' => 20,
            'description' => 'Get 1 referral and earn $1000 to unlock salary and bonus',
            'status' => 1,
            ]
        );
        
        // Create Level 3: SALE MANAGER
        Ranking::updateOrCreate(
            ['id' => 3],
            [
            'icon' => 'fas fa-briefcase',
            'ranking' => 3,
            'ranking_name' => 'SALE MANAGER',
            'minimum_earnings' => 14400,
            'minimum_deposit' => 0,
            'minimum_invest' => 0,
            'minimum_referral' => 0,
            'minimum_referral_deposit' => 0,
            'minimum_referral_invest' => 0,
            'bonus' => 600,
            'salary' => 80,
            'description' => 'Achieve $14400 minimum earnings to unlock this rank',
            'status' => 1,
            ]
        );
        
        // Create Level 4: S.SALE MANAGER
        Ranking::updateOrCreate(
            ['id' => 4],
            [
            'icon' => 'fas fa-trophy',
            'ranking' => 4,
            'ranking_name' => 'S.SALE MANAGER',
            'minimum_earnings' => 57600,
            'minimum_deposit' => 0,
            'minimum_invest' => 0,
            'minimum_referral' => 0,
            'minimum_referral_deposit' => 0,
            'minimum_referral_invest' => 0,
            'bonus' => 2000,
            'salary' => 160,
            'description' => 'Achieve $57600 minimum earnings to unlock this rank',
            'status' => 1,
            ]
        );
        
        // Create Level 5: DIRECTOR
        Ranking::updateOrCreate(
            ['id' => 5],
            [
            'icon' => 'fas fa-gem',
            'ranking' => 5,
            'ranking_name' => 'DIRECTOR',
            'minimum_earnings' => 230400,
            'minimum_deposit' => 0,
            'minimum_invest' => 0,
            'minimum_referral' => 0,
            'minimum_referral_deposit' => 0,
            'minimum_referral_invest' => 0,
            'bonus' => 7000,
            'salary' => 320,
            'description' => 'Achieve $230400 minimum earnings to unlock this rank',
            'status' => 1,
            ]
        );
        
        // Create Level 6: Global Ambassador
        Ranking::updateOrCreate(
            ['id' => 6],
            [
            'icon' => 'fas fa-globe',
            'ranking' => 6,
            'ranking_name' => 'Global Ambassador',
            'minimum_earnings' => 249999.75,
            'minimum_deposit' => 0,
            'minimum_invest' => 0,
            'minimum_referral' => 0,
            'minimum_referral_deposit' => 0,
            'minimum_referral_invest' => 0,
            'bonus' => 30000,
            'salary' => 1000,
            'description' => 'Achieve $249999.75 minimum earnings to unlock this rank',
            'status' => 1,
            ]
        );
        
        echo "Final rankings created successfully!\n";
        echo "- Level 1: TEAM LEADER (4 referrals, $14,400 team investment, $300 bonus, $40 salary)\n";
        echo "- Level 2: Senior Team Leader (1 referral, $1000 earnings, $100 bonus, $20 salary)\n";
        echo "- Level 3: SALE MANAGER ($14400 earnings, $600 bonus, $80 salary)\n";
        echo "- Level 4: S.SALE MANAGER ($57600 earnings, $2000 bonus, $160 salary)\n";
        echo "- Level 5: DIRECTOR ($230400 earnings, $7000 bonus, $320 salary)\n";
        echo "- Level 6: Global Ambassador ($249999.75 earnings, $30000 bonus, $1000 salary)\n";
    }
}
