@extends('backend.layouts.app')

@section('title', 'Deposit Methods Management')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Deposit Methods Management</h3>
                    <div class="card-tools">
                        <a href="{{ route('admin.deposit-methods.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Add New Method
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Gateway Code</th>
                                    <th>Type</th>
                                    <th>Status</th>
                                    <th>Wallet Address</th>
                                    <th>QR Code</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($depositMethods as $method)
                                <tr>
                                    <td>{{ $method->id }}</td>
                                    <td>{{ $method->name }}</td>
                                    <td>{{ $method->gateway_code }}</td>
                                    <td>
                                        <span class="badge badge-{{ $method->type == 'auto' ? 'success' : 'warning' }}">
                                            {{ ucfirst($method->type) }}
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge badge-{{ $method->status ? 'success' : 'danger' }}">
                                            {{ $method->status ? 'Active' : 'Inactive' }}
                                        </span>
                                    </td>
                                    <td>
                                        @php
                                            $paymentDetails = json_decode($method->payment_details, true);
                                            $walletAddress = $paymentDetails['wallet_address'] ?? 'Not Set';
                                        @endphp
                                        @if($walletAddress !== 'Not Set')
                                            <code>{{ Str::limit($walletAddress, 20) }}</code>
                                        @else
                                            <span class="text-muted">Not Set</span>
                                        @endif
                                    </td>
                                    <td>
                                        @php
                                            $qrCode = $paymentDetails['qr_code'] ?? null;
                                        @endphp
                                        @if($qrCode)
                                            <img src="{{ $qrCode }}" alt="QR Code" style="width: 30px; height: 30px;">
                                        @else
                                            <span class="text-muted">Not Set</span>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('admin.deposit-methods.edit', $method->id) }}" class="btn btn-sm btn-primary">
                                            <i class="fas fa-edit"></i> Edit
                                        </a>
                                        <form action="{{ route('admin.deposit-methods.destroy', $method->id) }}" method="POST" style="display: inline;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                                <i class="fas fa-trash"></i> Delete
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center">No deposit methods found.</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

