@extends('backend.layouts.app')

@section('title', 'Schedule Management')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Schedule Management</h3>
                    <div class="card-tools">
                        <a href="{{ route('admin.schedules.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Add New Schedule
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Time (Minutes)</th>
                                    <th>Time (Display)</th>
                                    <th>Status</th>
                                    <th>Used By</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($schedules as $schedule)
                                <tr>
                                    <td>{{ $schedule->id }}</td>
                                    <td>{{ $schedule->name }}</td>
                                    <td>{{ $schedule->time }}</td>
                                    <td>
                                        @if($schedule->time < 60)
                                            {{ $schedule->time }} minutes
                                        @elseif($schedule->time < 1440)
                                            {{ round($schedule->time / 60, 1) }} hours
                                        @else
                                            {{ round($schedule->time / 1440, 1) }} days
                                        @endif
                                    </td>
                                    <td>
                                        <span class="badge badge-{{ $schedule->status ? 'success' : 'danger' }}">
                                            {{ $schedule->status ? 'Active' : 'Inactive' }}
                                        </span>
                                    </td>
                                    <td>
                                        {{ \App\Models\Schema::where('return_period', $schedule->id)->count() }} plans
                                    </td>
                                    <td>
                                        <a href="{{ route('admin.schedules.edit', $schedule) }}" class="btn btn-sm btn-primary">
                                            <i class="fas fa-edit"></i> Edit
                                        </a>
                                        <form action="{{ route('admin.schedules.destroy', $schedule) }}" method="POST" style="display: inline-block;" onsubmit="return confirm('Are you sure you want to delete this schedule?')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger">
                                                <i class="fas fa-trash"></i> Delete
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center">No schedules found.</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
