@extends('backend.layouts.app')
@section('title', 'Announcement Management')
@section('content')
{{-- ANNOUNCEMENT INDEX - NO CREATE BUTTON --}}
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="site-card">
                <div class="site-card-header">
                    <h3 class="title">Announcement Management</h3>
                    {{-- NO CREATE BUTTON HERE --}}
                </div>
                
                <div class="site-card-body">
                    <div class="site-datatable">
                        <table id="announcement-dataTable" class="display data-table">
                            <thead>
                                <tr>
                                    <th>Title</th>
                                    <th>Type</th>
                                    <th>Status</th>
                                    <th>Popup</th>
                                    <th>Date Range</th>
                                    <th>Created By</th>
                                    <th>Created At</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($announcements as $announcement)
                                <tr>
                                    <td>
                                        <div class="announcement-title">
                                            <strong>{{ $announcement->title }}</strong>
                                            <small class="text-muted d-block">{{ Str::limit($announcement->message, 50) }}</small>
                                        </div>
                                    </td>
                                    <td>
                                        @if($announcement->type == 'announcement')
                                            <span class="badge badge-info">Announcement</span>
                                        @elseif($announcement->type == 'offer')
                                            <span class="badge badge-success">Offer</span>
                                        @elseif($announcement->type == 'promotion')
                                            <span class="badge badge-warning">Promotion</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($announcement->status == 'active')
                                            <span class="badge badge-success">Active</span>
                                        @else
                                            <span class="badge badge-danger">Inactive</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($announcement->show_popup)
                                            <span class="badge badge-primary">Yes</span>
                                        @else
                                            <span class="badge badge-secondary">No</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($announcement->start_date && $announcement->end_date)
                                            <small>
                                                {{ $announcement->start_date->format('M d, Y') }} - 
                                                {{ $announcement->end_date->format('M d, Y') }}
                                            </small>
                                        @elseif($announcement->start_date)
                                            <small>From: {{ $announcement->start_date->format('M d, Y') }}</small>
                                        @elseif($announcement->end_date)
                                            <small>Until: {{ $announcement->end_date->format('M d, Y') }}</small>
                                        @else
                                            <small class="text-muted">No date limit</small>
                                        @endif
                                    </td>
                                    <td>
                                        @if($announcement->creator)
                                            <small>{{ $announcement->creator->name }}</small>
                                        @else
                                            <small class="text-muted">System</small>
                                        @endif
                                    </td>
                                    <td>
                                        <small>{{ $announcement->created_at->format('M d, Y H:i') }}</small>
                                    </td>
                                    <td>
                                        <div class="action-buttons">
                                            <a href="{{ route('admin.announcement.show', $announcement->id) }}" 
                                               class="btn btn-sm btn-info" title="View">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('admin.announcement.edit', $announcement->id) }}" 
                                               class="btn btn-sm btn-warning" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            
                                            <form action="{{ route('admin.announcement.toggle-status', $announcement->id) }}" 
                                                  method="POST" class="d-inline">
                                                @csrf
                                                <button type="submit" class="btn btn-sm btn-{{ $announcement->status == 'active' ? 'secondary' : 'success' }}" 
                                                        title="{{ $announcement->status == 'active' ? 'Deactivate' : 'Activate' }}">
                                                    <i class="fas fa-{{ $announcement->status == 'active' ? 'pause' : 'play' }}"></i>
                                                </button>
                                            </form>
                                            
                                            <form action="{{ route('admin.announcement.toggle-popup', $announcement->id) }}" 
                                                  method="POST" class="d-inline">
                                                @csrf
                                                <button type="submit" class="btn btn-sm btn-{{ $announcement->show_popup ? 'secondary' : 'primary' }}" 
                                                        title="{{ $announcement->show_popup ? 'Disable Popup' : 'Enable Popup' }}">
                                                    <i class="fas fa-{{ $announcement->show_popup ? 'eye-slash' : 'eye' }}"></i>
                                                </button>
                                            </form>
                                            
                                            <form action="{{ route('admin.announcement.destroy', $announcement->id) }}" 
                                                  method="POST" class="d-inline delete-form">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger" title="Delete" 
                                                        onclick="return confirm('Are you sure you want to delete this announcement?')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.announcement-title {
    max-width: 200px;
}
.action-buttons {
    display: flex;
    gap: 5px;
    flex-wrap: wrap;
}
.action-buttons .btn {
    padding: 0.25rem 0.5rem;
    font-size: 0.75rem;
}
/* Hide any Create New Announcement button */
.card-header-links,
a[href*="announcement/create"],
.btn:contains("Create New Announcement") {
    display: none !important;
}
/* Hide any button with Create New Announcement text */
.btn:contains("Create New Announcement"),
a:contains("Create New Announcement") {
    display: none !important;
}
</style>

@push('single-script')
<script>
$(document).ready(function() {
    $('#announcement-dataTable').DataTable({
        processing: true,
        serverSide: false,
        autoWidth: false,
        order: [[6, 'desc']], // Sort by created_at desc
        columnDefs: [
            { orderable: false, targets: [7] } // Action column not sortable
        ]
    });
    
    // Additional JavaScript to hide any Create New Announcement button
    $('a[href*="announcement/create"], .btn:contains("Create New Announcement")').hide();
});
</script>
@endpush
@endsection
