@extends('backend.layouts.app')
@section('title', 'View Announcement')
@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="site-card">
                <div class="site-card-header">
                    <h3 class="title">View Announcement</h3>
                    <div class="card-header-links">
                        <a href="{{ route('admin.announcement.edit', $announcement->id) }}" class="card-header-link">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="{{ route('admin.announcement.index') }}" class="card-header-link">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                    </div>
                </div>
                <div class="site-card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="announcement-details">
                                <h4>{{ $announcement->title }}</h4>
                                <div class="announcement-meta mb-3">
                                    <span class="badge badge-{{ $announcement->type == 'announcement' ? 'info' : ($announcement->type == 'offer' ? 'success' : 'warning') }}">
                                        {{ ucfirst($announcement->type) }}
                                    </span>
                                    <span class="badge badge-{{ $announcement->status == 'active' ? 'success' : 'danger' }}">
                                        {{ ucfirst($announcement->status) }}
                                    </span>
                                    @if($announcement->show_popup)
                                        <span class="badge badge-primary">Popup Enabled</span>
                                    @endif
                                </div>
                                
                                <div class="announcement-content">
                                    {!! nl2br(e($announcement->message)) !!}
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="announcement-info">
                                <h5>Announcement Information</h5>
                                
                                <div class="info-item">
                                    <strong>Type:</strong>
                                    <span class="badge badge-{{ $announcement->type == 'announcement' ? 'info' : ($announcement->type == 'offer' ? 'success' : 'warning') }}">
                                        {{ ucfirst($announcement->type) }}
                                    </span>
                                </div>
                                
                                <div class="info-item">
                                    <strong>Status:</strong>
                                    <span class="badge badge-{{ $announcement->status == 'active' ? 'success' : 'danger' }}">
                                        {{ ucfirst($announcement->status) }}
                                    </span>
                                </div>
                                
                                <div class="info-item">
                                    <strong>Popup:</strong>
                                    @if($announcement->show_popup)
                                        <span class="badge badge-primary">Yes</span>
                                    @else
                                        <span class="badge badge-secondary">No</span>
                                    @endif
                                </div>
                                
                                @if($announcement->start_date)
                                <div class="info-item">
                                    <strong>Start Date:</strong>
                                    <span>{{ $announcement->start_date->format('M d, Y H:i') }}</span>
                                </div>
                                @endif
                                
                                @if($announcement->end_date)
                                <div class="info-item">
                                    <strong>End Date:</strong>
                                    <span>{{ $announcement->end_date->format('M d, Y H:i') }}</span>
                                </div>
                                @endif
                                
                                <div class="info-item">
                                    <strong>Created By:</strong>
                                    <span>{{ $announcement->creator ? $announcement->creator->name : 'System' }}</span>
                                </div>
                                
                                <div class="info-item">
                                    <strong>Created At:</strong>
                                    <span>{{ $announcement->created_at->format('M d, Y H:i') }}</span>
                                </div>
                                
                                @if($announcement->updated_at != $announcement->created_at)
                                <div class="info-item">
                                    <strong>Last Updated:</strong>
                                    <span>{{ $announcement->updated_at->format('M d, Y H:i') }}</span>
                                </div>
                                
                                @if($announcement->updater)
                                <div class="info-item">
                                    <strong>Updated By:</strong>
                                    <span>{{ $announcement->updater->name }}</span>
                                </div>
                                @endif
                                @endif
                            </div>
                            
                            <div class="announcement-actions mt-4">
                                <h5>Actions</h5>
                                
                                <form action="{{ route('admin.announcement.toggle-status', $announcement->id) }}" method="POST" class="d-inline">
                                    @csrf
                                    <button type="submit" class="btn btn-{{ $announcement->status == 'active' ? 'warning' : 'success' }} btn-sm">
                                        <i class="fas fa-{{ $announcement->status == 'active' ? 'pause' : 'play' }}"></i>
                                        {{ $announcement->status == 'active' ? 'Deactivate' : 'Activate' }}
                                    </button>
                                </form>
                                
                                <form action="{{ route('admin.announcement.toggle-popup', $announcement->id) }}" method="POST" class="d-inline">
                                    @csrf
                                    <button type="submit" class="btn btn-{{ $announcement->show_popup ? 'secondary' : 'primary' }} btn-sm">
                                        <i class="fas fa-{{ $announcement->show_popup ? 'eye-slash' : 'eye' }}"></i>
                                        {{ $announcement->show_popup ? 'Disable Popup' : 'Enable Popup' }}
                                    </button>
                                </form>
                                
                                <form action="{{ route('admin.announcement.destroy', $announcement->id) }}" method="POST" class="d-inline delete-form">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger btn-sm" 
                                            onclick="return confirm('Are you sure you want to delete this announcement?')">
                                        <i class="fas fa-trash"></i> Delete
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.announcement-details h4 {
    color: #333;
    margin-bottom: 15px;
}
.announcement-meta {
    display: flex;
    gap: 10px;
    flex-wrap: wrap;
}
.announcement-content {
    background: #f8f9fa;
    padding: 20px;
    border-radius: 8px;
    border-left: 4px solid #007bff;
    line-height: 1.6;
}
.announcement-info {
    background: #f8f9fa;
    padding: 20px;
    border-radius: 8px;
}
.info-item {
    margin-bottom: 15px;
    padding-bottom: 10px;
    border-bottom: 1px solid #dee2e6;
}
.info-item:last-child {
    border-bottom: none;
    margin-bottom: 0;
}
.info-item strong {
    display: block;
    margin-bottom: 5px;
    color: #495057;
}
.announcement-actions {
    background: #f8f9fa;
    padding: 20px;
    border-radius: 8px;
}
.announcement-actions .btn {
    margin-bottom: 10px;
    margin-right: 10px;
}
</style>
@endsection

