<h3 class="title mb-4">
    {{ __('Deposit Approval Action') }}
</h3>

<ul class="list-group mb-4">
    <li class="list-group-item">
        {{ __('Total amount') }}: <strong>{{ $data->final_amount. ' '.$currency }}</strong>
    </li>
    @if($data->pay_currency != $currency)
        <li class="list-group-item">
            {{ __('Conversion amount') }}: <strong>{{ $data->pay_amount. ' '.$data->pay_currency }}</strong>
        </li>
    @endif

</ul>

<ul class="list-group mb-4">
    <!-- Payment Proof Section -->
    <li class="list-group-item">
        <strong>Payment Proof:</strong>
        @if($data->proof_file)
            @php
                $proofPath = $data->proof_file;
                $fileName = basename($proofPath);
                
                // Check if file exists in storage/app/public/
                $storagePath = storage_path('app/public/' . $fileName);
                
                // For display, we need to use the correct public path
                $publicPath = 'storage/' . $fileName;
                $assetPath = asset($publicPath);
                
                // Also check legacy path (assets/storage)
                $legacyPath = public_path('assets/storage/' . $fileName);
                
                $fileExists = file_exists($storagePath) || file_exists($legacyPath);
            @endphp
            @if($fileExists)
                <div class="deposit-proof-image">
                    <img src="{{ $assetPath }}" alt="Deposit Proof" class="img-fluid" style="max-width: 300px; max-height: 200px; border-radius: 8px; margin-top: 10px;"/>
                    <br>
                    <a href="{{ $assetPath }}" target="_blank" class="btn btn-sm btn-outline-primary mt-2">
                        <i class="fas fa-external-link-alt"></i> View Full Size
                    </a>
                </div>
            @else
                <div class="deposit-proof-missing">
                    <div class="alert alert-warning" style="margin-top: 10px;">
                        <i class="fas fa-exclamation-triangle"></i>
                        <strong>Proof Image Missing</strong><br>
                        <small>Image file not found on server. This might be an old transaction or upload failed.</small>
                    </div>
                    <div class="mt-2">
                        <strong>Database Path:</strong> {{ $proofPath }}<br>
                        <strong>Storage Path:</strong> {{ $storagePath }}<br>
                        <strong>Legacy Path:</strong> {{ $legacyPath }}<br>
                        <strong>Storage Exists:</strong> <span class="{{ file_exists($storagePath) ? 'text-success' : 'text-danger' }}">{{ file_exists($storagePath) ? 'Yes' : 'No' }}</span><br>
                        <strong>Legacy Exists:</strong> <span class="{{ file_exists($legacyPath) ? 'text-success' : 'text-danger' }}">{{ file_exists($legacyPath) ? 'Yes' : 'No' }}</span><br>
                        <strong>Status:</strong> <span class="text-danger">File not found in any location</span>
                    </div>
                    
                    <!-- Option to mark for re-upload -->
                    <div class="mt-3">
                        <button type="button" class="btn btn-sm btn-warning" onclick="requestReUpload('{{ $data->id }}')">
                            <i class="fas fa-upload"></i> Request Re-upload from User
                        </button>
                    </div>
                </div>
            @endif
        @else
            <span class="text-muted">No payment proof uploaded</span>
        @endif
    </li>

    <!-- Transaction Hash -->
    @if($data->transaction_hash)
        <li class="list-group-item">
            <strong>Transaction Hash:</strong>
            <span class="text-dark">{{ $data->transaction_hash }}</span>
        </li>
    @endif

    <!-- Notes -->
    @if($data->notes)
        <li class="list-group-item">
            <strong>Notes:</strong>
            <span class="text-dark">{{ $data->notes }}</span>
        </li>
    @endif

    <!-- Manual Field Data (Legacy Support) -->
    @if($data->manual_field_data)
        @php
            $manualData = json_decode($data->manual_field_data, true);
        @endphp
        @if($manualData)
            @foreach($manualData as $key => $value)
                @if($key !== 'Payment Proof' && !empty($value))
                    <li class="list-group-item">
                        <strong>{{ $key }}:</strong>
                        <span class="text-dark">{{ $value }}</span>
                    </li>
                @endif
            @endforeach
        @endif
    @endif
</ul>

<form action="{{ route('admin.deposit.action.now') }}" method="post" id="depositActionForm">
    @csrf
    <input type="hidden" name="deposit_id" value="{{ $id }}">
    <input type="hidden" name="action_type" id="action_type" value="">

    <div class="site-input-groups">
        <label for="payment_type" class="box-input-label">{{ __('Payment Type') }}</label>
        <select name="payment_type" id="payment_type" class="form-control" onchange="togglePaymentFields()">
            <option value="">Select Payment Type</option>
            <option value="bank_transfer">Bank Transfer</option>
            <option value="crypto">Cryptocurrency</option>
        </select>
    </div>

    <!-- Bank Transfer Fields -->
    <div id="bank_transfer_fields" style="display: none;">
        <div class="site-input-groups">
            <label for="account_number" class="box-input-label">{{ __('Account Number') }}</label>
            <input type="text" name="account_number" id="account_number" class="form-control" placeholder="Enter Account Number">
        </div>
        
        <div class="site-input-groups">
            <label for="transaction_id" class="box-input-label">{{ __('Transaction ID') }}</label>
            <input type="text" name="transaction_id" id="transaction_id" class="form-control" placeholder="Enter Transaction ID">
        </div>
        
        <div class="site-input-groups">
            <label for="account_name" class="box-input-label">{{ __('Account Name') }}</label>
            <input type="text" name="account_name" id="account_name" class="form-control" placeholder="Enter Account Name">
        </div>
    </div>

    <!-- Crypto Fields -->
    <div id="crypto_fields" style="display: none;">
        <div class="site-input-groups">
            <label for="wallet_address" class="box-input-label">{{ __('Wallet Address') }}</label>
            <input type="text" name="wallet_address" id="wallet_address" class="form-control" placeholder="Enter Wallet Address">
        </div>
        
        <div class="site-input-groups">
            <label for="transaction_hash" class="box-input-label">{{ __('Transaction Hash') }}</label>
            <input type="text" name="transaction_hash" id="transaction_hash" class="form-control" placeholder="Enter Transaction Hash">
        </div>
        
        <div class="site-input-groups">
            <label for="crypto_type" class="box-input-label">{{ __('Cryptocurrency Type') }}</label>
            <select name="crypto_type" id="crypto_type" class="form-control">
                <option value="">Select Crypto Type</option>
                <option value="bitcoin">Bitcoin (BTC)</option>
                <option value="ethereum">Ethereum (ETH)</option>
                <option value="usdt">Tether (USDT)</option>
                <option value="usdc">USD Coin (USDC)</option>
                <option value="binance">Binance Coin (BNB)</option>
                <option value="other">Other</option>
            </select>
        </div>
    </div>

    <div class="site-input-groups">
        <label for="" class="box-input-label">{{ __('Details Message(Optional)') }}</label>
        <textarea name="admin_notes" class="form-textarea mb-0" placeholder="Details Message"></textarea>
    </div>

    <div class="action-btns">
        <button type="button" onclick="submitAction('approve')" class="site-btn-sm primary-btn me-2">
            <i icon-name="check"></i>
            {{ __('Approve') }}
        </button>
        <button type="button" onclick="submitAction('reject')" class="site-btn-sm red-btn">
            <i icon-name="x"></i>
            {{ __('Reject') }}
        </button>
    </div>

</form>

<script>
function togglePaymentFields() {
    const paymentType = document.getElementById('payment_type').value;
    const bankFields = document.getElementById('bank_transfer_fields');
    const cryptoFields = document.getElementById('crypto_fields');
    
    // Hide all fields first
    bankFields.style.display = 'none';
    cryptoFields.style.display = 'none';
    
    // Show relevant fields based on selection
    if (paymentType === 'bank_transfer') {
        bankFields.style.display = 'block';
    } else if (paymentType === 'crypto') {
        cryptoFields.style.display = 'block';
    }
}

function submitAction(action) {
    document.getElementById('action_type').value = action;
    
    // Show loading state
    const buttons = document.querySelectorAll('.action-btns button');
    buttons.forEach(btn => {
        btn.disabled = true;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Processing...';
    });
    
    // Submit form via AJAX
    const form = document.getElementById('depositActionForm');
    const formData = new FormData(form);
    
    fetch(form.action, {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Show success message
            alert(data.message);
            // Reload page to show updated status
            window.location.reload();
        } else {
            alert('Error: ' + data.message);
            // Reset buttons
            location.reload();
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Error processing request');
        location.reload();
    });
}

function requestReUpload(transactionId) {
    if (confirm('This will notify the user to re-upload their payment proof. Continue?')) {
        // Here you could make an AJAX call to mark transaction for re-upload
        alert('Feature coming soon: User will be notified to re-upload payment proof.');
        // TODO: Implement notification system for re-upload requests
    }
}
</script>
<script>
    'use strict';
    lucide.createIcons();
</script>



