@if($status == 'ongoing')

    <div>
        <strong><span id="days{{ $id }}"></span>D : <span id="hours{{ $id }}"></span>H : <span
                id="minutes{{ $id }}"></span>M : <span id="seconds{{ $id }}"></span>S</strong>
        <span class="site-badge primary-bg ms-2" id="percentage{{ $id }}"></span>
    </div>
    <div class="progress investment-timeline">
        <div class="progress-bar progress-bar-striped progress-bar-animated" id="time-progress{{ $id }}"
             role="progressbar" aria-valuenow="75" aria-valuemin="0" aria-valuemax="100"></div>
    </div>
    <script>

        (function ($) {
            "use strict";
            // Countdown
            const second = 1000,
                minute = second * 60,
                hour = minute * 60,
                day = hour * 24;
            let timezone = @json(setting('site_timezone','global'));
            console.log('Site Timezone:', timezone);

            // Parse dates properly with timezone consideration
            let countDown = new Date('{{$next_profit_time}}');
            let start = new Date('{{ $last_profit_time ?? $created_at}}');
            
            console.log('Countdown Date:', countDown);
            console.log('Start Date:', start);
            
            // Convert to UTC for consistent calculation
            let countDownUTC = countDown.getTime();
            let startUTC = start.getTime();
            
            setInterval(function () {
                // Get current time in the site timezone
                let now = new Date();
                let nowInTimezone = new Date(now.toLocaleString("en-US", {timeZone: timezone}));
                let nowUTC = nowInTimezone.getTime();

                let distance = countDownUTC - nowUTC;
                
                // Calculate progress percentage
                let totalDuration = countDownUTC - startUTC;
                let elapsed = nowUTC - startUTC;
                let progress = totalDuration > 0 ? Math.min(100, Math.max(0, (elapsed / totalDuration) * 100)) : 0;

                // Update progress bar
                $("#time-progress{{ $id }}").css("width", progress.toFixed(2) + '%');
                $("#percentage{{ $id }}").text(progress >= 100 ? '100%' : progress.toFixed(1) + '%');

                // Update countdown display
                if (distance <= 0) {
                    // Timer expired
                    document.getElementById('days{{ $id }}').innerText = '0';
                    document.getElementById('hours{{ $id }}').innerText = '0';
                    document.getElementById('minutes{{ $id }}').innerText = '0';
                    document.getElementById('seconds{{ $id }}').innerText = '0';
                    
                    // No auto reload on admin; let user refresh manually
                    // if (progress >= 100) { /* manual reload only */ }
                } else {
                    // Update timer display
                    document.getElementById('days{{ $id }}').innerText = Math.floor(distance / day);
                    document.getElementById('hours{{ $id }}').innerText = Math.floor((distance % day) / hour);
                    document.getElementById('minutes{{ $id }}').innerText = Math.floor((distance % hour) / minute);
                    document.getElementById('seconds{{ $id }}').innerText = Math.floor((distance % minute) / second);
                }

            }, second)

        })(jQuery)

    </script>
@elseif($status == 'completed')
    <div class="site-badge success">{{ __('Completed') }}</div>
    <div class="progress investment-timeline">
        <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuenow="75"
             aria-valuemin="0" aria-valuemax="100" style="width: 100%"></div>
    </div>
@elseif($status == 'pending')
    <div class="site-badge pending">{{ __('Pending') }}</div>
@elseif($status == 'canceled')
    <div class="site-badge pending">{{ __('Canceled') }}</div>
@endif
