@extends('backend.layouts.master')

@section('title', 'Create Manual Payment Gateway')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Create Manual Payment Gateway</h3>
                    <div class="card-tools">
                        <a href="{{ route('admin.manual-payment-gateways.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.manual-payment-gateways.store') }}" method="POST">
                        @csrf
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name">Gateway Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                           id="name" name="name" value="{{ old('name') }}" required>
                                    @error('name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="code">Gateway Code <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('code') is-invalid @enderror" 
                                           id="code" name="code" value="{{ old('code') }}" required>
                                    <small class="form-text text-muted">Unique identifier (e.g., bep20, bitcoin, ethereum)</small>
                                    @error('code')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="wallet_address">Wallet Address <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('wallet_address') is-invalid @enderror" 
                                           id="wallet_address" name="wallet_address" value="{{ old('wallet_address') }}" required>
                                    @error('wallet_address')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="network">Network</label>
                                    <input type="text" class="form-control @error('network') is-invalid @enderror" 
                                           id="network" name="network" value="{{ old('network') }}">
                                    <small class="form-text text-muted">e.g., BEP20, Bitcoin, Ethereum</small>
                                    @error('network')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="qr_code">QR Code URL</label>
                            <input type="url" class="form-control @error('qr_code') is-invalid @enderror" 
                                   id="qr_code" name="qr_code" value="{{ old('qr_code') }}">
                            <small class="form-text text-muted">Leave empty to auto-generate from wallet address</small>
                            @error('qr_code')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="payment_instructions">Payment Instructions</label>
                            <textarea class="form-control @error('payment_instructions') is-invalid @enderror" 
                                      id="payment_instructions" name="payment_instructions" rows="3">{{ old('payment_instructions') }}</textarea>
                            @error('payment_instructions')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="minimum_amount">Minimum Amount <span class="text-danger">*</span></label>
                                    <input type="number" step="0.01" class="form-control @error('minimum_amount') is-invalid @enderror" 
                                           id="minimum_amount" name="minimum_amount" value="{{ old('minimum_amount', 10) }}" required>
                                    @error('minimum_amount')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="maximum_amount">Maximum Amount <span class="text-danger">*</span></label>
                                    <input type="number" step="0.01" class="form-control @error('maximum_amount') is-invalid @enderror" 
                                           id="maximum_amount" name="maximum_amount" value="{{ old('maximum_amount', 10000) }}" required>
                                    @error('maximum_amount')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="currency">Currency <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('currency') is-invalid @enderror" 
                                           id="currency" name="currency" value="{{ old('currency', 'USDT') }}" required>
                                    @error('currency')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="currency_symbol">Currency Symbol <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('currency_symbol') is-invalid @enderror" 
                                           id="currency_symbol" name="currency_symbol" value="{{ old('currency_symbol', '$') }}" required>
                                    @error('currency_symbol')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="fee_percentage">Fee Percentage (%)</label>
                                    <input type="number" step="0.01" class="form-control @error('fee_percentage') is-invalid @enderror" 
                                           id="fee_percentage" name="fee_percentage" value="{{ old('fee_percentage', 0) }}">
                                    @error('fee_percentage')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="fee_fixed">Fixed Fee</label>
                                    <input type="number" step="0.01" class="form-control @error('fee_fixed') is-invalid @enderror" 
                                           id="fee_fixed" name="fee_fixed" value="{{ old('fee_fixed', 0) }}">
                                    @error('fee_fixed')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="sort_order">Sort Order</label>
                                    <input type="number" class="form-control @error('sort_order') is-invalid @enderror" 
                                           id="sort_order" name="sort_order" value="{{ old('sort_order', 0) }}">
                                    @error('sort_order')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="status">Status</label>
                                    <select class="form-control @error('status') is-invalid @enderror" id="status" name="status">
                                        <option value="1" {{ old('status', 1) == 1 ? 'selected' : '' }}>Active</option>
                                        <option value="0" {{ old('status') == 0 ? 'selected' : '' }}>Inactive</option>
                                    </select>
                                    @error('status')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Create Gateway
                            </button>
                            <a href="{{ route('admin.manual-payment-gateways.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> Cancel
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection














