@php
    $schemas = \App\Models\Schema::where('status',true)->ordered()->with('schedule')->get();
@endphp
<!-- Modern Investment Plans Section -->
<section class="modern-plans-section">
    <div class="plans-bg-animation">
        <div class="bg-shapes">
            <div class="bg-shape shape-1"></div>
            <div class="bg-shape shape-2"></div>
            <div class="bg-shape shape-3"></div>
        </div>
    </div>
    
    <div class="container">
        <!-- Section Header -->
        <div class="row justify-content-center">
            <div class="col-xl-8 col-lg-10">
                <div class="modern-section-header text-center" data-aos="fade-up" data-aos-duration="1000">
                    <div class="section-badge">
                        <span class="badge-icon">💎</span>
                        <span class="badge-text">{{ $data['title_small'] }}</span>
                    </div>
                    <h2 class="section-title-modern">
                        <span class="title-highlight">{{ $data['title_big'] }}</span>
                    </h2>
                    <p class="section-subtitle">Choose the perfect investment plan that matches your financial goals and risk appetite</p>
                </div>
            </div>
        </div>
        
        <!-- Plans Grid -->
        <div class="row justify-content-center">
            @foreach($schemas as $index => $schema)
                <div class="col-xl-4 col-lg-6 col-md-6 col-12 mb-4">
                    <div class="modern-plan-card {{ $index == 1 ? 'featured-plan' : '' }}" 
                         data-aos="fade-up" data-aos-duration="{{ 1200 + ($index * 200) }}">
                        
                        @if($schema->badge)
                            <div class="plan-badge">
                                <span class="badge-text">{{ $schema->badge }}</span>
                                <div class="badge-shine"></div>
                            </div>
                        @endif
                        
                        <!-- Plan Header -->
                        <div class="plan-header">
                            <div class="plan-icon-wrapper">
                                <img src="{{ asset($schema->icon) }}" alt="{{ $schema->name }}" class="plan-icon"/>
                                <div class="icon-glow"></div>
                            </div>
                            <h3 class="plan-name">{{ $schema->name }}</h3>
                            <div class="plan-return">
                                <span class="return-rate">{{ $schema->interest_type == 'percentage' ? $schema->return_interest.'%' : $currencySymbol.$schema->return_interest }}</span>
                                <span class="return-period">{{ $schema->schedule->name }}</span>
                            </div>
                        </div>
                        
                        <!-- Plan Features -->
                        <div class="plan-features">
                            <div class="feature-item">
                                <i class="feature-icon anticon anticon-dollar"></i>
                                <span class="feature-text">
                                    Min: {{ $currencySymbol }}{{ $schema->minimum_amount }} - 
                                    Max: {{ $schema->maximum_amount ? $currencySymbol.$schema->maximum_amount : 'Unlimited' }}
                                </span>
                            </div>
                            <div class="feature-item">
                                <i class="feature-icon anticon anticon-clock-circle"></i>
                                <span class="feature-text">{{ $schema->schedule->name }} Returns</span>
                            </div>
                            <div class="feature-item">
                                <i class="feature-icon anticon anticon-safety"></i>
                                <span class="feature-text">Principal {{ $schema->capital_back ? 'Included' : 'Not Included' }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="feature-icon anticon anticon-team"></i>
                                <span class="feature-text">24/7 Support</span>
                            </div>
                        </div>
                        
                        <!-- Investment Calculator -->
                        <div class="plan-calculator">
                            <div class="calc-input-group">
                                <label class="calc-label">Investment Amount</label>
                                <div class="calc-input-wrapper">
                                    <span class="currency-symbol">{{ $currencySymbol }}</span>
                                    <input type="number" class="calc-input" 
                                           value="{{ $schema->minimum_amount }}" 
                                           min="{{ $schema->minimum_amount }}" 
                                           max="{{ $schema->maximum_amount ?: 999999 }}"
                                           data-plan-id="{{ $schema->id }}">
                                </div>
                            </div>
                            <div class="calc-result">
                                <div class="result-item">
                                    <span class="result-label">You'll Receive:</span>
                                    <span class="result-value" id="result-{{ $schema->id }}">
                                        {{ $currencySymbol }}{{ number_format($schema->minimum_amount * ($schema->interest_type == 'percentage' ? ($schema->return_interest/100) : 1), 2) }}
                                    </span>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Action Button -->
                        <div class="plan-action">
                            <a href="{{ route('user.schema.preview', $schema->id) }}" class="btn-plan-select">
                                <span class="btn-text">
                                    <i class="anticon anticon-rocket"></i>
                                    Invest Now
                                </span>
                                <div class="btn-glow"></div>
                            </a>
                        </div>
                        
                        <!-- Card Glow Effect -->
                        <div class="card-glow"></div>
                    </div>
                </div>
            @endforeach
        </div>
        
        <!-- Additional Info -->
        <div class="row justify-content-center mt-5">
            <div class="col-xl-10">
                <div class="plans-info-cards" data-aos="fade-up" data-aos-duration="1600">
                    <div class="info-card">
                        <div class="info-icon">
                            <i class="anticon anticon-safety-certificate"></i>
                        </div>
                        <div class="info-content">
                            <h4>Secure Investment</h4>
                            <p>Your investments are protected with bank-level security</p>
                        </div>
                    </div>
                    <div class="info-card">
                        <div class="info-icon">
                            <i class="anticon anticon-thunderbolt"></i>
                        </div>
                        <div class="info-content">
                            <h4>Instant Deposits</h4>
                            <p>Start earning immediately with instant deposit processing</p>
                        </div>
                    </div>
                    <div class="info-card">
                        <div class="info-icon">
                            <i class="anticon anticon-trophy"></i>
                        </div>
                        <div class="info-content">
                            <h4>Proven Track Record</h4>
                            <p>Join thousands of successful investors worldwide</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

