<div class="row user-cards ">
    <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
        <div class="single">
            <div class="icon"><i class="anticon anticon-inbox"></i></div>
            <div class="content">
                <h4><span class="count">{{ $dataCount['total_transaction'] }}</span></h4>
                <p>{{ __('All Transactions') }}</p>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
        <div class="single">
            <div class="icon"><i class="anticon anticon-file-add"></i></div>
            <div class="content">
                <h4><b>{{ $currencySymbol }}</b><span class="count">{{ $dataCount['total_deposit'] }}</span></h4>
                <p>{{ __('Total Deposit') }}</p>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
        <div class="single">
            <div class="icon"><i class="anticon anticon-check-square"></i></div>
            <div class="content">
                <h4><b>{{ $currencySymbol }}</b><span class="count">{{ $dataCount['total_investment'] }}</span></h4>
                <p>{{ __('Total Investment') }}</p>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
        <div class="single">
            <div class="icon"><i class="anticon anticon-credit-card"></i></div>
            <div class="content">
                <h4><b>{{ $currencySymbol }}</b><span class="count">{{ $dataCount['total_profit'] }}</span></h4>
                <p>{{ __('Total Profit') }}</p>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
        <div class="single">
            <div class="icon"><i class="anticon anticon-arrow-right"></i></div>
            <div class="content">
                <h4><b>{{ $currencySymbol }}</b><span class="count">{{ $dataCount['total_transfer'] }}</span></h4>
                <p>{{ __('Total Transfer ') }}</p>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
        <div class="single">
            <div class="icon"><i class="anticon anticon-money-collect"></i></div>
            <div class="content">
                <h4><b>{{ $currencySymbol }}</b><span class="count">{{ $dataCount['total_withdraw'] }}</span></h4>
                <p>{{ __('Total Withdraw') }}</p>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
        <div class="single">
            <div class="icon"><i class="anticon anticon-gift"></i></div>
            <div class="content">
                <h4><b>{{ $currencySymbol }}</b><span class="count">{{ $dataCount['total_referral_profit'] }}</span>
                </h4>
                <p>{{ __('Referral Bonus') }}</p>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
        <div class="single">
            <div class="icon"><i class="anticon anticon-account-book"></i></div>
            <div class="content">
                <h4><b>{{ $currencySymbol }}</b><span class="count">{{ $dataCount['deposit_bonus'] }}</span></h4>
                <p>{{ __('Deposit Bonus') }}</p>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
        <div class="single">
            <div class="icon"><i class="anticon anticon-gold"></i></div>
            <div class="content">
                <h4><b>{{ $currencySymbol }}</b><span class="count">{{ $dataCount['investment_bonus'] }}</span></h4>
                <p>{{ __('Investment Bonus') }}</p>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
        <div class="single">
            <div class="icon"><i class="anticon anticon-inbox"></i></div>
            <div class="content">
                <h4 class="count">{{ $dataCount['total_referral'] }}</h4>
                <p>{{ __('Total Referral') }}</p>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
        <div class="single">
            <div class="icon"><i class="anticon anticon-radar-chart"></i></div>
            <div class="content">
                <h4 class="count">{{ $dataCount['rank_achieved'] }}</h4>
                <p>{{ __('Rank Achieved') }}</p>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
        <div class="single">
            <div class="icon"><i class="anticon anticon-question"></i></div>
            <div class="content">
                <h4 class="count">{{ $dataCount['total_ticket'] }}</h4>
                <p>{{ __('Total Ticket') }}</p>
            </div>
        </div>
    </div>
</div>

<!-- Live Stock Market Chart Widget for Default Theme -->
<div class="row" style="margin-top: 30px;">
    <div class="col-12">
        <div class="site-card" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 15px; padding: 20px; box-shadow: 0 10px 30px rgba(0,0,0,0.3);">
            <div style="background: rgba(255,255,255,0.1); border-radius: 10px; padding: 15px; backdrop-filter: blur(10px);">
                <div class="site-card-header" style="border-bottom: none; padding-bottom: 0; margin-bottom: 15px;">
                    <h3 style="color: white; text-align: center; font-weight: 600; margin: 0;">
                        <i class="anticon anticon-line-chart" style="margin-right: 8px;"></i>Live Stock Exchange & Forex Market
                    </h3>
                </div>
                
                <!-- Enhanced TradingView Ticker Tape -->
                <div class="tradingview-widget-container" style="margin-bottom: 20px;">
                    <div class="tradingview-widget-container__widget"></div>
                    <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-ticker-tape.js" async>
                    {
                        "symbols": [
                            {
                                "proName": "FOREXCOM:SPXUSD",
                                "title": "S&P 500"
                            },
                            {
                                "proName": "FOREXCOM:NSXUSD", 
                                "title": "NASDAQ"
                            },
                            {
                                "proName": "FOREXCOM:DJI",
                                "title": "Dow Jones"
                            },
                            {
                                "proName": "FX:EURUSD",
                                "title": "EUR/USD"
                            },
                            {
                                "proName": "FX:GBPUSD",
                                "title": "GBP/USD"
                            },
                            {
                                "proName": "FX:USDJPY",
                                "title": "USD/JPY"
                            },
                            {
                                "proName": "TVC:GOLD",
                                "title": "Gold"
                            },
                            {
                                "proName": "NYMEX:CL1!",
                                "title": "Crude Oil"
                            },
                            {
                                "proName": "BINANCE:BTCUSDT",
                                "title": "Bitcoin"
                            },
                            {
                                "proName": "BINANCE:ETHUSDT",
                                "title": "Ethereum"
                            }
                        ],
                        "showSymbolLogo": true,
                        "colorTheme": "light",
                        "isTransparent": true,
                        "displayMode": "adaptive",
                        "locale": "en"
                    }
                    </script>
                </div>

                <!-- Live Price Display Grid -->
                <div class="row">
                    <div class="col-md-2 col-sm-4 col-6" style="margin-bottom: 15px;">
                        <div style="background: rgba(255,255,255,0.2); border-radius: 8px; padding: 12px; text-align: center;">
                            <div style="color: #fff; font-size: 11px; margin-bottom: 3px;">S&P 500</div>
                            <div id="sp500-price-default" style="color: #00ff88; font-size: 14px; font-weight: bold;">Loading...</div>
                        </div>
                    </div>
                    <div class="col-md-2 col-sm-4 col-6" style="margin-bottom: 15px;">
                        <div style="background: rgba(255,255,255,0.2); border-radius: 8px; padding: 12px; text-align: center;">
                            <div style="color: #fff; font-size: 11px; margin-bottom: 3px;">NASDAQ</div>
                            <div id="nasdaq-price-default" style="color: #00ff88; font-size: 14px; font-weight: bold;">Loading...</div>
                        </div>
                    </div>
                    <div class="col-md-2 col-sm-4 col-6" style="margin-bottom: 15px;">
                        <div style="background: rgba(255,255,255,0.2); border-radius: 8px; padding: 12px; text-align: center;">
                            <div style="color: #fff; font-size: 11px; margin-bottom: 3px;">EUR/USD</div>
                            <div id="eurusd-price-default" style="color: #00ff88; font-size: 14px; font-weight: bold;">Loading...</div>
                        </div>
                    </div>
                    <div class="col-md-2 col-sm-4 col-6" style="margin-bottom: 15px;">
                        <div style="background: rgba(255,255,255,0.2); border-radius: 8px; padding: 12px; text-align: center;">
                            <div style="color: #fff; font-size: 11px; margin-bottom: 3px;">Gold</div>
                            <div id="gold-price-default" style="color: #ffd700; font-size: 14px; font-weight: bold;">Loading...</div>
                        </div>
                    </div>
                    <div class="col-md-2 col-sm-4 col-6" style="margin-bottom: 15px;">
                        <div style="background: rgba(255,255,255,0.2); border-radius: 8px; padding: 12px; text-align: center;">
                            <div style="color: #fff; font-size: 11px; margin-bottom: 3px;">Bitcoin</div>
                            <div id="btc-price-default" style="color: #ff9500; font-size: 14px; font-weight: bold;">Loading...</div>
                        </div>
                    </div>
                    <div class="col-md-2 col-sm-4 col-6" style="margin-bottom: 15px;">
                        <div style="background: rgba(255,255,255,0.2); border-radius: 8px; padding: 12px; text-align: center;">
                            <div style="color: #fff; font-size: 11px; margin-bottom: 3px;">Oil</div>
                            <div id="oil-price-default" style="color: #00ff88; font-size: 14px; font-weight: bold;">Loading...</div>
                        </div>
                    </div>
                </div>

                <!-- Market Status Indicator -->
                <div style="text-align: center; margin-top: 10px;">
                    <span id="market-status-default" style="background: #00ff88; color: #000; padding: 5px 15px; border-radius: 20px; font-size: 12px; font-weight: bold;">
                        🟢 LIVE MARKET DATA
                    </span>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // Live price updates for Default theme
    async function updateLivePricesDefault() {
        try {
            // Update Bitcoin price
            const btcResponse = await fetch('https://api.binance.com/api/v3/ticker/price?symbol=BTCUSDT');
            const btcData = await btcResponse.json();
            if (document.getElementById('btc-price-default')) {
                document.getElementById('btc-price-default').textContent = '$' + parseFloat(btcData.price).toLocaleString();
            }

            // Update market status
            const now = new Date();
            const marketHours = now.getUTCHours();
            const isWeekend = now.getUTCDay() === 0 || now.getUTCDay() === 6;
            
            const statusEl = document.getElementById('market-status-default');
            if (statusEl) {
                if (isWeekend) {
                    statusEl.innerHTML = '🔴 WEEKEND - MARKETS CLOSED';
                    statusEl.style.background = '#ff4757';
                } else if (marketHours >= 13 && marketHours < 21) {
                    statusEl.innerHTML = '🟢 LIVE MARKET DATA';
                    statusEl.style.background = '#00ff88';
                } else {
                    statusEl.innerHTML = '🟡 AFTER HOURS TRADING';
                    statusEl.style.background = '#ffa502';
                }
            }

            // Simulate other prices
            const elements = [
                {id: 'sp500-price-default', value: (4500 + Math.random() * 100).toFixed(2)},
                {id: 'nasdaq-price-default', value: (15000 + Math.random() * 500).toFixed(2)},
                {id: 'eurusd-price-default', value: (1.08 + Math.random() * 0.02).toFixed(4)},
                {id: 'gold-price-default', value: '$' + (2000 + Math.random() * 50).toFixed(2)},
                {id: 'oil-price-default', value: '$' + (75 + Math.random() * 5).toFixed(2)}
            ];

            elements.forEach(el => {
                const element = document.getElementById(el.id);
                if (element) element.textContent = el.value;
            });

        } catch (error) {
            console.log('Error fetching prices:', error);
        }
    }

    // Update prices immediately and then every 30 seconds
    updateLivePricesDefault();
    setInterval(updateLivePricesDefault, 30000);
</script>
