@extends('frontend::layouts.user')
@section('title')
    {{ __('Withdraw Funds') }}
@endsection
@section('content')
<div class="row justify-content-center">
    <div class="col-12 col-lg-10 col-xl-8">
        <div class="site-card" style="background: rgba(255,255,255,0.1); backdrop-filter: blur(10px); border-radius: 15px; border: 1px solid rgba(255,255,255,0.2);">
            <div class="site-card-header">
                <h3 class="title">💰 {{ __('Quick Withdraw') }}</h3>
                <p class="text-muted">{{ __('Easy and secure withdrawals to your preferred payment method') }}</p>
            </div>
            <div class="site-card-body">
                <form action="{{ route('user.withdraw.simple.store') }}" method="post" id="withdrawForm">
                    @csrf
                    
                    <!-- Method Type Selection -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <label class="form-label fw-bold">{{ __('Select Withdrawal Category') }}</label>
                            <div class="row">
                                <div class="col-12 col-sm-6 mb-3">
                                    <div class="method-type-card" onclick="selectMethodType('crypto')">
                                        <input type="radio" name="method_type" value="crypto" id="crypto" style="display: none;">
                                        <div class="card h-100" style="background: rgba(255,255,255,0.05); border: 2px solid transparent; border-radius: 10px; cursor: pointer; transition: all 0.3s;">
                                            <div class="card-body text-center py-3">
                                                <h5 class="mb-2">🚀 {{ __('Cryptocurrency') }}</h5>
                                                <p class="text-muted mb-0 small">{{ __('Solana, Arbitrum, BNB, USDT') }}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-sm-6 mb-3">
                                    <div class="method-type-card" onclick="selectMethodType('banking')">
                                        <input type="radio" name="method_type" value="banking" id="banking" style="display: none;">
                                        <div class="card h-100" style="background: rgba(255,255,255,0.05); border: 2px solid transparent; border-radius: 10px; cursor: pointer; transition: all 0.3s;">
                                            <div class="card-body text-center py-3">
                                                <h5 class="mb-2">🏦 {{ __('Banking Services') }}</h5>
                                                <p class="text-muted mb-0 small">{{ __('EasyPaisa, JazzCash, Bank Transfer') }}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Crypto Methods -->
                    <div id="crypto-methods" class="method-section" style="display: none;">
                        <h5 class="mb-3">🚀 {{ __('Cryptocurrency Methods') }}</h5>
                        <div class="row">
                            @foreach($methods['crypto'] as $key => $method)
                            <div class="col-12 col-sm-6 col-lg-4 mb-3">
                                <div class="method-card" onclick="selectMethod('{{ $key }}', 'crypto')">
                                    <input type="radio" name="method" value="{{ $key }}" id="method_{{ $key }}" style="display: none;">
                                    <div class="card h-100" style="background: rgba(255,255,255,0.05); border: 2px solid transparent; border-radius: 10px; cursor: pointer; transition: all 0.3s;">
                                        <div class="card-body p-3">
                                            <h6 class="mb-2">{{ $method['icon'] }} {{ $method['name'] }}</h6>
                                            <small class="text-muted d-block">
                                                {{ __('Min') }}: {{ $currencySymbol }}{{ $method['min_amount'] }}<br>
                                                {{ __('Max') }}: {{ $currencySymbol }}{{ $method['max_amount'] }}<br>
                                                <span class="badge bg-success mt-1">{{ __('Fee') }}: {{ $method['fee_percentage'] == 0 ? 'FREE' : $method['fee_percentage'].'%' }}</span>
                                            </small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>

                    <!-- Banking Methods -->
                    <div id="banking-methods" class="method-section" style="display: none;">
                        <h5 class="mb-3">🏦 {{ __('Banking Services') }}</h5>
                        <div class="row">
                            @foreach($methods['banking'] as $key => $method)
                            <div class="col-12 col-sm-6 col-lg-4 mb-3">
                                <div class="method-card" onclick="selectMethod('{{ $key }}', 'banking')">
                                    <input type="radio" name="method" value="{{ $key }}" id="method_{{ $key }}" style="display: none;">
                                    <div class="card h-100" style="background: rgba(255,255,255,0.05); border: 2px solid transparent; border-radius: 10px; cursor: pointer; transition: all 0.3s;">
                                        <div class="card-body p-3">
                                            <h6 class="mb-2">{{ $method['icon'] }} {{ $method['name'] }}</h6>
                                            <small class="text-muted d-block">
                                                {{ __('Min') }}: {{ $currencySymbol }}{{ $method['min_amount'] }}<br>
                                                {{ __('Max') }}: {{ $currencySymbol }}{{ $method['max_amount'] }}<br>
                                                <span class="badge bg-success mt-1">{{ __('Fee') }}: {{ $method['fee_percentage'] == 0 ? 'FREE' : $method['fee_percentage'].'%' }}</span>
                                            </small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>

                    <!-- Amount Input -->
                    <div class="row mb-4" id="amount-section" style="display: none;">
                        <div class="col-12 col-md-6 mb-3">
                            <label class="form-label">{{ __('Withdrawal Amount') }}</label>
                            <div class="input-group">
                                <span class="input-group-text">{{ $currencySymbol }}</span>
                                <input type="number" name="amount" id="amount" class="form-control" placeholder="0.00" step="0.01" min="1">
                            </div>
                            <div id="amount-info" class="form-text"></div>
                        </div>
                        <div class="col-12 col-md-6 mb-3">
                            <label class="form-label">{{ __('Your Balance') }}</label>
                            <div class="alert alert-info mb-0">
                                <strong>{{ $currencySymbol }}{{ number_format($user->balance, 2) }}</strong>
                            </div>
                        </div>
                    </div>

                    <!-- Dynamic Fields -->
                    <div id="dynamic-fields" style="display: none;">
                        <!-- Crypto Fields -->
                        <div id="crypto-fields" class="field-group">
                            <div class="row">
                                <div class="col-12 col-md-6 mb-3">
                                    <label class="form-label">{{ __('Wallet Address') }}</label>
                                    <input type="text" name="wallet_address" class="form-control" placeholder="{{ __('Enter your wallet address') }}">
                                </div>
                                <div class="col-12 col-md-6 mb-3" id="network-field" style="display: none;">
                                    <label class="form-label">{{ __('Network') }}</label>
                                    <select name="network" class="form-control">
                                        <option value="">{{ __('Select Network') }}</option>
                                        <option value="TRC20">TRC20 (Tron)</option>
                                        <option value="ERC20">ERC20 (Ethereum)</option>
                                        <option value="BEP20">BEP20 (BSC)</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <!-- Banking Fields -->
                        <div id="banking-fields" class="field-group">
                            <div class="row">
                                <div class="col-12 col-md-6 mb-3">
                                    <label class="form-label">{{ __('Account Number') }}</label>
                                    <input type="text" name="account_number" class="form-control" placeholder="{{ __('Enter account number') }}">
                                </div>
                                <div class="col-12 col-md-6 mb-3">
                                    <label class="form-label">{{ __('Account Title') }}</label>
                                    <input type="text" name="account_title" class="form-control" placeholder="{{ __('Enter account holder name') }}">
                                </div>
                                <div class="col-12 col-md-6 mb-3" id="iban-field" style="display: none;">
                                    <label class="form-label">{{ __('IBAN Number') }}</label>
                                    <input type="text" name="iban" class="form-control" placeholder="{{ __('Enter IBAN number') }}">
                                </div>
                                <div class="col-12 col-md-6 mb-3" id="bank-name-field" style="display: none;">
                                    <label class="form-label">{{ __('Bank Name') }}</label>
                                    <input type="text" name="bank_name" class="form-control" placeholder="{{ __('Enter bank name') }}">
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Fee Calculation -->
                    <div id="fee-calculation" class="alert alert-warning" style="display: none;">
                        <h6>{{ __('Withdrawal Summary') }}</h6>
                        <div class="row">
                            <div class="col-6">{{ __('Amount') }}:</div>
                            <div class="col-6 text-end" id="calc-amount">{{ $currencySymbol }}0.00</div>
                        </div>
                        <div class="row">
                            <div class="col-6">{{ __('Fee') }}:</div>
                            <div class="col-6 text-end" id="calc-fee">{{ $currencySymbol }}0.00</div>
                        </div>
                        <hr>
                        <div class="row fw-bold">
                            <div class="col-6">{{ __('Total Deduction') }}:</div>
                            <div class="col-6 text-end" id="calc-total">{{ $currencySymbol }}0.00</div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <button type="submit" class="btn btn-primary w-100" id="submitBtn" disabled>
                                {{ __('Submit Withdrawal Request') }}
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-12 col-lg-10 col-xl-4 mt-4 mt-xl-0">
        <div class="site-card" style="background: rgba(255,255,255,0.1); backdrop-filter: blur(10px); border-radius: 15px; border: 1px solid rgba(255,255,255,0.2);">
            <div class="site-card-header">
                <h4 class="title">ℹ️ {{ __('Important Information') }}</h4>
            </div>
            <div class="site-card-body">
                <div class="alert alert-info">
                    <h6>⏰ {{ __('Processing Time') }}</h6>
                    <p class="mb-0">{{ __('All withdrawal requests are processed within 24 hours during business days.') }}</p>
                </div>
                
                <div class="alert alert-warning">
                    <h6>🔒 {{ __('Security Note') }}</h6>
                    <p class="mb-0">{{ __('Please ensure your account details are correct. Incorrect details may cause delays or failed transactions.') }}</p>
                </div>
                
                <div class="alert alert-success">
                    <h6>💡 {{ __('Tips') }}</h6>
                    <ul class="mb-0">
                        <li>{{ __('Double-check wallet addresses for crypto withdrawals') }}</li>
                        <li>{{ __('Ensure sufficient balance for fees') }}</li>
                        <li>{{ __('Contact support if you need assistance') }}</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
<script>
const methods = @json($methods);
let selectedMethodType = null;
let selectedMethod = null;
let selectedMethodInfo = null;

function selectMethodType(type) {
    selectedMethodType = type;
    
    // Update UI
    document.querySelectorAll('.method-type-card .card').forEach(card => {
        card.style.borderColor = 'transparent';
    });
    event.currentTarget.querySelector('.card').style.borderColor = '#007bff';
    
    // Show/hide method sections
    document.getElementById('crypto-methods').style.display = type === 'crypto' ? 'block' : 'none';
    document.getElementById('banking-methods').style.display = type === 'banking' ? 'block' : 'none';
    
    // Clear previous method selection
    selectedMethod = null;
    selectedMethodInfo = null;
    document.querySelectorAll('input[name="method"]').forEach(input => input.checked = false);
    document.getElementById('amount-section').style.display = 'none';
    document.getElementById('dynamic-fields').style.display = 'none';
    document.getElementById('fee-calculation').style.display = 'none';
    document.getElementById('submitBtn').disabled = true;
}

function selectMethod(method, type) {
    selectedMethod = method;
    selectedMethodInfo = methods[type][method];
    
    // Update UI
    document.querySelectorAll('.method-card .card').forEach(card => {
        card.style.borderColor = 'transparent';
    });
    event.currentTarget.querySelector('.card').style.borderColor = '#007bff';
    
    // Show amount section
    document.getElementById('amount-section').style.display = 'block';
    document.getElementById('amount-info').innerHTML = 
        `Min: {{ $currencySymbol }}${selectedMethodInfo.min_amount} | Max: {{ $currencySymbol }}${selectedMethodInfo.max_amount} | Fee: ${selectedMethodInfo.fee_percentage}%`;
    
    // Show appropriate fields
    showDynamicFields(type, method);
    
    // Update form values
    document.getElementById(type).checked = true;
    document.getElementById('method_' + method).checked = true;
}

function showDynamicFields(type, method) {
    document.getElementById('dynamic-fields').style.display = 'block';
    
    // Hide all field groups first
    document.querySelectorAll('.field-group').forEach(group => {
        group.style.display = 'none';
    });
    
    if (type === 'crypto') {
        document.getElementById('crypto-fields').style.display = 'block';
        // Show network field only for USDT
        document.getElementById('network-field').style.display = method === 'usdt' ? 'block' : 'none';
    } else if (type === 'banking') {
        document.getElementById('banking-fields').style.display = 'block';
        // Show IBAN and Bank Name only for bank transfer
        document.getElementById('iban-field').style.display = method === 'bank_transfer' ? 'block' : 'none';
        document.getElementById('bank-name-field').style.display = method === 'bank_transfer' ? 'block' : 'none';
    }
}

// Amount change handler
document.getElementById('amount').addEventListener('input', function() {
    const amount = parseFloat(this.value) || 0;
    
    if (selectedMethodInfo) {
        const fee = (amount * selectedMethodInfo.fee_percentage) / 100;
        const total = amount + fee;
        
        document.getElementById('calc-amount').textContent = `{{ $currencySymbol }}${amount.toFixed(2)}`;
        document.getElementById('calc-fee').textContent = `{{ $currencySymbol }}${fee.toFixed(2)}`;
        document.getElementById('calc-total').textContent = `{{ $currencySymbol }}${total.toFixed(2)}`;
        
        if (amount >= selectedMethodInfo.min_amount && amount <= selectedMethodInfo.max_amount) {
            document.getElementById('fee-calculation').style.display = 'block';
            document.getElementById('submitBtn').disabled = false;
        } else {
            document.getElementById('fee-calculation').style.display = 'none';
            document.getElementById('submitBtn').disabled = true;
        }
    }
});

// Form validation
document.getElementById('withdrawForm').addEventListener('submit', function(e) {
    if (!selectedMethodType || !selectedMethod) {
        e.preventDefault();
        alert('Please select a withdrawal method');
        return false;
    }
    
    const amount = parseFloat(document.getElementById('amount').value) || 0;
    if (!selectedMethodInfo || amount < selectedMethodInfo.min_amount || amount > selectedMethodInfo.max_amount) {
        e.preventDefault();
        alert(`Amount must be between {{ $currencySymbol }}${selectedMethodInfo.min_amount} and {{ $currencySymbol }}${selectedMethodInfo.max_amount}`);
        return false;
    }
});
</script>
@endsection