<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Login - {{ setting('site_name','Block Wave Trade') }}</title>
	<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
	<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
	<style>
		:root {
			--bg: #000000;
			--bg2: #1a1a1a;
			--card: #1a1a1a;
			--stroke: #333333;
			--text: #f8fafc;
			--muted: #94a3b8;
			--brand: #fbbf24;
			--brand2: #f59e0b;
			--lime: #fbbf24;
			--neon: #f59e0b;
		}

		* {
			margin: 0;
			padding: 0;
			box-sizing: border-box;
		}

		html, body {
			height: 100%;
			margin: 0;
			padding: 0;
			background: radial-gradient(1200px 700px at 10% -10%, rgba(251,191,36,.08), transparent 50%), 
						radial-gradient(1200px 700px at 110% 10%, rgba(245,158,11,.05), transparent 50%), 
						linear-gradient(180deg, #000000, #1a1a1a);
			color: var(--text);
			font-family: Inter, system-ui, Segoe UI, Roboto, Helvetica, Arial, sans-serif;
			overflow-x: hidden;
		}

		/* Mobile App Container */
		.mobile-app-container {
			min-height: 100vh;
			display: flex;
			flex-direction: column;
			position: relative;
			overflow: hidden;
		}

		/* Background Effects */
		.bg-effects {
			position: absolute;
			inset: 0;
			overflow: hidden;
			pointer-events: none;
			z-index: 1;
		}

		.bg-glow {
			position: absolute;
			inset: -20%;
			background: radial-gradient(closest-side, rgba(251,191,36,.05), transparent 70%);
			filter: blur(40px);
			animation: float 14s ease-in-out infinite;
		}

		.bg-grid {
			position: absolute;
			left: -10%;
			right: -10%;
			bottom: -5%;
			height: 60%;
			background: linear-gradient(transparent, rgba(251,191,36,.03)), 
						repeating-linear-gradient(0deg, rgba(251,191,36,.06) 0 1px, transparent 1px 40px);
			transform: perspective(800px) rotateX(60deg) translateY(40px);
			mask-image: linear-gradient(to top, black, transparent);
		}

		@keyframes float {
			0%, 100% { transform: translateY(0); }
			50% { transform: translateY(16px); }
		}

		/* Header */
		.app-header {
			position: relative;
			z-index: 10;
			padding: 20px;
			text-align: center;
		}

		.logo-container {
			display: flex;
			align-items: center;
			justify-content: center;
			gap: 16px;
			margin-bottom: 20px;
		}

		.logo {
			width: 60px;
			height: 60px;
			border-radius: 16px;
			background: linear-gradient(135deg, #fbbf24, #f59e0b);
			box-shadow: 0 8px 25px rgba(251,191,36,.4), inset 0 0 15px rgba(251,191,36,.2);
			display: flex;
			align-items: center;
			justify-content: center;
			color: #000;
			font-size: 28px;
			animation: logoGlow 3s ease-in-out infinite;
		}

		@keyframes logoGlow {
			0%, 100% { box-shadow: 0 8px 25px rgba(251,191,36,.4), inset 0 0 15px rgba(251,191,36,.2); }
			50% { box-shadow: 0 12px 35px rgba(251,191,36,.6), inset 0 0 20px rgba(251,191,36,.3); }
		}

		.brand-name {
			font-weight: 800;
			font-size: 28px;
			color: white;
			text-transform: uppercase;
			letter-spacing: 2px;
			text-shadow: 0 2px 8px rgba(0,0,0,.5);
		}

		/* Main Content */
		.app-content {
			flex: 1;
			display: flex;
			flex-direction: column;
			align-items: center;
			justify-content: center;
			padding: 40px 20px;
			position: relative;
			z-index: 5;
		}

		/* Auth Card */
		.auth-card {
			width: 100%;
			max-width: 400px;
			background: rgba(26,26,26,.9);
			border: 1px solid rgba(251,191,36,.2);
			border-radius: 24px;
			padding: 40px 32px;
			box-shadow: 0 20px 50px rgba(0,0,0,.4), 0 0 0 1px rgba(251,191,36,.1) inset;
			backdrop-filter: blur(20px);
			position: relative;
			overflow: hidden;
		}

		.auth-card::before {
			content: '';
			position: absolute;
			top: 0;
			left: 0;
			right: 0;
			height: 3px;
			background: linear-gradient(90deg, transparent, #fbbf24, transparent);
		}

		.auth-title {
			font-size: 28px;
			font-weight: 800;
			text-align: center;
			margin: 0 0 8px;
			color: white;
			text-transform: uppercase;
			letter-spacing: 1px;
		}

		.auth-subtitle {
			font-size: 16px;
			text-align: center;
			margin: 0 0 32px;
			color: rgba(255,255,255,.7);
		}

		/* Form Styles */
		.form-group {
			margin-bottom: 24px;
		}

		.form-label {
			display: block;
			font-size: 14px;
			font-weight: 600;
			color: #fbbf24;
			margin-bottom: 8px;
			text-transform: uppercase;
			letter-spacing: 0.5px;
		}

		.required {
			color: #ef4444;
			margin-left: 4px;
		}

		.input-wrapper {
			position: relative;
		}

		.form-input {
			width: 100%;
			padding: 16px 20px 16px 50px;
			background: rgba(0,0,0,.6);
			border: 1px solid rgba(251,191,36,.3);
			border-radius: 12px;
			color: white;
			font-size: 16px;
			font-weight: 500;
			transition: all 0.3s ease;
			outline: none;
		}

		.form-input:focus {
			border-color: #fbbf24;
			box-shadow: 0 0 0 3px rgba(251,191,36,.2);
			background: rgba(0,0,0,.8);
		}

		.form-input::placeholder {
			color: rgba(255,255,255,.5);
		}

		.input-icon {
			position: absolute;
			left: 18px;
			top: 50%;
			transform: translateY(-50%);
			color: #fbbf24;
			font-size: 16px;
			z-index: 2;
		}

		/* Password Toggle */
		.password-toggle {
			position: absolute;
			right: 18px;
			top: 50%;
			transform: translateY(-50%);
			color: rgba(255,255,255,.6);
			font-size: 16px;
			cursor: pointer;
			transition: color 0.3s ease;
			z-index: 2;
		}

		.password-toggle:hover {
			color: #fbbf24;
		}

		/* Remember Me */
		.remember-wrapper {
			display: flex;
			align-items: center;
			justify-content: space-between;
			margin-bottom: 24px;
		}

		.remember-me {
			display: flex;
			align-items: center;
			gap: 8px;
		}

		.remember-checkbox {
			width: 18px;
			height: 18px;
			accent-color: #fbbf24;
		}

		.remember-label {
			font-size: 14px;
			color: rgba(255,255,255,.8);
			cursor: pointer;
		}

		.forgot-link {
			font-size: 14px;
			color: #fbbf24;
			text-decoration: none;
			font-weight: 600;
			transition: color 0.3s ease;
		}

		.forgot-link:hover {
			color: #f59e0b;
		}

		/* Submit Button */
		.submit-btn {
			width: 100%;
			background: linear-gradient(135deg, #fbbf24, #f59e0b);
			color: #000;
			border: none;
			border-radius: 12px;
			padding: 16px;
			font-weight: 800;
			font-size: 16px;
			text-transform: uppercase;
			letter-spacing: 1px;
			box-shadow: 0 8px 25px rgba(251,191,36,.4);
			position: relative;
			overflow: hidden;
			transition: all 0.3s ease;
			cursor: pointer;
			margin-bottom: 24px;
		}

		.submit-btn::before {
			content: '';
			position: absolute;
			top: 0;
			left: -100%;
			width: 100%;
			height: 100%;
			background: linear-gradient(90deg, transparent, rgba(255,255,255,.3), transparent);
			transition: left 0.6s ease;
		}

		.submit-btn:hover::before {
			left: 100%;
		}

		.submit-btn:hover {
			transform: translateY(-2px);
			box-shadow: 0 12px 35px rgba(251,191,36,.5);
		}

		.submit-btn:active {
			transform: translateY(0);
		}

		/* Divider */
		.divider {
			display: flex;
			align-items: center;
			margin: 24px 0;
		}

		.divider::before,
		.divider::after {
			content: '';
			flex: 1;
			height: 1px;
			background: rgba(251,191,36,.3);
		}

		.divider-text {
			padding: 0 16px;
			font-size: 14px;
			color: rgba(255,255,255,.6);
			text-transform: uppercase;
			letter-spacing: 1px;
		}


		/* Sign Up Link */
		.signup-link {
			text-align: center;
			font-size: 14px;
			color: rgba(255,255,255,.7);
		}

		.signup-link a {
			color: #fbbf24;
			text-decoration: none;
			font-weight: 700;
			transition: color 0.3s ease;
		}

		.signup-link a:hover {
			color: #f59e0b;
		}

		/* Error Messages */
		.alert-error {
			background: rgba(239,68,68,.1);
			border: 1px solid rgba(239,68,68,.3);
			border-radius: 8px;
			padding: 12px;
			margin-bottom: 20px;
			color: #ef4444;
			font-size: 14px;
			font-weight: 500;
		}

		/* Success Messages */
		.alert-success {
			background: rgba(16,185,129,.1);
			border: 1px solid rgba(16,185,129,.3);
			border-radius: 8px;
			padding: 12px;
			margin-bottom: 20px;
			color: #10b981;
			font-size: 14px;
			font-weight: 500;
		}

		/* Mobile Responsive */
		@media (max-width: 768px) {
			.app-header {
				padding: 15px;
			}

			.logo {
				width: 50px;
				height: 50px;
				font-size: 24px;
			}

			.brand-name {
				font-size: 24px;
			}

			.app-content {
				padding: 30px 15px;
			}

			.auth-card {
				padding: 32px 24px;
			}

			.auth-title {
				font-size: 24px;
			}
		}

		@media (max-width: 480px) {
			.app-header {
				padding: 10px;
			}

			.logo {
				width: 45px;
				height: 45px;
				font-size: 20px;
			}

			.brand-name {
				font-size: 20px;
			}

			.app-content {
				padding: 20px 10px;
			}

			.auth-card {
				padding: 24px 20px;
			}

			.auth-title {
				font-size: 22px;
			}
		}

		/* Loading Animation */
		.loading-overlay {
			position: fixed;
			top: 0;
			left: 0;
			width: 100%;
			height: 100%;
			background: rgba(0,0,0,.9);
			display: none;
			align-items: center;
			justify-content: center;
			z-index: 9999;
			opacity: 0;
			transition: opacity 0.5s ease;
		}

		.loading-overlay.show {
			display: flex;
			opacity: 1;
		}

		.loading-spinner {
			width: 50px;
			height: 50px;
			border: 4px solid rgba(251,191,36,.2);
			border-top: 4px solid #fbbf24;
			border-radius: 50%;
			animation: spin 1s linear infinite;
		}

		@keyframes spin {
			0% { transform: rotate(0deg); }
			100% { transform: rotate(360deg); }
		}

		.loading-text {
			color: #fbbf24;
			font-size: 16px;
			font-weight: 600;
			margin-top: 16px;
			text-align: center;
		}
	</style>
</head>
<body>
	<!-- Loading Overlay -->
	<div class="loading-overlay" id="loadingOverlay">
		<div style="text-align: center;">
			<div class="loading-spinner"></div>
			<div class="loading-text">Signing in...</div>
		</div>
	</div>

	<!-- Background Effects -->
	<div class="bg-effects">
		<div class="bg-glow"></div>
		<div class="bg-grid"></div>
	</div>

	<!-- Mobile App Container -->
	<div class="mobile-app-container">
		<!-- Header -->
		<header class="app-header">
			<div class="logo-container">
				<div class="logo">
					<i class="fas fa-coins"></i>
				</div>
				<div class="brand-name">{{ setting('site_name','Block Wave Trade') }}</div>
			</div>
		</header>

		<!-- Main Content -->
		<main class="app-content">
			<div class="auth-card">
				<h1 class="auth-title">Welcome Back!</h1>
				<p class="auth-subtitle">Sign in to your account</p>

				@if ($errors->any())
					<div class="alert-error">
						@foreach($errors->all() as $error)
							<span>{{ $error }}</span>
						@endforeach
					</div>
				@endif

				@if (session('success'))
					<div class="alert-success">
						{{ session('success') }}
					</div>
				@endif

				<form action="{{ route('login') }}" method="POST" id="loginForm">
					@csrf
					
					<div class="form-group">
						<label for="login" class="form-label">Email Or Username<span class="required">*</span></label>
						<div class="input-wrapper">
							<input type="text" id="login" name="login" value="{{ old('login') }}" required autofocus class="form-input" placeholder="Enter your email or username">
							<i class="fas fa-user input-icon"></i>
						</div>
					</div>

					<div class="form-group">
						<label for="password" class="form-label">Password<span class="required">*</span></label>
						<div class="input-wrapper">
							<input type="password" id="password" name="password" required class="form-input" placeholder="Enter your password">
							<i class="fas fa-lock input-icon"></i>
							<span class="password-toggle" onclick="togglePassword()">
								<i class="fas fa-eye" id="passwordToggleIcon"></i>
							</span>
						</div>
					</div>

					<div class="remember-wrapper">
						<div class="remember-me">
							<input type="checkbox" id="remember" name="remember" class="remember-checkbox">
							<label for="remember" class="remember-label">Remember me</label>
						</div>
						<a href="{{ route('password.request') }}" class="forgot-link">Forgot Password?</a>
					</div>

					<button type="submit" class="submit-btn">
						<i class="fas fa-sign-in-alt"></i>
						Sign In
					</button>
				</form>


				<div class="signup-link">
					Don't have an account? <a href="{{ route('register') }}">Sign up here</a>
				</div>
			</div>
		</main>
	</div>

	<script>
		// Password toggle functionality
		function togglePassword() {
			const passwordInput = document.getElementById('password');
			const toggleIcon = document.getElementById('passwordToggleIcon');
			
			if (passwordInput.type === 'password') {
				passwordInput.type = 'text';
				toggleIcon.classList.remove('fa-eye');
				toggleIcon.classList.add('fa-eye-slash');
			} else {
				passwordInput.type = 'password';
				toggleIcon.classList.remove('fa-eye-slash');
				toggleIcon.classList.add('fa-eye');
			}
		}

		// Form submission with loading
		document.getElementById('loginForm').addEventListener('submit', function(e) {
			const loadingOverlay = document.getElementById('loadingOverlay');
			loadingOverlay.classList.add('show');
		});

		// Add ripple effect to buttons
		document.querySelectorAll('.submit-btn').forEach(btn => {
			btn.addEventListener('click', function(e) {
				const ripple = document.createElement('span');
				const rect = this.getBoundingClientRect();
				const size = Math.max(rect.width, rect.height);
				const x = e.clientX - rect.left - size / 2;
				const y = e.clientY - rect.top - size / 2;
				
				ripple.style.width = ripple.style.height = size + 'px';
				ripple.style.left = x + 'px';
				ripple.style.top = y + 'px';
				ripple.style.position = 'absolute';
				ripple.style.borderRadius = '50%';
				ripple.style.background = 'rgba(255,255,255,0.3)';
				ripple.style.transform = 'scale(0)';
				ripple.style.animation = 'ripple 0.6s linear';
				ripple.style.pointerEvents = 'none';
				
				this.style.position = 'relative';
				this.style.overflow = 'hidden';
				this.appendChild(ripple);
				
				setTimeout(() => {
					ripple.remove();
				}, 600);
			});
		});

		// Add ripple animation
		const style = document.createElement('style');
		style.textContent = `
			@keyframes ripple {
				to {
					transform: scale(4);
					opacity: 0;
				}
			}
		`;
		document.head.appendChild(style);

		// Auto-hide alerts after 5 seconds
		setTimeout(() => {
			const alerts = document.querySelectorAll('.alert-error, .alert-success');
			alerts.forEach(alert => {
				alert.style.opacity = '0';
				alert.style.transform = 'translateY(-10px)';
				setTimeout(() => {
					alert.remove();
				}, 300);
			});
		}, 5000);
	</script>
</body>
</html>