@php
$landingContent =\App\Models\LandingContent::where('type','faq')->where('locale',app()->getLocale())->get();
@endphp

<!-- Professional FAQ Section -->
<section class="professional-faq-section">
    <div class="faq-background">
        <div class="faq-gradient-overlay"></div>
        <div class="faq-particles"></div>

    </div>
    
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xxl-8 col-xl-8 col-lg-10">
                <div class="section-header" data-aos="fade-up" data-aos-duration="1000">
                    <div class="section-badge">
                        <span class="badge-text">❓ FAQ Questions</span>
                    </div>
                    <h1 class="section-title">
                        <span class="title-line">{{ $data['title_big'] }}</span>
                        <span class="title-subtitle">{{ $data['title_small'] }}</span>
                    </h1>
                    <p class="section-description">
                        Find answers to the most commonly asked questions about our platform, services, and investment opportunities.
                    </p>
                </div>
            </div>
        </div>
        
        <div class="row justify-content-center">
            <div class="col-xxl-8 col-xl-8 col-lg-10">
                <div class="faq-container" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                    <div class="faq-accordion" id="professionalFaq">
                        @foreach($landingContent as $key => $content)
                        <div class="faq-item" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="{{ $key * 100 + 300 }}">
                            <div class="faq-header">
                                <button class="faq-button {{ $key != 0 ? 'collapsed' : '' }}" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#faqCollapse{{ $key }}" aria-expanded="{{ $key == 0 ? 'true' : 'false' }}" aria-controls="faqCollapse{{ $key }}">
                                    <div class="faq-icon">
                                        <div class="icon-wrapper">
                                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M12 2L2 7L12 12L22 7L12 2Z" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                                                <path d="M2 17L12 22L22 17" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                                                <path d="M2 12L12 17L22 12" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                                            </svg>
                                        </div>
                                    </div>
                                    <div class="faq-content">
                                        <h3 class="faq-title">{{ $content->title }}</h3>
                                    </div>
                                    <div class="faq-arrow">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M6 9L12 15L18 9" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                        </svg>
                                    </div>
                                </button>
                            </div>
                            <div id="faqCollapse{{ $key }}" class="faq-collapse collapse {{ $key == 0 ? 'show' : '' }}" aria-labelledby="faqHeading{{ $key }}"
                                data-bs-parent="#professionalFaq">
                                <div class="faq-body">
                                    <div class="faq-answer">
                                        {!! nl2br(e($content->description)) !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
/* Professional FAQ Section Styles */
.professional-faq-section {
    position: relative;
    padding: 120px 0;
    background: linear-gradient(135deg, #0f0f23 0%, #1a1a2e 50%, #16213e 100%);
    overflow: hidden;
}

.faq-background {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    z-index: 1;
}

.faq-gradient-overlay {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: radial-gradient(circle at 20% 30%, rgba(99, 102, 241, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 80% 70%, rgba(236, 72, 153, 0.1) 0%, transparent 50%);
}

.faq-particles {
    position: absolute;
    width: 100%;
    height: 100%;
    background-image: 
        radial-gradient(2px 2px at 20px 30px, rgba(255,255,255,0.1), transparent),
        radial-gradient(2px 2px at 40px 70px, rgba(99,102,241,0.2), transparent);
    background-repeat: repeat;
    background-size: 100px 100px;
    animation: float 35s infinite linear;
}



.section-header {
    text-align: center;
    margin-bottom: 80px;
    position: relative;
    z-index: 2;
}

.section-badge {
    display: inline-block;
    margin-bottom: 20px;
}

.badge-text {
    background: linear-gradient(135deg, rgba(99, 102, 241, 0.2), rgba(236, 72, 153, 0.2));
    border: 1px solid rgba(99, 102, 241, 0.3);
    padding: 8px 20px;
    border-radius: 50px;
    font-size: 14px;
    font-weight: 600;
    color: #ffffff;
    backdrop-filter: blur(10px);
}

.section-title {
    font-size: 3.5rem;
    font-weight: 900;
    line-height: 1.1;
    margin-bottom: 20px;
    background: linear-gradient(135deg, #ffffff 0%, #a0a0a0 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.title-line {
    display: block;
}

.title-subtitle {
    display: block;
    font-size: 1.5rem;
    font-weight: 600;
    color: rgba(255, 255, 255, 0.8);
    margin-top: 10px;
}

.section-description {
    font-size: 1.2rem;
    line-height: 1.6;
    color: rgba(255, 255, 255, 0.7);
    max-width: 600px;
    margin: 0 auto;
}

.faq-container {
    position: relative;
    z-index: 2;
}

.faq-accordion {
    display: flex;
    flex-direction: column;
    gap: 20px;
}

.faq-item {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 20px;
    overflow: hidden;
    transition: all 0.4s ease;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
}

.faq-item:hover {
    border-color: rgba(99, 102, 241, 0.3);
    box-shadow: 0 20px 40px rgba(99, 102, 241, 0.1);
    transform: translateY(-2px);
}

.faq-header {
    position: relative;
}

.faq-button {
    width: 100%;
    padding: 30px;
    background: transparent;
    border: none;
    display: flex;
    align-items: center;
    gap: 20px;
    cursor: pointer;
    transition: all 0.3s ease;
    text-align: left;
}

.faq-button:hover {
    background: rgba(255, 255, 255, 0.02);
}

.faq-button:not(.collapsed) {
    background: rgba(99, 102, 241, 0.05);
}

.faq-icon {
    flex-shrink: 0;
}

.icon-wrapper {
    width: 50px;
    height: 50px;
    background: linear-gradient(135deg, rgba(99, 102, 241, 0.2), rgba(236, 72, 153, 0.2));
    border: 2px solid rgba(99, 102, 241, 0.3);
    border-radius: 15px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #6366f1;
    transition: all 0.3s ease;
}

.faq-button:not(.collapsed) .icon-wrapper {
    background: linear-gradient(135deg, rgba(99, 102, 241, 0.3), rgba(236, 72, 153, 0.3));
    border-color: rgba(99, 102, 241, 0.5);
    transform: scale(1.05);
}

.faq-content {
    flex: 1;
}

.faq-title {
    font-size: 1.3rem;
    font-weight: 700;
    color: #ffffff;
    margin: 0;
    line-height: 1.4;
    transition: color 0.3s ease;
}

.faq-button:not(.collapsed) .faq-title {
    color: #6366f1;
}

.faq-arrow {
    flex-shrink: 0;
    color: rgba(255, 255, 255, 0.6);
    transition: all 0.3s ease;
}

.faq-button:not(.collapsed) .faq-arrow {
    color: #6366f1;
    transform: rotate(180deg);
}

.faq-collapse {
    transition: all 0.4s ease;
}

.faq-body {
    padding: 0 30px 30px;
}

.faq-answer {
    font-size: 1rem;
    line-height: 1.7;
    color: rgba(255, 255, 255, 0.8);
    padding: 20px 0;
    border-top: 1px solid rgba(255, 255, 255, 0.1);
}

.faq-answer p {
    margin-bottom: 15px;
}

.faq-answer p:last-child {
    margin-bottom: 0;
}

@keyframes float {
    0%, 100% { transform: translateY(0px); }
    50% { transform: translateY(-20px); }
}

/* Responsive Design */
@media (max-width: 768px) {
    .professional-faq-section {
        padding: 80px 0;
    }
    
    .section-title {
        font-size: 2.5rem;
    }
    
    .faq-accordion {
        gap: 15px;
    }
    
    .faq-button {
        padding: 25px 20px;
        gap: 15px;
    }
    
    .icon-wrapper {
        width: 45px;
        height: 45px;
    }
    
    .faq-title {
        font-size: 1.2rem;
    }
    
    .faq-body {
        padding: 0 20px 25px;
    }
    
    .faq-answer {
        font-size: 0.95rem;
        padding: 15px 0;
    }
}

@media (max-width: 480px) {
    .section-title {
        font-size: 2rem;
    }
    
    .section-description {
        font-size: 1rem;
    }
    
    .faq-button {
        padding: 20px 15px;
        gap: 12px;
        flex-direction: column;
        align-items: flex-start;
    }
    
    .faq-icon {
        align-self: flex-start;
    }
    
    .icon-wrapper {
        width: 40px;
        height: 40px;
    }
    
    .faq-title {
        font-size: 1.1rem;
    }
    
    .faq-arrow {
        position: absolute;
        top: 20px;
        right: 15px;
    }
    
    .faq-body {
        padding: 0 15px 20px;
    }
    
    .faq-answer {
        font-size: 0.9rem;
        padding: 12px 0;
    }
}
</style>
