@php
$schemas = \App\Models\Schema::where('status',true)->with('schedule')->get();
@endphp

<!-- Professional Investment Plans Section -->
<section class="professional-plans-section">
    <div class="plans-background">
        <div class="plans-gradient-overlay"></div>
        <div class="plans-particles"></div>
    </div>
    
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xxl-8 col-xl-8 col-lg-10">
                <div class="section-header" data-aos="fade-up" data-aos-duration="1000">
                    <div class="section-badge">
                        <span class="badge-text">💎 Premium Investment Plans</span>
                    </div>
                    <h2 class="section-title">
                        <span class="title-line">{{ $data['title_big'] }}</span>
                        <span class="title-subtitle">{{ $data['title_small'] }}</span>
                    </h2>
                    <p class="section-description">
                        Choose from our carefully crafted investment plans designed to maximize your returns while maintaining security and transparency.
                    </p>
                </div>
            </div>
        </div>
        
        <div class="plans-grid">
            @foreach($schemas as $index => $schema)
            <div class="plan-card @if($schema->featured) featured @endif" data-aos="fade-up" data-aos-delay="{{ $index * 100 }}">
                @if($schema->featured)
                <div class="featured-badge">
                    <span class="badge-text">⭐ Most Popular</span>
                </div>
                @endif
                
                <div class="plan-header">
                    <div class="plan-icon">
                        <div class="icon-wrapper">
                            <svg width="32" height="32" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M12 2L2 7L12 12L22 7L12 2Z" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                                <path d="M2 17L12 22L22 17" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                                <path d="M2 12L12 17L22 12" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                            </svg>
                        </div>
                    </div>
                    <h3 class="plan-name">{{ $schema->name }}</h3>
                    @if($schema->badge)
                    <div class="plan-badge">{{ $schema->badge }}</div>
                    @endif
                </div>
                
                <div class="plan-features">
                    <div class="feature-item">
                        <div class="feature-icon">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M12 2L2 7L12 12L22 7L12 2Z" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                                <path d="M2 17L12 22L22 17" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                                <path d="M2 12L12 17L22 12" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <div class="feature-content">
                            <span class="feature-label">{{ __('Investment Range') }}</span>
                            <span class="feature-value">
                                {{ $schema->type == 'range' ? $currencySymbol . $schema->min_amount . ' - ' . $currencySymbol . $schema->max_amount : $currencySymbol . $schema->fixed_amount }}
                            </span>
                        </div>
                    </div>
                    
                    <div class="feature-item">
                        <div class="feature-icon">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M9 12L11 14L15 10M21 12C21 16.9706 16.9706 21 12 21C7.02944 21 3 16.9706 3 12C3 7.02944 7.02944 3 12 3C16.9706 3 21 7.02944 21 12Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <div class="feature-content">
                            <span class="feature-label">{{ __('Capital Back') }}</span>
                            <span class="feature-value {{ $schema->capital_back ? 'positive' : 'negative' }}">
                                {{ $schema->capital_back ? __('Yes') : __('No') }}
                            </span>
                        </div>
                    </div>
                    
                    <div class="feature-item">
                        <div class="feature-icon">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M13 2L3 14H12L11 22L21 10H12L13 2Z" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <div class="feature-content">
                            <span class="feature-label">{{ __('Return Type') }}</span>
                            <span class="feature-value">{{ __(ucwords($schema->return_type)) }}</span>
                        </div>
                    </div>
                    
                    <div class="feature-item">
                        <div class="feature-icon">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="2"/>
                                <polyline points="12,6 12,12 16,14" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <div class="feature-content">
                            <span class="feature-label">{{ __('Periods') }}</span>
                            <span class="feature-value">
                                {{ ($schema->return_type == 'period' ? $schema->number_of_period.' ' : __('Unlimited').' ' )  }}
                                @if(($schema->number_of_period == 1 && $schema->return_type == 'period'))
                                    {{ __('Time') }}
                                @elseif($schema->return_type == 'period')
                                    {{ __('Times') }}
                                @endif
                            </span>
                        </div>
                    </div>
                    
                    <div class="feature-item">
                        <div class="feature-icon">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M9 12L11 14L15 10M21 12C21 16.9706 16.9706 21 12 21C7.02944 21 3 16.9706 3 12C3 7.02944 7.02944 3 12 3C16.9706 3 21 7.02944 21 12Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <div class="feature-content">
                            <span class="feature-label">{{ __('Profit Withdraw') }}</span>
                            <span class="feature-value positive">{{ __('Anytime') }}</span>
                        </div>
                    </div>
                    
                    <div class="feature-item">
                        <div class="feature-icon">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M18 6L6 18M6 6L18 18" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <div class="feature-content">
                            <span class="feature-label">{{ __('Cancel') }}</span>
                            <span class="feature-value {{ $schema->schema_cancel ? 'positive' : 'negative' }}">
                                @if($schema->schema_cancel)
                                    {{ __('In').' '. $schema->expiry_minute .' '. ($schema->expiry_minute == 1 ? __('Minute') : __('Minutes')) }}
                                @else
                                    {{ __('No') }}
                                @endif
                            </span>
                        </div>
                    </div>
                </div>
                
                <div class="plan-footer">
                    <a href="{{route('user.schema.preview',$schema->id)}}" class="invest-btn">
                        <span class="btn-icon">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M13 2L3 14H12L11 22L21 10H12L13 2Z" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                            </svg>
                        </span>
                        <span class="btn-text">{{ __('Invest Now') }}</span>
                        <div class="btn-shine"></div>
                    </a>
                    
                    @if($schema->off_days)
                    <div class="plan-note">
                        <span class="note-icon">ℹ️</span>
                        <span class="note-text">
                            {{ implode(', ', json_decode($schema->off_days,true)) .' '.__('are')}} {{ __('Holidays') }}
                        </span>
                    </div>
                    @endif
                </div>
                
                <div class="plan-glow"></div>
            </div>
            @endforeach
        </div>
    </div>
</section>

<style>
/* Professional Plans Section Styles */
.professional-plans-section {
    position: relative;
    padding: 120px 0;
    background: linear-gradient(135deg, #0f0f23 0%, #1a1a2e 50%, #16213e 100%);
    overflow: hidden;
}

.plans-background {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    z-index: 1;
}

.plans-gradient-overlay {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: radial-gradient(circle at 20% 30%, rgba(99, 102, 241, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 80% 70%, rgba(236, 72, 153, 0.1) 0%, transparent 50%);
}

.plans-particles {
    position: absolute;
    width: 100%;
    height: 100%;
    background-image: 
        radial-gradient(2px 2px at 20px 30px, rgba(255,255,255,0.1), transparent),
        radial-gradient(2px 2px at 40px 70px, rgba(99,102,241,0.2), transparent);
    background-repeat: repeat;
    background-size: 100px 100px;
    animation: float 25s infinite linear;
}

.section-header {
    text-align: center;
    margin-bottom: 80px;
    position: relative;
    z-index: 2;
}

.section-badge {
    display: inline-block;
    margin-bottom: 20px;
}

.badge-text {
    background: linear-gradient(135deg, rgba(99, 102, 241, 0.2), rgba(236, 72, 153, 0.2));
    border: 1px solid rgba(99, 102, 241, 0.3);
    padding: 8px 20px;
    border-radius: 50px;
    font-size: 14px;
    font-weight: 600;
    color: #ffffff;
    backdrop-filter: blur(10px);
}

.section-title {
    font-size: 3.5rem;
    font-weight: 900;
    line-height: 1.1;
    margin-bottom: 20px;
    background: linear-gradient(135deg, #ffffff 0%, #a0a0a0 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.title-line {
    display: block;
}

.title-subtitle {
    display: block;
    font-size: 1.5rem;
    font-weight: 600;
    color: rgba(255, 255, 255, 0.8);
    margin-top: 10px;
}

.section-description {
    font-size: 1.2rem;
    line-height: 1.6;
    color: rgba(255, 255, 255, 0.7);
    max-width: 600px;
    margin: 0 auto;
}

.plans-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
    gap: 30px;
    position: relative;
    z-index: 2;
}

.plan-card {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 25px;
    padding: 40px 30px;
    position: relative;
    overflow: hidden;
    transition: all 0.4s ease;
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.2);
}

.plan-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 1px;
    background: linear-gradient(90deg, transparent, rgba(255,255,255,0.4), transparent);
}

.plan-card:hover {
    transform: translateY(-10px);
    border-color: rgba(99, 102, 241, 0.5);
    box-shadow: 0 30px 60px rgba(99, 102, 241, 0.2);
}

.plan-card.featured {
    border-color: rgba(99, 102, 241, 0.6);
    background: rgba(99, 102, 241, 0.1);
    transform: scale(1.05);
}

.plan-card.featured:hover {
    transform: scale(1.05) translateY(-10px);
}

.featured-badge {
    position: absolute;
    top: -1px;
    right: 30px;
    background: linear-gradient(135deg, #6366f1 0%, #8b5cf6 100%);
    padding: 8px 20px;
    border-radius: 0 0 15px 15px;
    z-index: 3;
}

.featured-badge .badge-text {
    background: none;
    border: none;
    padding: 0;
    font-size: 12px;
    font-weight: 700;
    color: #ffffff;
}

.plan-header {
    text-align: center;
    margin-bottom: 30px;
}

.plan-icon {
    margin-bottom: 20px;
}

.icon-wrapper {
    width: 80px;
    height: 80px;
    background: linear-gradient(135deg, rgba(99, 102, 241, 0.2), rgba(236, 72, 153, 0.2));
    border: 2px solid rgba(99, 102, 241, 0.3);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto;
    color: #6366f1;
}

.plan-name {
    font-size: 1.8rem;
    font-weight: 800;
    color: #ffffff;
    margin-bottom: 10px;
}

.plan-badge {
    display: inline-block;
    background: linear-gradient(135deg, #6366f1, #8b5cf6);
    color: #ffffff;
    padding: 6px 16px;
    border-radius: 20px;
    font-size: 0.9rem;
    font-weight: 600;
}

.plan-features {
    margin-bottom: 30px;
}

.feature-item {
    display: flex;
    align-items: center;
    gap: 15px;
    padding: 15px 0;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.feature-item:last-child {
    border-bottom: none;
}

.feature-icon {
    width: 40px;
    height: 40px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #6366f1;
    flex-shrink: 0;
}

.feature-content {
    flex: 1;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.feature-label {
    color: rgba(255, 255, 255, 0.8);
    font-weight: 500;
}

.feature-value {
    color: #ffffff;
    font-weight: 700;
    font-size: 1.1rem;
}

.feature-value.positive {
    color: #10b981;
}

.feature-value.negative {
    color: #ef4444;
}

.plan-footer {
    text-align: center;
}

.invest-btn {
    display: inline-flex;
    align-items: center;
    gap: 10px;
    background: linear-gradient(135deg, #6366f1 0%, #8b5cf6 100%);
    color: #ffffff;
    padding: 16px 32px;
    border-radius: 50px;
    font-weight: 700;
    text-decoration: none;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
    margin-bottom: 20px;
    box-shadow: 0 10px 30px rgba(99, 102, 241, 0.3);
}

.invest-btn:hover {
    transform: translateY(-3px);
    box-shadow: 0 15px 40px rgba(99, 102, 241, 0.4);
    color: #ffffff;
}

.btn-shine {
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
    transition: left 0.5s;
}

.invest-btn:hover .btn-shine {
    left: 100%;
}

.plan-note {
    display: flex;
    align-items: center;
    gap: 8px;
    justify-content: center;
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.9rem;
}

.note-icon {
    font-size: 1rem;
}

.plan-glow {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 200px;
    height: 200px;
    background: radial-gradient(circle, rgba(99, 102, 241, 0.1) 0%, transparent 70%);
    border-radius: 50%;
    opacity: 0;
    transition: opacity 0.3s ease;
    pointer-events: none;
}

.plan-card:hover .plan-glow {
    opacity: 1;
}

/* Responsive Design */
@media (max-width: 768px) {
    .professional-plans-section {
        padding: 80px 0;
    }
    
    .section-title {
        font-size: 2.5rem;
    }
    
    .plans-grid {
        grid-template-columns: 1fr;
        gap: 20px;
    }
    
    .plan-card {
        padding: 30px 20px;
    }
    
    .plan-card.featured {
        transform: none;
    }
    
    .plan-card.featured:hover {
        transform: translateY(-10px);
    }
}

@media (max-width: 480px) {
    .section-title {
        font-size: 2rem;
    }
    
    .section-description {
        font-size: 1rem;
    }
    
    .plan-card {
        padding: 25px 15px;
    }
    
    .plan-name {
        font-size: 1.5rem;
    }
    
    .feature-item {
        padding: 12px 0;
    }
    
    .invest-btn {
        padding: 14px 28px;
        font-size: 0.9rem;
    }
}
</style>