<!-- InvestFlow Complete JavaScript -->
<script>
// Global variables
let currentPage = 'dashboard-page';
let currentCarouselSlide = 0;
let carouselInitialized = false;
let carouselInterval;
let sidebarOpen = false;
let notificationsOpen = false;
let userMenuOpen = false;

// Page navigation
function showPage(pageId) {
    // Hide all pages
    const pages = document.querySelectorAll('.page');
    pages.forEach(page => {
        page.classList.remove('active');
    });
    
    // Show target page with animation
    setTimeout(() => {
        const targetPage = document.getElementById(pageId);
        if (targetPage) {
            targetPage.classList.add('active');
            currentPage = pageId;
            
            // Show/hide bottom navigation and header based on page
            const bottomNav = document.getElementById('bottom-nav');
            const header = document.getElementById('main-header');
            const hideNavPages = ['welcome-page', 'login-page', 'signup-page'];
            
            if (hideNavPages.includes(pageId)) {
                if (bottomNav) bottomNav.style.display = 'none';
                if (header) header.style.display = 'none';
            } else {
                if (bottomNav) bottomNav.style.display = 'flex';
                if (header) header.style.display = 'block';
            }
            
            // Initialize page-specific functionality
            initPageFunctionality(pageId);
        }
    }, 100);
}

// Initialize page-specific functionality
function initPageFunctionality(pageId) {
    switch(pageId) {
        case 'dashboard-page':
            initDashboard();
            break;
        case 'deposit-page':
            initDepositPage();
            break;
        case 'withdraw-page':
            initWithdrawPage();
            break;
        case 'wallets-page':
            initWalletsPage();
            break;
        case 'history-page':
            initHistoryPage();
            break;
        case 'referral-page':
            initReferralPage();
            break;
        case 'profile-settings-page':
            initProfileSettings();
            break;
        case 'kyc-page':
            initKYCPage();
            break;
        case 'payment-methods-page':
            initPaymentMethods();
            break;
    }
}

// Dashboard functionality
function initDashboard() {
    // Reset carousel state when entering dashboard
    currentCarouselSlide = 0;
    carouselInitialized = false;
    if (carouselInterval) {
        clearInterval(carouselInterval);
        carouselInterval = null;
    }
    
    // Initialize dashboard components
    setTimeout(() => {
        initCarousel();
        animateBalanceCard();
        initQuickActions();
    }, 200);
}

// Carousel functionality
function initCarousel() {
    // Prevent multiple initializations
    if (carouselInitialized) return;
    
    const container = document.querySelector('.carousel-container');
    const cards = document.querySelectorAll('.carousel-card');
    const dots = document.querySelectorAll('.dot');
    
    if (!container || !cards.length) return;
    
    carouselInitialized = true;
    
    // Clear any existing interval
    if (carouselInterval) {
        clearInterval(carouselInterval);
    }
    
    // Add click events to carousel cards
    cards.forEach((card, index) => {
        card.addEventListener('click', () => {
            currentCarouselSlide = index;
            updateCarousel();
        });
    });
    
    // Dot navigation
    dots.forEach((dot, index) => {
        dot.addEventListener('click', (e) => {
            e.stopPropagation();
            currentCarouselSlide = index;
            updateCarousel();
        });
    });
    
    // Touch/swipe support
    let startX = 0;
    let endX = 0;
    
    container.addEventListener('touchstart', (e) => {
        startX = e.touches[0].clientX;
    });
    
    container.addEventListener('touchend', (e) => {
        endX = e.changedTouches[0].clientX;
        handleSwipe();
    });
    
    function handleSwipe() {
        const threshold = 50;
        const diff = startX - endX;
        
        if (Math.abs(diff) > threshold) {
            if (diff > 0) {
                // Swipe left - next slide
                currentCarouselSlide = (currentCarouselSlide + 1) % cards.length;
            } else {
                // Swipe right - previous slide
                currentCarouselSlide = currentCarouselSlide === 0 ? cards.length - 1 : currentCarouselSlide - 1;
            }
            updateCarousel();
        }
    }
    
    // Auto-rotate carousel
    carouselInterval = setInterval(() => {
        currentCarouselSlide = (currentCarouselSlide + 1) % cards.length;
        updateCarousel();
    }, 3000);
    
    // Initial display
    updateCarousel();
}

function updateCarousel() {
    const cards = document.querySelectorAll('.carousel-card');
    const dots = document.querySelectorAll('.dot');
    
    cards.forEach((card, index) => {
        card.classList.toggle('active', index === currentCarouselSlide);
    });
    
    dots.forEach((dot, index) => {
        dot.classList.toggle('active', index === currentCarouselSlide);
    });
}

// Animate balance card
function animateBalanceCard() {
    const balanceCard = document.querySelector('.balance-card');
    if (balanceCard) {
        balanceCard.style.opacity = '0';
        balanceCard.style.transform = 'translateY(20px)';
        
        setTimeout(() => {
            balanceCard.style.transition = 'all 0.6s ease-out';
            balanceCard.style.opacity = '1';
            balanceCard.style.transform = 'translateY(0)';
        }, 100);
    }
}

// Initialize quick actions
function initQuickActions() {
    const actionBtns = document.querySelectorAll('.action-btn');
    
    actionBtns.forEach(btn => {
        btn.addEventListener('click', (e) => {
            // Add haptic feedback
            if ('vibrate' in navigator) {
                navigator.vibrate(50);
            }
            
            // Add click animation
            btn.style.transform = 'scale(0.95)';
            setTimeout(() => {
                btn.style.transform = '';
            }, 150);
        });
    });
}

// Sidebar functionality
function toggleSidebar() {
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('sidebar-overlay');
    
    sidebarOpen = !sidebarOpen;
    
    if (sidebar) {
        sidebar.classList.toggle('active', sidebarOpen);
    }
    
    if (overlay) {
        overlay.classList.toggle('active', sidebarOpen);
    }
    
    // Add haptic feedback
    if ('vibrate' in navigator) {
        navigator.vibrate(30);
    }
}

// Notification functionality
function toggleNotifications() {
    const notificationPanel = document.getElementById('notification-panel');
    
    notificationsOpen = !notificationsOpen;
    
    if (notificationPanel) {
        notificationPanel.classList.toggle('active', notificationsOpen);
    }
    
    // Close user menu if open
    if (userMenuOpen) {
        toggleUserMenu();
    }
    
    // Add haptic feedback
    if ('vibrate' in navigator) {
        navigator.vibrate(30);
    }
}

// User menu functionality
function toggleUserMenu() {
    const userMenu = document.getElementById('user-menu');
    
    userMenuOpen = !userMenuOpen;
    
    if (userMenu) {
        userMenu.classList.toggle('active', userMenuOpen);
    }
    
    // Close notifications if open
    if (notificationsOpen) {
        toggleNotifications();
    }
    
    // Add haptic feedback
    if ('vibrate' in navigator) {
        navigator.vibrate(30);
    }
}

// Deposit page functionality
function initDepositPage() {
    const amountInput = document.getElementById('deposit-amount');
    const quickAmounts = document.querySelectorAll('.quick-amount');
    const paymentMethods = document.querySelectorAll('.payment-method');
    
    if (amountInput) {
        amountInput.addEventListener('input', updateDepositAmount);
    }
    
    quickAmounts.forEach(btn => {
        btn.addEventListener('click', (e) => {
            const amount = e.target.dataset.amount;
            if (amountInput) {
                amountInput.value = amount;
                updateDepositAmount();
            }
        });
    });
    
    paymentMethods.forEach(method => {
        method.addEventListener('click', (e) => {
            paymentMethods.forEach(m => m.classList.remove('selected'));
            e.currentTarget.classList.add('selected');
        });
    });
}

function updateDepositAmount() {
    const amountInput = document.getElementById('deposit-amount');
    const amount = parseFloat(amountInput.value) || 0;
    
    // Update any amount-dependent UI elements
    console.log('Deposit amount updated:', amount);
}

// Withdraw page functionality
function initWithdrawPage() {
    const amountInput = document.getElementById('withdraw-amount');
    const quickAmounts = document.querySelectorAll('.quick-amount');
    
    if (amountInput) {
        amountInput.addEventListener('input', updateWithdrawAmount);
    }
    
    quickAmounts.forEach(btn => {
        btn.addEventListener('click', (e) => {
            const amount = e.target.dataset.amount;
            if (amountInput) {
                amountInput.value = amount;
                updateWithdrawAmount();
            }
        });
    });
}

function updateWithdrawAmount() {
    const amountInput = document.getElementById('withdraw-amount');
    const amount = parseFloat(amountInput.value) || 0;
    
    console.log('Withdraw amount updated:', amount);
}

// Wallets page functionality
function initWalletsPage() {
    // Initialize wallet-specific functionality
    console.log('Wallets page initialized');
}

// History page functionality
function initHistoryPage() {
    // Initialize history-specific functionality
    console.log('History page initialized');
}

// Referral page functionality
function initReferralPage() {
    // Initialize referral-specific functionality
    console.log('Referral page initialized');
}

// Profile settings functionality
function initProfileSettings() {
    // Initialize profile settings functionality
    console.log('Profile settings initialized');
}

// KYC page functionality
function initKYCPage() {
    // Initialize KYC functionality
    console.log('KYC page initialized');
}

// Payment methods functionality
function initPaymentMethods() {
    // Initialize payment methods functionality
    console.log('Payment methods initialized');
}

// Utility functions
function showToast(message, type = 'info') {
    // Create toast notification
    const toast = document.createElement('div');
    toast.className = `toast toast-${type}`;
    toast.textContent = message;
    
    // Add to page
    document.body.appendChild(toast);
    
    // Animate in
    setTimeout(() => {
        toast.classList.add('show');
    }, 100);
    
    // Remove after delay
    setTimeout(() => {
        toast.classList.remove('show');
        setTimeout(() => {
            document.body.removeChild(toast);
        }, 300);
    }, 3000);
}

function formatCurrency(amount, currency = '$') {
    return `${currency}${amount.toFixed(2)}`;
}

function formatDate(date) {
    return new Date(date).toLocaleDateString('en-US', {
        year: 'numeric',
        month: 'short',
        day: 'numeric'
    });
}

// Initialize app when DOM is loaded
document.addEventListener('DOMContentLoaded', function() {
    // Initialize default page
    showPage('dashboard-page');
    
    // Add global event listeners
    document.addEventListener('click', (e) => {
        // Close dropdowns when clicking outside
        if (!e.target.closest('.notification-btn') && !e.target.closest('#notification-panel')) {
            if (notificationsOpen) {
                toggleNotifications();
            }
        }
        
        if (!e.target.closest('.user-avatar') && !e.target.closest('#user-menu')) {
            if (userMenuOpen) {
                toggleUserMenu();
            }
        }
    });
    
    // Add keyboard navigation
    document.addEventListener('keydown', (e) => {
        if (e.key === 'Escape') {
            if (sidebarOpen) {
                toggleSidebar();
            }
            if (notificationsOpen) {
                toggleNotifications();
            }
            if (userMenuOpen) {
                toggleUserMenu();
            }
        }
    });
    
    // Add service worker for offline functionality
    if ('serviceWorker' in navigator) {
        navigator.serviceWorker.register('/sw.js')
            .then(registration => {
                console.log('Service Worker registered:', registration);
            })
            .catch(error => {
                console.log('Service Worker registration failed:', error);
            });
    }
});

// Handle page visibility changes
document.addEventListener('visibilitychange', function() {
    if (document.hidden) {
        // Pause carousel when page is hidden
        if (carouselInterval) {
            clearInterval(carouselInterval);
        }
    } else {
        // Resume carousel when page is visible
        if (currentPage === 'dashboard-page' && carouselInitialized) {
            carouselInterval = setInterval(() => {
                currentCarouselSlide = (currentCarouselSlide + 1) % document.querySelectorAll('.carousel-card').length;
                updateCarousel();
            }, 3000);
        }
    }
});

// Handle window resize
window.addEventListener('resize', function() {
    // Recalculate layouts if needed
    if (currentPage === 'dashboard-page') {
        // Refresh carousel on resize
        setTimeout(() => {
            if (carouselInitialized) {
                updateCarousel();
            }
        }, 100);
    }
});
</script>

