<!-- InvestFlow Complete Styles -->
<style>
/* InvestFlow CSS Variables */
:root {
    --primary-color: #6366f1;
    --primary-dark: #4f46e5;
    --secondary-color: #8b5cf6;
    --background-primary: #0f0f23;
    --background-secondary: #1a1a2e;
    --surface: #16213e;
    --surface-light: rgba(255, 255, 255, 0.05);
    --surface-lighter: rgba(255, 255, 255, 0.1);
    --text-primary: #ffffff;
    --text-secondary: #b4b4c7;
    --text-muted: #8e8ea0;
    --success: #10b981;
    --error: #ef4444;
    --warning: #f59e0b;
    --border: rgba(255, 255, 255, 0.1);
    --shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.37);
    --shadow-lg: 0 20px 40px 0 rgba(31, 38, 135, 0.5);
    --border-radius: 16px;
    --border-radius-sm: 12px;
    --border-radius-lg: 24px;
    --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    --transition-fast: all 0.15s ease-out;
}

/* Global Styles */
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
    background: linear-gradient(135deg, var(--background-primary) 0%, var(--background-secondary) 100%);
    color: var(--text-primary);
    min-height: 100vh;
    overflow-x: hidden;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
}

/* Glass Effect */
.glass-effect {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(16px);
    -webkit-backdrop-filter: blur(16px);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: var(--border-radius);
    box-shadow: var(--shadow);
    transition: var(--transition);
}

.glass-effect:hover {
    background: rgba(255, 255, 255, 0.08);
    transform: translateY(-2px);
    box-shadow: var(--shadow-lg);
}

/* Header Styles */
.main-header {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    height: 70px;
    background: rgba(15, 15, 35, 0.95);
    backdrop-filter: blur(20px);
    -webkit-backdrop-filter: blur(20px);
    border-bottom: 1px solid var(--border);
    z-index: 1000;
    transition: var(--transition);
}

.header-content {
    display: flex;
    align-items: center;
    justify-content: space-between;
    height: 100%;
    padding: 0 1.5rem;
    max-width: 1200px;
    margin: 0 auto;
}

.header-left {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.menu-btn {
    width: 44px;
    height: 44px;
    background: var(--surface-light);
    border: 1px solid var(--border);
    border-radius: 12px;
    color: var(--text-primary);
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: var(--transition);
    backdrop-filter: blur(16px);
}

.menu-btn:hover {
    background: var(--surface-lighter);
    transform: scale(1.05);
}

.logo-header {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.logo-small {
    width: 40px;
    height: 40px;
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
}

.app-name {
    font-size: 1.5rem;
    font-weight: 700;
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.header-right {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.notification-btn {
    position: relative;
    width: 44px;
    height: 44px;
    background: var(--surface-light);
    border: 1px solid var(--border);
    border-radius: 12px;
    color: var(--text-primary);
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: var(--transition);
    backdrop-filter: blur(16px);
}

.notification-btn:hover {
    background: var(--surface-lighter);
    transform: scale(1.05);
}

.notification-badge {
    position: absolute;
    top: -5px;
    right: -5px;
    background: var(--error);
    color: white;
    border-radius: 50%;
    width: 20px;
    height: 20px;
    font-size: 0.7rem;
    font-weight: 600;
    display: flex;
    align-items: center;
    justify-content: center;
    animation: pulse 2s infinite;
}

.user-avatar {
    width: 44px;
    height: 44px;
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    cursor: pointer;
    transition: var(--transition);
}

.user-avatar:hover {
    transform: scale(1.05);
}

/* Sidebar Styles */
.sidebar {
    position: fixed;
    top: 0;
    left: -350px;
    width: 350px;
    height: 100vh;
    background: rgba(26, 26, 46, 0.95);
    backdrop-filter: blur(20px);
    -webkit-backdrop-filter: blur(20px);
    border-right: 1px solid var(--border);
    z-index: 1100;
    transition: var(--transition);
    overflow-y: auto;
}

.sidebar.active {
    left: 0;
}

.sidebar-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 1.5rem;
    border-bottom: 1px solid var(--border);
}

.sidebar-logo {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.sidebar-brand h3 {
    font-size: 1.3rem;
    font-weight: 700;
    margin-bottom: 0.25rem;
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.sidebar-brand p {
    color: var(--text-secondary);
    font-size: 0.9rem;
}

.sidebar-close {
    width: 36px;
    height: 36px;
    background: var(--surface-light);
    border: 1px solid var(--border);
    border-radius: 8px;
    color: var(--text-primary);
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: var(--transition);
}

.sidebar-close:hover {
    background: var(--surface-lighter);
}

.sidebar-content {
    padding: 1.5rem;
}

.user-info {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem;
    background: var(--surface-light);
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    backdrop-filter: blur(16px);
}

.user-avatar-large {
    width: 50px;
    height: 50px;
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
}

.user-details h4 {
    font-size: 1.1rem;
    font-weight: 600;
    margin-bottom: 0.25rem;
}

.user-details p {
    color: var(--text-secondary);
    font-size: 0.9rem;
}

/* Navigation Styles */
.sidebar-nav {
    display: flex;
    flex-direction: column;
    gap: 1.5rem;
}

.nav-section {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.nav-title {
    font-size: 0.8rem;
    font-weight: 600;
    color: var(--text-muted);
    text-transform: uppercase;
    letter-spacing: 0.5px;
    margin-bottom: 0.5rem;
}

.nav-link {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 0.75rem 1rem;
    color: var(--text-secondary);
    text-decoration: none;
    border-radius: var(--border-radius-sm);
    transition: var(--transition);
    position: relative;
}

.nav-link:hover {
    background: var(--surface-light);
    color: var(--text-primary);
    text-decoration: none;
}

.nav-link.active {
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    color: white;
}

.nav-link i {
    width: 20px;
    text-align: center;
    font-size: 1.1rem;
}

/* Sidebar Overlay */
.sidebar-overlay {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0, 0, 0, 0.5);
    backdrop-filter: blur(4px);
    z-index: 1050;
    opacity: 0;
    visibility: hidden;
    transition: var(--transition);
}

.sidebar-overlay.active {
    opacity: 1;
    visibility: visible;
}

/* Page Styles */
.page {
    display: none;
    min-height: 100vh;
    padding-top: 70px;
}

.page.active {
    display: block;
}

.page-container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 2rem;
}

.page-header {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 2rem;
}

.back-btn {
    width: 44px;
    height: 44px;
    background: var(--surface-light);
    border: 1px solid var(--border);
    border-radius: 12px;
    color: var(--text-primary);
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: var(--transition);
    backdrop-filter: blur(16px);
}

.back-btn:hover {
    background: var(--surface-lighter);
    transform: scale(1.05);
}

.page-header h2 {
    font-size: 1.8rem;
    font-weight: 700;
    color: var(--text-primary);
}

/* Dashboard Styles */
.dashboard-container {
    padding: 20px;
    max-width: 400px;
    margin: 0 auto;
    background: linear-gradient(135deg, var(--background-primary) 0%, var(--background-secondary) 100%);
    min-height: 100vh;
}

.dashboard-welcome {
    text-align: center;
    margin-bottom: 30px;
    color: var(--text-primary);
}

.dashboard-welcome h3 {
    font-size: 24px;
    font-weight: 600;
    margin-bottom: 8px;
}

.dashboard-welcome p {
    font-size: 14px;
    color: var(--text-secondary);
    margin: 0;
}

/* Balance Card */
.balance-card {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border-radius: 20px;
    padding: 25px;
    margin-bottom: 25px;
    border: 1px solid rgba(255, 255, 255, 0.1);
    text-align: center;
    color: var(--text-primary);
}

.balance-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 15px;
    font-size: 14px;
    color: var(--text-secondary);
}

.balance-amount {
    font-size: 32px;
    font-weight: 700;
    margin-bottom: 10px;
}

.balance-change {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 5px;
    font-size: 14px;
    font-weight: 500;
}

.balance-change.positive {
    color: var(--success);
}

.balance-change.negative {
    color: var(--error);
}

/* Carousel Section */
.carousel-section {
    margin-bottom: 25px;
}

.carousel-container {
    display: flex;
    gap: 15px;
    overflow-x: auto;
    padding-bottom: 10px;
    scrollbar-width: none;
    -ms-overflow-style: none;
}

.carousel-container::-webkit-scrollbar {
    display: none;
}

.carousel-card {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border-radius: 15px;
    padding: 20px;
    border: 1px solid rgba(255, 255, 255, 0.1);
    min-width: 140px;
    text-align: center;
    color: var(--text-primary);
    transition: var(--transition);
}

.carousel-card.active {
    background: rgba(255, 255, 255, 0.1);
    transform: scale(1.05);
}

.card-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    background: rgba(255, 255, 255, 0.1);
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 15px;
    font-size: 18px;
}

.card-info {
    display: flex;
    flex-direction: column;
    gap: 5px;
}

.card-label {
    font-size: 12px;
    color: var(--text-secondary);
}

.card-value {
    font-size: 16px;
    font-weight: 600;
}

.card-value.profit {
    color: var(--success);
}

.card-value.expense {
    color: var(--error);
}

.carousel-dots {
    display: flex;
    justify-content: center;
    gap: 8px;
    margin-top: 15px;
}

.dot {
    width: 8px;
    height: 8px;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.3);
    cursor: pointer;
    transition: var(--transition);
}

.dot.active {
    background: var(--text-primary);
    transform: scale(1.2);
}

/* Quick Actions */
.quick-actions {
    display: grid;
    grid-template-columns: repeat(4, 1fr);
    gap: 15px;
    margin-bottom: 25px;
}

.action-btn {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border-radius: 15px;
    padding: 20px 10px;
    border: 1px solid rgba(255, 255, 255, 0.1);
    text-align: center;
    color: var(--text-primary);
    cursor: pointer;
    transition: var(--transition);
    text-decoration: none;
}

.action-btn:hover {
    background: rgba(255, 255, 255, 0.1);
    transform: translateY(-2px);
    text-decoration: none;
    color: var(--text-primary);
}

.action-btn i {
    font-size: 20px;
    margin-bottom: 8px;
    display: block;
}

.action-btn span {
    font-size: 12px;
    font-weight: 500;
}

/* Recent Section */
.recent-section {
    margin-bottom: 25px;
}

.section-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 15px;
}

.section-header h3 {
    color: var(--text-primary);
    font-size: 18px;
    font-weight: 600;
    margin: 0;
}

.section-header a {
    color: var(--text-secondary);
    text-decoration: none;
    font-size: 14px;
    transition: var(--transition);
}

.section-header a:hover {
    color: var(--text-primary);
}

.transaction-list {
    display: flex;
    flex-direction: column;
    gap: 10px;
}

.transaction-item {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border-radius: 15px;
    padding: 15px;
    border: 1px solid rgba(255, 255, 255, 0.1);
    display: flex;
    align-items: center;
    gap: 15px;
    color: var(--text-primary);
}

.transaction-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 16px;
}

.transaction-icon.deposit {
    background: rgba(16, 185, 129, 0.2);
    color: var(--success);
}

.transaction-icon.withdraw {
    background: rgba(239, 68, 68, 0.2);
    color: var(--error);
}

.transaction-details {
    flex: 1;
    display: flex;
    flex-direction: column;
    gap: 4px;
}

.transaction-title {
    font-size: 14px;
    font-weight: 500;
}

.transaction-date {
    font-size: 12px;
    color: var(--text-secondary);
}

.transaction-amount {
    font-size: 16px;
    font-weight: 600;
}

.transaction-amount.positive {
    color: var(--success);
}

.transaction-amount.negative {
    color: var(--error);
}

/* Animations */
@keyframes pulse {
    0%, 100% {
        transform: scale(1);
    }
    50% {
        transform: scale(1.1);
    }
}

@keyframes slideInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

@keyframes slideInLeft {
    from {
        opacity: 0;
        transform: translateX(-30px);
    }
    to {
        opacity: 1;
        transform: translateX(0);
    }
}

@keyframes fadeIn {
    from {
        opacity: 0;
    }
    to {
        opacity: 1;
    }
}

/* Notification Panel */
.notification-panel {
    position: fixed;
    top: 70px;
    right: -350px;
    width: 350px;
    height: calc(100vh - 70px);
    background: rgba(26, 26, 46, 0.95);
    backdrop-filter: blur(20px);
    -webkit-backdrop-filter: blur(20px);
    border-left: 1px solid var(--border);
    z-index: 1100;
    transition: var(--transition);
    overflow-y: auto;
}

.notification-panel.active {
    right: 0;
}

.notification-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 1.5rem;
    border-bottom: 1px solid var(--border);
}

.notification-header h3 {
    font-size: 1.2rem;
    font-weight: 600;
    color: var(--text-primary);
}

.close-btn {
    width: 32px;
    height: 32px;
    background: var(--surface-light);
    border: 1px solid var(--border);
    border-radius: 8px;
    color: var(--text-primary);
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: var(--transition);
}

.close-btn:hover {
    background: var(--surface-lighter);
}

.notification-list {
    padding: 1rem;
}

.notification-item {
    display: flex;
    gap: 1rem;
    padding: 1rem;
    background: var(--surface-light);
    border-radius: var(--border-radius);
    margin-bottom: 0.5rem;
    transition: var(--transition);
}

.notification-item:hover {
    background: var(--surface-lighter);
}

.notification-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.1rem;
}

.notification-content h4 {
    font-size: 0.9rem;
    font-weight: 600;
    color: var(--text-primary);
    margin-bottom: 0.25rem;
}

.notification-content p {
    font-size: 0.8rem;
    color: var(--text-secondary);
    margin-bottom: 0.5rem;
}

.notification-time {
    font-size: 0.7rem;
    color: var(--text-muted);
}

/* User Menu */
.user-menu {
    position: fixed;
    top: 80px;
    right: -200px;
    width: 200px;
    background: rgba(26, 26, 46, 0.95);
    backdrop-filter: blur(20px);
    -webkit-backdrop-filter: blur(20px);
    border: 1px solid var(--border);
    border-radius: var(--border-radius);
    z-index: 1100;
    transition: var(--transition);
    overflow: hidden;
}

.user-menu.active {
    right: 20px;
}

.user-menu-item {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem;
    color: var(--text-primary);
    cursor: pointer;
    transition: var(--transition);
    border-bottom: 1px solid var(--border);
}

.user-menu-item:last-child {
    border-bottom: none;
}

.user-menu-item:hover {
    background: var(--surface-light);
}

.user-menu-item i {
    width: 20px;
    text-align: center;
    font-size: 1rem;
}

.user-menu-item span {
    font-size: 0.9rem;
    font-weight: 500;
}

/* Mobile Responsive */
@media (max-width: 768px) {
    .dashboard-container {
        padding: 15px;
    }
    
    .quick-actions {
        grid-template-columns: repeat(2, 1fr);
        gap: 10px;
    }
    
    .action-btn {
        padding: 15px 8px;
    }
    
    .carousel-card {
        min-width: 120px;
        padding: 15px;
    }
    
    .sidebar {
        width: 100%;
        left: -100%;
    }
    
    .page-container {
        padding: 1rem;
    }
    
    .notification-panel {
        width: 100%;
        right: -100%;
    }
    
    .user-menu {
        right: -100%;
        width: 100%;
    }
    
    .user-menu.active {
        right: 0;
    }
}

@media (max-width: 480px) {
    .quick-actions {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .carousel-container {
        gap: 10px;
    }
    
    .carousel-card {
        min-width: 110px;
        padding: 12px;
    }
}
</style>
