@extends('frontend::layouts.user')
@section('title', 'Test Profit Distribution')
@section('content')
<div class="container-fluid default-page">
    <div class="row gy-30">
        <div class="col-xl-12">
            <div class="rock-dashboard-card">
                <h3>Profit Distribution Testing</h3>
                
                <!-- Test Buttons -->
                <div class="mb-4">
                    <button class="btn btn-primary me-2" onclick="testProfitDistribution()">Test Profit Distribution</button>
                    <button class="btn btn-info me-2" onclick="debugInvestments()">Debug Investments</button>
                    <button class="btn btn-warning" onclick="location.reload()">Refresh Page</button>
                </div>

                <!-- Results Area -->
                <div id="results" class="mt-4"></div>

                <!-- Investment List for Force Profit -->
                <div class="mt-4">
                    <h4>Force Profit for Specific Investment</h4>
                    <div id="investment-list"></div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function testProfitDistribution() {
    document.getElementById('results').innerHTML = '<div class="alert alert-info">Testing profit distribution...</div>';
    
    fetch('/test-profit-distribution')
        .then(response => response.json())
        .then(data => {
            let html = '';
            if (data.success) {
                html = `<div class="alert alert-success">
                    <h5>Success: ${data.message}</h5>
                    <p><strong>Timestamp:</strong> ${data.timestamp}</p>
                    <ul>`;
                data.results.forEach(result => {
                    html += `<li>${result}</li>`;
                });
                html += '</ul></div>';
            } else {
                html = `<div class="alert alert-danger">
                    <h5>Error:</h5>
                    <p>${data.error}</p>
                    <small>File: ${data.file} Line: ${data.line}</small>
                </div>`;
            }
            document.getElementById('results').innerHTML = html;
        })
        .catch(error => {
            document.getElementById('results').innerHTML = `<div class="alert alert-danger">Network Error: ${error}</div>`;
        });
}

function debugInvestments() {
    document.getElementById('results').innerHTML = '<div class="alert alert-info">Loading debug data...</div>';
    
    fetch('/debug-investments')
        .then(response => response.json())
        .then(data => {
            let html = `<div class="alert alert-info">
                <h5>Debug Information</h5>
                <p><strong>Current Time:</strong> ${data.current_time}</p>
                <p><strong>Timezone:</strong> ${data.timezone}</p>
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Schema</th>
                            <th>Amount</th>
                            <th>Status</th>
                            <th>Interest</th>
                            <th>Profit Count</th>
                            <th>Next Profit Time</th>
                            <th>Ready for Profit</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>`;
            
            data.investments.forEach(invest => {
                html += `<tr>
                    <td>${invest.id}</td>
                    <td>${invest.schema}</td>
                    <td>${invest.amount}</td>
                    <td>${invest.status}</td>
                    <td>${invest.interest}${invest.interest_type === 'percentage' ? '%' : ''}</td>
                    <td>${invest.already_return_profit}/${invest.number_of_period}</td>
                    <td>${invest.next_profit_time}</td>
                    <td><span class="badge ${invest.ready_for_profit === 'YES' ? 'bg-success' : 'bg-warning'}">${invest.ready_for_profit}</span></td>
                    <td><button class="btn btn-sm btn-primary" onclick="forceProfit(${invest.id})">Force Profit</button></td>
                </tr>`;
            });
            
            html += '</tbody></table></div>';
            document.getElementById('results').innerHTML = html;
        })
        .catch(error => {
            document.getElementById('results').innerHTML = `<div class="alert alert-danger">Network Error: ${error}</div>`;
        });
}

function forceProfit(investmentId) {
    if (!confirm('Are you sure you want to force profit for this investment?')) {
        return;
    }
    
    fetch(`/force-profit/${investmentId}`, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'Content-Type': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert(`Success! Profit ${data.profit_amount} added. Balance: ${data.old_balance} → ${data.new_balance}`);
            debugInvestments(); // Refresh the debug data
        } else {
            alert(`Error: ${data.error}`);
        }
    })
    .catch(error => {
        alert(`Network Error: ${error}`);
    });
}
</script>
@endsection
