@extends('frontend::layouts.user')
@section('title')
    {{ __('OTP Verification') }}
@endsection
@section('content')
    <div class="container-fluid default-page">
        <div class="row gy-30">
            <div class="col-xxl-12">
                <div class="rock-withdraw-area">
                    <div class="rock-dashboard-card">
                        <div class="rock-dashboard-title-inner">
                            <div class="content">
                                <h3 class="rock-dashboard-tile">{{ __('OTP Verification') }}</h3>
                            </div>
                        </div>
                        <div class="rock-add-mony-wrapper">
                            <div class="otp-verification-content text-center">
                                <div class="otp-icon mb-4">
                                    <svg width="80" height="80" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M12 16V12" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M12 8H12.01" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                
                                <h4 class="mb-3">{{ __('Verify Your Withdrawal') }}</h4>
                                <p class="mb-4">{{ __('For security purposes, we have sent a one-time password (OTP) to your registered email address. Please enter the OTP below to complete your withdrawal.') }}</p>
                                
                                <form id="otpVerificationForm" class="max-w-md mx-auto">
                                    @csrf
                                    <div class="rock-single-input mb-4">
                                        <label class="input-label" for="otp">{{ __('Enter OTP') }}</label>
                                        <div class="input-field">
                                            <input type="text" class="box-input text-center" id="otpInput" name="otp" placeholder="Enter 6-digit OTP" maxlength="6">
                                        </div>
                                        <p class="input-description text-danger" id="otpError"></p>
                                    </div>
                                    
                                    <div class="otp-timer mb-3">
                                        <p>{{ __('OTP will expire in') }} <span id="otpTimer">10:00</span></p>
                                    </div>
                                    
                                    <div class="otp-resend mb-4">
                                        <p>{{ __('Didn\'t receive the OTP?') }} <a href="javascript:void(0)" id="resendOtp" class="text-primary">{{ __('Resend OTP') }}</a></p>
                                    </div>
                                    
                                    <div class="rock-input-btn-wrap justify-content-center">
                                        <button type="button" id="verifyOtpBtn" class="site-btn gradient-btn radius-10">
                                            {{ __('Verify & Complete Withdrawal') }}
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        "use strict";
        
        $(document).ready(function() {
            // Start OTP timer when page loads
            startOtpTimer();
            
            // Verify OTP
            $("#verifyOtpBtn").on('click', function() {
                var otp = $("#otpInput").val();
                
                if (!otp || otp.length !== 6) {
                    $("#otpError").text('Please enter a valid 6-digit OTP');
                    return;
                }
                
                $.ajax({
                    url: '{{ route("user.withdraw.verify-otp") }}',
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        otp: otp
                    },
                    beforeSend: function() {
                        $("#verifyOtpBtn").prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Verifying...');
                    },
                    success: function(response) {
                        if (response.success) {
                            notify().success(response.message, 'Success');
                            
                            // Redirect to notification page
                            if (response.redirect) {
                                window.location.href = response.redirect;
                            }
                        } else {
                            $("#otpError").text(response.message);
                            $("#verifyOtpBtn").prop('disabled', false).html('{{ __("Verify & Complete Withdrawal") }}');
                        }
                    },
                    error: function(xhr) {
                        $("#verifyOtpBtn").prop('disabled', false).html('{{ __("Verify & Complete Withdrawal") }}');
                        if (xhr.responseJSON && xhr.responseJSON.message) {
                            $("#otpError").text(xhr.responseJSON.message);
                        } else {
                            $("#otpError").text('An error occurred. Please try again.');
                        }
                    }
                });
            });
            
            // Resend OTP
            $("#resendOtp").on('click', function() {
                var $this = $(this);
                $this.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Sending...');
                
                $.ajax({
                    url: '{{ route("user.withdraw.resend-otp") }}',
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        if (response.success) {
                            notify().success(response.message, 'Success');
                            
                            // Reset OTP timer
                            startOtpTimer();
                            
                            // Reset button
                            setTimeout(function() {
                                $this.prop('disabled', false).html('{{ __("Resend OTP") }}');
                            }, 30000); // Disable for 30 seconds
                        } else {
                            $("#otpError").text(response.message);
                            $this.prop('disabled', false).html('{{ __("Resend OTP") }}');
                        }
                    },
                    error: function(xhr) {
                        $this.prop('disabled', false).html('{{ __("Resend OTP") }}');
                        if (xhr.responseJSON && xhr.responseJSON.message) {
                            $("#otpError").text(xhr.responseJSON.message);
                        } else {
                            $("#otpError").text('An error occurred. Please try again.');
                        }
                    }
                });
            });
        });
        
        // OTP Timer function
        function startOtpTimer() {
            var minutes = 10;
            var seconds = 0;
            var timerElement = document.getElementById('otpTimer');
            
            // Clear any existing timer
            if (window.otpTimerInterval) {
                clearInterval(window.otpTimerInterval);
            }
            
            window.otpTimerInterval = setInterval(function() {
                if (seconds === 0) {
                    if (minutes === 0) {
                        clearInterval(window.otpTimerInterval);
                        timerElement.textContent = "Expired";
                        return;
                    }
                    minutes--;
                    seconds = 59;
                } else {
                    seconds--;
                }
                
                timerElement.textContent = minutes.toString().padStart(2, '0') + ":" + seconds.toString().padStart(2, '0');
            }, 1000);
        }
    </script>
@endsection
