@extends('frontend::layouts.user')
@section('title')
    {{ __('Verify OTP') }}
@endsection

@section('content')
    <div class="container-fluid default-page">
        <div class="row gy-30">
            <div class="col-xxl-12">
                <div class="rock-withdraw-area">
                    <div class="rock-dashboard-card">
                        <div class="rock-dashboard-title-inner">
                            <h3 class="rock-dashboard-tile">{{ __('Verify OTP') }}</h3>
                        </div>
                        <div class="rock-add-mony-wrapper">
                            <form action="{{ route('user.withdraw.verify.otp') }}" method="POST">
                                @csrf
                                <div class="row gy-30">
                                    <div class="col-xxl-6 col-xl-6 col-lg-6">
                                        <div class="rock-single-input">
                                            <label class="input-label">{{ __('Enter OTP') }}</label>
                                            <div class="input-field">
                                                <input type="text" class="box-input" name="otp" maxlength="6" required>
                                            </div>
                                            <p class="input-description">{{ __('Check your email for the OTP') }}</p>
                                            <p class="input-description mt-2">
                                                {{ __("Didn't receive the OTP?") }} 
                                                <a href="{{ route('user.withdraw.resend.otp') }}" class="text-primary">
                                                    {{ __('Resend OTP') }}
                                                </a>
                                            </p>
                                            @if(session('otp_sent'))
                                                <div class="alert alert-success mt-2">
                                                    {{ session('otp_sent') }}
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="rock-input-btn-wrap justify-content-end">
                                        <button type="submit" class="site-btn gradient-btn radius-10">
                                            {{ __('Verify OTP') }}
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection