<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title') - {{ setting('site_name', 'ShahBlock') }}</title>
    <meta name="description" content="@yield('description', setting('site_description', 'global'))">
    <meta name="keywords" content="@yield('keywords', setting('site_keywords', 'global'))">
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="{{ asset('frontend/theme_base/shahdeveloper/images/favicon.png') }}">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    @yield('style')
    @stack('style')
</head>
<body>
    <!-- InvestFlow Header (default/global) -->
    @include('frontend.shahdeveloper.include.__shahdeveloper_header')
    
    <!-- InvestFlow Styles -->
    @include('frontend.shahdeveloper.include.__shahdeveloper_styles')
    
    <!-- Content Area -->
    <div class="content-wrapper">
        @yield('content')
    </div>
    
    <!-- Bottom Navigation Menu -->
    <div class="bottom-nav">
        <a href="{{ route('user.dashboard') }}" class="nav-item {{ request()->routeIs('user.dashboard') ? 'active' : '' }}">
            <i class="fas fa-home"></i>
            <span>Home</span>
        </a>
        <a href="{{ route('user.schema') }}" class="nav-item {{ request()->routeIs('user.schema*') ? 'active' : '' }}">
            <i class="fas fa-chart-pie"></i>
            <span>Plans</span>
        </a>
        <a href="{{ route('user.deposit') }}" class="nav-item {{ request()->routeIs('user.deposit*') ? 'active' : '' }}">
            <i class="fas fa-plus"></i>
            <span>Deposit</span>
        </a>
        <a href="{{ route('user.deposit.log') }}" class="nav-item {{ request()->routeIs('user.deposit.log*') ? 'active' : '' }}">
            <i class="fas fa-list"></i>
            <span>Logs</span>
        </a>
        <a href="{{ route('user.withdraw.new.index') }}" class="nav-item {{ request()->routeIs('user.withdraw.new*') || request()->routeIs('user.withdraw.history') ? 'active' : '' }}">
            <i class="fas fa-minus"></i>
            <span>Withdraw</span>
        </a>
    </div>
    
    <!-- InvestFlow Scripts -->
    @include('frontend.shahdeveloper.include.__shahdeveloper_scripts')
    
    @yield('script')
</body>
</html>


