@extends('frontend.shahdeveloper.layouts.app')

@section('title')
    {{ __('Create New Ticket') }}
@endsection

@section('content')
<div class="main-content">
    <div class="page-title">
        <div class="container-fluid">
            <div class="row">
                <div class="col">
                    <div class="title-content">
                        <h2 class="title">{{ __('Create New Ticket') }}</h2>
                        <a href="{{ route('user.ticket.index') }}" class="title-btn">
                            <i icon-name="arrow-left"></i>{{ __('Back to Tickets') }}
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-8">
                <div class="site-card">
                    <div class="site-card-header">
                        <h3 class="title">{{ __('Ticket Information') }}</h3>
                    </div>
                    <div class="site-card-body">
                        <form action="{{ route('user.ticket.store') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-xl-12 col-md-12 col-sm-12">
                                    <div class="site-input-groups">
                                        <label for="title" class="box-input-label">{{ __('Subject') }} <span class="text-danger">*</span></label>
                                        <div class="box-input">
                                            <input type="text" 
                                                   class="box-input-field" 
                                                   id="title" 
                                                   name="title" 
                                                   placeholder="{{ __('Enter ticket subject') }}"
                                                   value="{{ old('title') }}"
                                                   required>
                                        </div>
                                        @error('title')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-xl-12 col-md-12 col-sm-12">
                                    <div class="site-input-groups">
                                        <label for="message" class="box-input-label">{{ __('Message') }} <span class="text-danger">*</span></label>
                                        <div class="box-input">
                                            <textarea class="box-input-field" 
                                                      id="message" 
                                                      name="message" 
                                                      rows="6" 
                                                      placeholder="{{ __('Describe your issue in detail') }}"
                                                      required>{{ old('message') }}</textarea>
                                        </div>
                                        @error('message')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-xl-12 col-md-12 col-sm-12">
                                    <div class="site-input-groups">
                                        <label for="attach" class="box-input-label">{{ __('Attachment') }} ({{ __('Optional') }})</label>
                                        <div class="box-input">
                                            <input type="file" 
                                                   class="box-input-field" 
                                                   id="attach" 
                                                   name="attach" 
                                                   accept="image/*,.pdf,.doc,.docx">
                                            <small class="text-muted">{{ __('Supported formats: JPG, PNG, PDF, DOC, DOCX') }}</small>
                                        </div>
                                        @error('attach')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-xl-12 col-md-12 col-sm-12">
                                    <div class="site-input-groups">
                                        <button type="submit" class="site-btn">
                                            <i icon-name="send"></i>{{ __('Create Ticket') }}
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            
            <div class="col-xl-4">
                <div class="site-card">
                    <div class="site-card-header">
                        <h3 class="title">{{ __('Support Guidelines') }}</h3>
                    </div>
                    <div class="site-card-body">
                        <div class="support-guidelines">
                            <div class="guideline-item">
                                <i icon-name="info" class="guideline-icon"></i>
                                <div class="guideline-content">
                                    <h6>{{ __('Be Specific') }}</h6>
                                    <p>{{ __('Provide detailed information about your issue for faster resolution.') }}</p>
                                </div>
                            </div>
                            
                            <div class="guideline-item">
                                <i icon-name="clock" class="guideline-icon"></i>
                                <div class="guideline-content">
                                    <h6>{{ __('Response Time') }}</h6>
                                    <p>{{ __('We typically respond within 24 hours during business days.') }}</p>
                                </div>
                            </div>
                            
                            <div class="guideline-item">
                                <i icon-name="file-text" class="guideline-icon"></i>
                                <div class="guideline-content">
                                    <h6>{{ __('Attachments') }}</h6>
                                    <p>{{ __('Include relevant screenshots or documents to help us understand your issue.') }}</p>
                                </div>
                            </div>
                            
                            <div class="guideline-item">
                                <i icon-name="mail" class="guideline-icon"></i>
                                <div class="guideline-content">
                                    <h6>{{ __('Email Notifications') }}</h6>
                                    <p>{{ __('You will receive email updates when we respond to your ticket.') }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('script')
<script>
    // Add any JavaScript functionality here if needed
</script>
@endpush

@push('style')
<style>
.support-guidelines {
    padding: 0;
}

.guideline-item {
    display: flex;
    align-items: flex-start;
    margin-bottom: 20px;
    padding-bottom: 20px;
    border-bottom: 1px solid #f0f0f0;
}

.guideline-item:last-child {
    margin-bottom: 0;
    padding-bottom: 0;
    border-bottom: none;
}

.guideline-icon {
    width: 20px;
    height: 20px;
    color: #00ff88;
    margin-right: 15px;
    margin-top: 2px;
    flex-shrink: 0;
}

.guideline-content h6 {
    margin-bottom: 5px;
    color: #333;
    font-weight: 600;
}

.guideline-content p {
    margin: 0;
    color: #666;
    font-size: 14px;
    line-height: 1.5;
}
</style>
@endpush
