@extends('frontend.shahdeveloper.layouts.app')

@section('content')
<div class="transfer-history-page">
    <div class="history-header">
        <h2>Transfer History</h2>
        <p>View all your money transfers</p>
    </div>

    <div class="transactions-container">
        @if($transactions->count() > 0)
            @foreach($transactions as $transaction)
                <div class="transaction-card {{ $transaction->type === 'transfer' ? 'outgoing' : 'incoming' }}">
                    <div class="transaction-icon">
                        @if($transaction->type === 'transfer')
                            <i class="fas fa-paper-plane"></i>
                        @else
                            <i class="fas fa-arrow-down"></i>
                        @endif
                    </div>
                    
                    <div class="transaction-details">
                        <div class="transaction-info">
                            <h4>
                                @php
                                    $details = null;
                                    if ($transaction->details) {
                                        $details = json_decode($transaction->details, true);
                                    }
                                @endphp
                                @if($transaction->type === 'transfer')
                                    @if($details && isset($details['recipient']))
                                        Sent to <strong>{{ $details['recipient'] }}</strong>
                                    @else
                                        <span class="text-warning">Sent to Unknown User</span>
                                    @endif
                                @else
                                    @if($details && isset($details['sender']))
                                        Received from <strong>{{ $details['sender'] }}</strong>
                                    @else
                                        <span class="text-warning">Received from Unknown User</span>
                                    @endif
                                @endif
                            </h4>
                            <p class="transaction-date">{{ \Carbon\Carbon::parse($transaction->getRawOriginal('created_at'))->format('M d, Y - h:i A') }}</p>
                            @if($details && isset($details['note']) && $details['note'])
                                <p class="transaction-note">
                                    <i class="fas fa-sticky-note"></i> {{ $details['note'] }}
                                </p>
                            @endif
                        </div>
                        
                        <div class="transaction-amount">
                            <span class="amount {{ $transaction->type === 'transfer' ? 'negative' : 'positive' }}">
                                {{ $transaction->type === 'transfer' ? '-' : '+' }}{{ $transaction->amount }} {{ $transaction->currency }}
                            </span>
                            <span class="status {{ $transaction->status->value ?? $transaction->status }}">{{ ucfirst($transaction->status->value ?? $transaction->status) }}</span>
                        </div>
                    </div>
                    
                    <div class="transaction-id">
                        <small>{{ $transaction->tnx }}</small>
                    </div>
                </div>
            @endforeach
            
            <div class="pagination-container">
                {{ $transactions->links() }}
            </div>
        @else
            <div class="empty-state">
                <i class="fas fa-exchange-alt"></i>
                <h3>No Transfers Yet</h3>
                <p>You haven't made any transfers yet. Start by sending money to other users.</p>
                <a href="{{ route('user.shah.transfer') }}" class="btn-primary">
                    <i class="fas fa-paper-plane"></i>
                    Make Transfer
                </a>
            </div>
        @endif
    </div>
</div>
@endsection

@section('style')
<style>
.transfer-history-page {
    padding: 20px;
    max-width: 800px;
    margin: 0 auto;
}

.history-header {
    text-align: center;
    margin-bottom: 30px;
}

.history-header h2 {
    color: var(--text-primary);
    font-size: 2rem;
    margin-bottom: 10px;
}

.history-header p {
    color: var(--text-secondary);
    font-size: 1rem;
}

.transactions-container {
    display: flex;
    flex-direction: column;
    gap: 15px;
}

.transaction-card {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(16px);
    -webkit-backdrop-filter: blur(16px);
    border-radius: 12px;
    border: 1px solid rgba(0, 255, 136, 0.18);
    box-shadow: 0 8px 25px rgba(0, 255, 136, 0.12);
    padding: 20px;
    display: flex;
    align-items: center;
    gap: 15px;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.transaction-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 4px;
    height: 100%;
    background: var(--primary-color);
}

.transaction-card.outgoing::before {
    background: #ff6b6b;
}

.transaction-card.incoming::before {
    background: #51cf66;
}

.transaction-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 12px 35px rgba(0, 255, 136, 0.2);
}

.transaction-icon {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.2rem;
    flex-shrink: 0;
}

.transaction-card.outgoing .transaction-icon {
    background: rgba(255, 107, 107, 0.2);
    color: #ff6b6b;
}

.transaction-card.incoming .transaction-icon {
    background: rgba(81, 207, 102, 0.2);
    color: #51cf66;
}

.transaction-details {
    flex: 1;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.transaction-info h4 {
    color: var(--text-primary);
    font-size: 1.1rem;
    margin-bottom: 5px;
    font-weight: 600;
}

.transaction-date {
    color: var(--text-secondary);
    font-size: 0.9rem;
    margin-bottom: 5px;
}

.transaction-note {
    color: var(--text-secondary);
    font-size: 0.85rem;
    font-style: italic;
    margin: 0;
    display: flex;
    align-items: center;
    gap: 5px;
}

.text-warning {
    color: #ffc107 !important;
    font-weight: 500;
}

.transaction-amount {
    text-align: right;
    display: flex;
    flex-direction: column;
    align-items: flex-end;
    gap: 5px;
}

.amount {
    font-size: 1.2rem;
    font-weight: 700;
}

.amount.positive {
    color: #51cf66;
}

.amount.negative {
    color: #ff6b6b;
}

.status {
    padding: 4px 8px;
    border-radius: 12px;
    font-size: 0.75rem;
    font-weight: 600;
    text-transform: uppercase;
}

.status.success {
    background: rgba(81, 207, 102, 0.2);
    color: #51cf66;
}

.status.pending {
    background: rgba(255, 193, 7, 0.2);
    color: #ffc107;
}

.status.failed {
    background: rgba(255, 107, 107, 0.2);
    color: #ff6b6b;
}

.transaction-id {
    position: absolute;
    bottom: 10px;
    right: 15px;
}

.transaction-id small {
    color: var(--text-secondary);
    font-size: 0.7rem;
    opacity: 0.7;
}

.empty-state {
    text-align: center;
    padding: 60px 20px;
    background: rgba(255, 255, 255, 0.03);
    backdrop-filter: blur(10px);
    -webkit-backdrop-filter: blur(10px);
    border-radius: 16px;
    border: 1px solid rgba(255, 255, 255, 0.1);
}

.empty-state i {
    font-size: 4rem;
    color: var(--primary-color);
    margin-bottom: 20px;
    opacity: 0.7;
}

.empty-state h3 {
    color: var(--text-primary);
    font-size: 1.5rem;
    margin-bottom: 10px;
}

.empty-state p {
    color: var(--text-secondary);
    font-size: 1rem;
    margin-bottom: 30px;
}

.btn-primary {
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    border: none;
    color: #001f11;
    padding: 12px 24px;
    border-radius: 8px;
    font-weight: 600;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    transition: all 0.3s ease;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0, 255, 136, 0.3);
    color: #001f11;
    text-decoration: none;
}

.pagination-container {
    margin-top: 30px;
    display: flex;
    justify-content: center;
}

/* Responsive Design */
@media (max-width: 768px) {
    .transfer-history-page {
        padding: 15px;
    }
    
    .transaction-card {
        padding: 15px;
        flex-direction: column;
        align-items: flex-start;
        gap: 10px;
    }
    
    .transaction-details {
        width: 100%;
        flex-direction: column;
        align-items: flex-start;
        gap: 10px;
    }
    
    .transaction-amount {
        align-items: flex-start;
        flex-direction: row;
        gap: 10px;
    }
    
    .transaction-id {
        position: static;
        margin-top: 10px;
    }
}
</style>
@endsection
