@extends('frontend.shahdeveloper.layouts.user')

@section('title', 'Withdrawal History')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- Page Header -->
            <div class="page-header">
                <div class="header-content">
                    <h1 class="page-title">
                        <i class="fas fa-history"></i>
                        Withdrawal History
                    </h1>
                    <p class="page-subtitle">Track all your withdrawal requests and their status</p>
                </div>
                <div class="header-actions">
                    <a href="{{ route('user.withdraw.simple.index') }}" class="btn btn-primary">
                        <i class="fas fa-plus"></i>
                        New Withdrawal
                    </a>
                </div>
            </div>

            <!-- Search and Filter -->
            <div class="filter-section">
                <div class="row">
                    <div class="col-md-6">
                        <form method="GET" action="{{ route('user.withdraw.log') }}" class="search-form">
                            <div class="input-group">
                                <input type="text" name="query" class="form-control" 
                                       placeholder="Search by transaction ID..." 
                                       value="{{ request('query') }}">
                                <button type="submit" class="btn btn-outline-primary">
                                    <i class="fas fa-search"></i>
                                </button>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-6">
                        <form method="GET" action="{{ route('user.withdraw.log') }}" class="date-form">
                            <div class="input-group">
                                <input type="date" name="date" class="form-control" 
                                       value="{{ request('date') }}">
                                <button type="submit" class="btn btn-outline-secondary">
                                    <i class="fas fa-filter"></i>
                                    Filter by Date
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Withdrawals Table -->
            <div class="withdrawals-table">
                @if($withdraws && $withdraws->count() > 0)
                    <div class="table-responsive">
                        <table class="table withdrawals-table">
                            <thead>
                                <tr>
                                    <th>Transaction ID</th>
                                    <th>Amount</th>
                                    <th>Method</th>
                                    <th>Status</th>
                                    <th>Date</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($withdraws as $withdrawal)
                                    <tr class="withdrawal-row">
                                        <td>
                                            <div class="transaction-id">
                                                <code>{{ $withdrawal->tnx }}</code>
                                                <button class="copy-btn" onclick="copyToClipboard('{{ $withdrawal->tnx }}')">
                                                    <i class="fas fa-copy"></i>
                                                </button>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="amount-info">
                                                <span class="amount">{{ $currencySymbol }}{{ number_format($withdrawal->amount, 2) }}</span>
                                                @if($withdrawal->charge > 0)
                                                    <small class="charge">Fee: {{ $currencySymbol }}{{ number_format($withdrawal->charge, 2) }}</small>
                                                @endif
                                            </div>
                                        </td>
                                        <td>
                                            <div class="method-info">
                                                <span class="method-name">{{ $withdrawal->method }}</span>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="status-badge status-{{ strtolower($withdrawal->status->value) }}">
                                                @switch($withdrawal->status->value)
                                                    @case('pending')
                                                        <i class="fas fa-clock"></i>
                                                        Pending
                                                        @break
                                                    @case('approved')
                                                        <i class="fas fa-check-circle"></i>
                                                        Approved
                                                        @break
                                                    @case('completed')
                                                        <i class="fas fa-check-double"></i>
                                                        Completed
                                                        @break
                                                    @case('rejected')
                                                        <i class="fas fa-times-circle"></i>
                                                        Rejected
                                                        @break
                                                    @default
                                                        <i class="fas fa-question-circle"></i>
                                                        {{ ucfirst($withdrawal->status->value) }}
                                                @endswitch
                                            </span>
                                        </td>
                                        <td>
                                            <div class="date-info">
                                                <span class="date">{{ \Carbon\Carbon::parse($withdrawal->created_at)->format('M d, Y') }}</span>
                                                <small class="time">{{ \Carbon\Carbon::parse($withdrawal->created_at)->format('h:i A') }}</small>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="action-buttons">
                                                <button class="btn btn-sm btn-outline-info" 
                                                        onclick="showWithdrawalDetails({{ $withdrawal->id }})">
                                                    <i class="fas fa-eye"></i>
                                                    View
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="pagination-wrapper">
                        {{ $withdraws ? $withdraws->links() : '' }}
                    </div>
                @else
                    <!-- Empty State -->
                    <div class="empty-state">
                        <div class="empty-icon">
                            <i class="fas fa-inbox"></i>
                        </div>
                        <h3>No Withdrawals Found</h3>
                        <p>You haven't made any withdrawal requests yet.</p>
                        <a href="{{ route('user.withdraw.simple.index') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i>
                            Make Your First Withdrawal
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Withdrawal Details Modal -->
<div class="modal fade" id="withdrawalDetailsModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Withdrawal Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="withdrawalDetailsContent">
                <!-- Content will be loaded here -->
            </div>
        </div>
    </div>
</div>

<style>
.page-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 2rem;
    padding: 1.5rem;
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 136, 0.2);
}

.header-content h1 {
    color: var(--text-primary);
    font-size: 2rem;
    font-weight: 700;
    margin: 0;
    background: linear-gradient(135deg, #00ff88, #00d4aa);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.header-content p {
    color: var(--text-secondary);
    margin: 0.5rem 0 0 0;
}

.filter-section {
    margin-bottom: 2rem;
    padding: 1.5rem;
    background: rgba(255, 255, 255, 0.03);
    backdrop-filter: blur(20px);
    border-radius: 15px;
    border: 1px solid rgba(255, 255, 255, 0.1);
}

.search-form, .date-form {
    margin-bottom: 1rem;
}

.input-group {
    display: flex;
    border-radius: 10px;
    overflow: hidden;
}

.form-control {
    background: rgba(255, 255, 255, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
    color: var(--text-primary);
    padding: 12px 16px;
    border-radius: 0;
}

.form-control:focus {
    background: rgba(255, 255, 255, 0.15);
    border-color: var(--primary-color);
    color: var(--text-primary);
    box-shadow: 0 0 0 0.2rem rgba(0, 255, 136, 0.25);
}

.btn {
    padding: 12px 20px;
    border-radius: 0;
    font-weight: 600;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    transition: all 0.3s ease;
    border: none;
}

.btn-primary {
    background: linear-gradient(135deg, #00ff88, #00d4aa);
    color: #001f11;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 20px rgba(0, 255, 136, 0.3);
    color: #001f11;
}

.btn-outline-primary, .btn-outline-secondary {
    background: transparent;
    color: var(--text-primary);
    border: 1px solid rgba(255, 255, 255, 0.3);
}

.btn-outline-primary:hover, .btn-outline-secondary:hover {
    background: rgba(255, 255, 255, 0.1);
    color: var(--text-primary);
}

.withdrawals-table {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border-radius: 15px;
    border: 1px solid rgba(0, 255, 136, 0.2);
    overflow: hidden;
}

.table {
    margin: 0;
    color: var(--text-primary);
}

.table thead th {
    background: rgba(0, 255, 136, 0.1);
    color: var(--text-primary);
    font-weight: 600;
    border: none;
    padding: 1rem;
    font-size: 0.9rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.table tbody td {
    border: none;
    padding: 1rem;
    vertical-align: middle;
    border-bottom: 1px solid rgba(255, 255, 255, 0.05);
}

.withdrawal-row:hover {
    background: rgba(0, 255, 136, 0.05);
}

.transaction-id {
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.transaction-id code {
    background: rgba(0, 255, 136, 0.1);
    color: var(--primary-color);
    padding: 0.25rem 0.5rem;
    border-radius: 5px;
    font-size: 0.8rem;
}

.copy-btn {
    background: none;
    border: none;
    color: var(--text-secondary);
    cursor: pointer;
    padding: 0.25rem;
    border-radius: 3px;
    transition: all 0.3s ease;
}

.copy-btn:hover {
    background: rgba(0, 255, 136, 0.1);
    color: var(--primary-color);
}

.amount-info .amount {
    font-weight: 600;
    font-size: 1.1rem;
    color: var(--text-primary);
}

.amount-info .charge {
    color: var(--text-secondary);
    display: block;
    font-size: 0.8rem;
}

.method-name {
    color: var(--text-primary);
    font-weight: 500;
}

.status-badge {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-size: 0.85rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.status-pending {
    background: rgba(255, 193, 7, 0.2);
    color: #ffc107;
    border: 1px solid rgba(255, 193, 7, 0.3);
}

.status-approved {
    background: rgba(40, 167, 69, 0.2);
    color: #28a745;
    border: 1px solid rgba(40, 167, 69, 0.3);
}

.status-completed {
    background: rgba(0, 255, 136, 0.2);
    color: #00ff88;
    border: 1px solid rgba(0, 255, 136, 0.3);
}

.status-rejected {
    background: rgba(220, 53, 69, 0.2);
    color: #dc3545;
    border: 1px solid rgba(220, 53, 69, 0.3);
}

.date-info .date {
    color: var(--text-primary);
    font-weight: 500;
    display: block;
}

.date-info .time {
    color: var(--text-secondary);
    font-size: 0.8rem;
}

.action-buttons .btn {
    padding: 0.5rem 1rem;
    font-size: 0.85rem;
}

.empty-state {
    text-align: center;
    padding: 4rem 2rem;
    color: var(--text-secondary);
}

.empty-icon {
    font-size: 4rem;
    color: var(--text-secondary);
    margin-bottom: 1.5rem;
    opacity: 0.5;
}

.empty-state h3 {
    color: var(--text-primary);
    margin-bottom: 1rem;
}

.pagination-wrapper {
    padding: 2rem;
    display: flex;
    justify-content: center;
}

/* Mobile Responsive */
@media (max-width: 768px) {
    .withdraw-log-container {
        padding: 0 15px;
    }
    
    .page-header {
        flex-direction: column;
        gap: 1rem;
        text-align: center;
        padding: 1.5rem;
    }
    
    .page-title {
        font-size: 1.5rem;
    }
    
    .page-subtitle {
        font-size: 0.9rem;
    }
    
    .filter-section {
        padding: 1rem;
    }
    
    .filter-section .row {
        flex-direction: column;
        gap: 1rem;
    }
    
    .filter-section .col-md-4 {
        width: 100%;
    }
    
    .form-control {
        font-size: 0.9rem;
        padding: 0.75rem;
    }
    
    .btn {
        padding: 0.75rem 1rem;
        font-size: 0.9rem;
    }
    
    .withdrawals-table {
        padding: 1rem;
    }
    
    .table-responsive {
        font-size: 0.8rem;
        border-radius: 10px;
        overflow: hidden;
    }
    
    .table thead th {
        padding: 0.75rem 0.5rem;
        font-size: 0.8rem;
        white-space: nowrap;
    }
    
    .table tbody td {
        padding: 0.75rem 0.5rem;
        vertical-align: middle;
    }
    
    .transaction-id {
        flex-direction: column;
        align-items: flex-start;
        gap: 0.25rem;
    }
    
    .transaction-id .id-text {
        font-size: 0.75rem;
        word-break: break-all;
    }
    
    .copy-btn {
        padding: 0.25rem 0.5rem;
        font-size: 0.7rem;
    }
    
    .amount-info .amount {
        font-size: 0.9rem;
    }
    
    .amount-info .currency {
        font-size: 0.8rem;
    }
    
    .method-info .method-name {
        font-size: 0.8rem;
    }
    
    .status-badge {
        padding: 0.25rem 0.5rem;
        font-size: 0.7rem;
    }
    
    .date-info .date {
        font-size: 0.8rem;
    }
    
    .date-info .time {
        font-size: 0.7rem;
    }
    
    .action-buttons .btn {
        padding: 0.4rem 0.8rem;
        font-size: 0.75rem;
    }
    
    .empty-state {
        padding: 2rem 1rem;
    }
    
    .empty-icon {
        font-size: 3rem;
    }
    
    .empty-state h3 {
        font-size: 1.2rem;
    }
    
    .empty-state p {
        font-size: 0.9rem;
    }
    
    .pagination-wrapper {
        padding: 1rem;
    }
    
    .pagination {
        font-size: 0.8rem;
    }
    
    .pagination .page-link {
        padding: 0.5rem 0.75rem;
    }
}

@media (max-width: 480px) {
    .withdraw-log-container {
        padding: 0 10px;
    }
    
    .page-header {
        padding: 1rem;
    }
    
    .page-title {
        font-size: 1.3rem;
    }
    
    .page-subtitle {
        font-size: 0.85rem;
    }
    
    .filter-section {
        padding: 0.75rem;
    }
    
    .withdrawals-table {
        padding: 0.75rem;
    }
    
    .table-responsive {
        font-size: 0.75rem;
    }
    
    .table thead th {
        padding: 0.5rem 0.25rem;
        font-size: 0.75rem;
    }
    
    .table tbody td {
        padding: 0.5rem 0.25rem;
    }
    
    .transaction-id .id-text {
        font-size: 0.7rem;
    }
    
    .amount-info .amount {
        font-size: 0.85rem;
    }
    
    .method-info .method-name {
        font-size: 0.75rem;
    }
    
    .status-badge {
        padding: 0.2rem 0.4rem;
        font-size: 0.65rem;
    }
    
    .date-info .date {
        font-size: 0.75rem;
    }
    
    .date-info .time {
        font-size: 0.65rem;
    }
    
    .action-buttons .btn {
        padding: 0.3rem 0.6rem;
        font-size: 0.7rem;
    }
    
    .empty-state {
        padding: 1.5rem 0.75rem;
    }
    
    .empty-icon {
        font-size: 2.5rem;
    }
    
    .empty-state h3 {
        font-size: 1.1rem;
    }
    
    .empty-state p {
        font-size: 0.85rem;
    }
}
</style>

<script>
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function() {
        // Show success message
        const btn = event.target.closest('.copy-btn');
        const originalHTML = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-check"></i>';
        btn.style.color = '#00ff88';
        
        setTimeout(() => {
            btn.innerHTML = originalHTML;
            btn.style.color = '';
        }, 2000);
    });
}

function showWithdrawalDetails(withdrawalId) {
    // This would typically load withdrawal details via AJAX
    // For now, we'll show a placeholder
    document.getElementById('withdrawalDetailsContent').innerHTML = `
        <div class="text-center">
            <p>Loading withdrawal details...</p>
            <p><small>Withdrawal ID: ${withdrawalId}</small></p>
        </div>
    `;
    
    // Show modal
    const modal = new bootstrap.Modal(document.getElementById('withdrawalDetailsModal'));
    modal.show();
}
</script>
@endsection
