@extends('frontend::layouts.user')

@section('title')
    {{ __('Support Tickets') }}
@endsection

@section('content')

<div class="desktop-screen-show">
    <div class="row">
        <div class="col-xl-12">
            <div class="site-card">
                <div class="site-card-header">
                    <h3 class="title">{{ __('Support Tickets') }}</h3>
                    <a href="{{ route('user.ticket.new') }}" class="site-btn">
                        <i icon-name="plus-circle"></i>{{ __('New Ticket') }}
                    </a>
                </div>
                <div class="site-card-body">
                    @if($tickets->count() > 0)
                        <div class="site-table table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th scope="col">{{ __('Ticket ID') }}</th>
                                        <th scope="col">{{ __('Subject') }}</th>
                                        <th scope="col">{{ __('Status') }}</th>
                                        <th scope="col">{{ __('Created') }}</th>
                                        <th scope="col">{{ __('Action') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($tickets as $ticket)
                                        <tr>
                                            <td>
                                                <div class="table-text">
                                                    <h6 class="title">{{ $ticket->uuid }}</h6>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="table-text">
                                                    <h6 class="title">{{ $ticket->title }}</h6>
                                                </div>
                                            </td>
                                            <td>
                                                @if($ticket->status == 'open')
                                                    <span class="site-badge success">{{ __('Open') }}</span>
                                                @elseif($ticket->status == 'closed')
                                                    <span class="site-badge warning">{{ __('Closed') }}</span>
                                                @else
                                                    <span class="site-badge pending">{{ ucfirst($ticket->status) }}</span>
                                                @endif
                                            </td>
                                            <td>
                                                <div class="table-text">
                                                    <p class="text">{{ $ticket->created_at }}</p>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="action-btn">
                                                    <a href="{{ route('user.ticket.show', $ticket->uuid) }}" 
                                                       class="site-btn-small primary-btn">
                                                        <i icon-name="eye"></i>{{ __('View') }}
                                                    </a>
                                                    @if($ticket->status == 'open')
                                                        <a href="{{ route('user.ticket.close', $ticket->uuid) }}" 
                                                           class="site-btn-small warning-btn"
                                                           onclick="return confirm('Are you sure you want to close this ticket?')">
                                                            <i icon-name="x-circle"></i>{{ __('Close') }}
                                                        </a>
                                                    @endif
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="text-center py-5">
                            <div class="empty-state">
                                <i icon-name="message-circle" class="empty-icon"></i>
                                <h4>{{ __('No Tickets Found') }}</h4>
                                <p>{{ __('You haven\'t created any support tickets yet.') }}</p>
                                <a href="{{ route('user.ticket.new') }}" class="site-btn">
                                    <i icon-name="plus-circle"></i>{{ __('Create New Ticket') }}
                                </a>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('mobile-screen-show')
<div class="mobile-screen-show">
    <div class="row">
        <div class="col-xl-12">
            <div class="site-card">
                <div class="site-card-header">
                    <h3 class="title">{{ __('Support Tickets') }}</h3>
                    <a href="{{ route('user.ticket.new') }}" class="site-btn">
                        <i icon-name="plus-circle"></i>{{ __('New Ticket') }}
                    </a>
                </div>
                <div class="site-card-body">
                    @if($tickets->count() > 0)
                        <div class="mobile-ticket-list">
                            @foreach($tickets as $ticket)
                                <div class="mobile-ticket-item">
                                    <div class="ticket-header">
                                        <div class="ticket-id">{{ $ticket->uuid }}</div>
                                        <div class="ticket-status">
                                            @if($ticket->status == 'open')
                                                <span class="site-badge success">{{ __('Open') }}</span>
                                            @elseif($ticket->status == 'closed')
                                                <span class="site-badge warning">{{ __('Closed') }}</span>
                                            @else
                                                <span class="site-badge pending">{{ ucfirst($ticket->status) }}</span>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="ticket-title">{{ $ticket->title }}</div>
                                    <div class="ticket-date">{{ $ticket->created_at }}</div>
                                    <div class="ticket-actions">
                                        <a href="{{ route('user.ticket.show', $ticket->uuid) }}" 
                                           class="site-btn-small primary-btn">
                                            <i icon-name="eye"></i>{{ __('View') }}
                                        </a>
                                        @if($ticket->status == 'open')
                                            <a href="{{ route('user.ticket.close', $ticket->uuid) }}" 
                                               class="site-btn-small warning-btn"
                                               onclick="return confirm('Are you sure you want to close this ticket?')">
                                                <i icon-name="x-circle"></i>{{ __('Close') }}
                                            </a>
                                        @endif
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-5">
                            <div class="empty-state">
                                <i icon-name="message-circle" class="empty-icon"></i>
                                <h4>{{ __('No Tickets Found') }}</h4>
                                <p>{{ __('You haven\'t created any support tickets yet.') }}</p>
                                <a href="{{ route('user.ticket.new') }}" class="site-btn">
                                    <i icon-name="plus-circle"></i>{{ __('Create New Ticket') }}
                                </a>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
/* Desktop Styles */
.site-card {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border-radius: 15px;
    border: 1px solid rgba(255, 255, 255, 0.1);
    margin-bottom: 20px;
}

.site-card-header {
    padding: 20px;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.site-card-header .title {
    color: #fff;
    margin: 0;
    font-weight: 600;
}

.site-card-body {
    padding: 20px;
}

.site-btn {
    background: linear-gradient(135deg, #00ff88, #00cc6a);
    border: none;
    padding: 12px 24px;
    border-radius: 8px;
    color: #000;
    font-weight: 600;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    transition: all 0.3s ease;
}

.site-btn:hover {
    background: linear-gradient(135deg, #00cc6a, #00ff88);
    color: #000;
    text-decoration: none;
    transform: translateY(-2px);
}

.site-table {
    background: transparent;
}

.table {
    color: #fff;
    margin-bottom: 0;
}

.table thead th {
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    color: #00ff88;
    font-weight: 600;
    padding: 15px;
}

.table tbody td {
    border-bottom: 1px solid rgba(255, 255, 255, 0.05);
    padding: 15px;
    vertical-align: middle;
}

.table-text .title {
    color: #fff;
    margin: 0;
    font-weight: 500;
}

.table-text .text {
    color: #ccc;
    margin: 0;
}

.site-badge {
    padding: 4px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
    text-transform: uppercase;
}

.site-badge.success {
    background: rgba(0, 255, 136, 0.2);
    color: #00ff88;
    border: 1px solid #00ff88;
}

.site-badge.warning {
    background: rgba(255, 193, 7, 0.2);
    color: #ffc107;
    border: 1px solid #ffc107;
}

.site-badge.pending {
    background: rgba(108, 117, 125, 0.2);
    color: #6c757d;
    border: 1px solid #6c757d;
}

.action-btn {
    display: flex;
    gap: 8px;
}

.site-btn-small {
    padding: 6px 12px;
    border-radius: 6px;
    font-size: 12px;
    font-weight: 500;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 4px;
    transition: all 0.3s ease;
}

.site-btn-small.primary-btn {
    background: rgba(0, 255, 136, 0.2);
    color: #00ff88;
    border: 1px solid #00ff88;
}

.site-btn-small.primary-btn:hover {
    background: #00ff88;
    color: #000;
    text-decoration: none;
}

.site-btn-small.warning-btn {
    background: rgba(255, 193, 7, 0.2);
    color: #ffc107;
    border: 1px solid #ffc107;
}

.site-btn-small.warning-btn:hover {
    background: #ffc107;
    color: #000;
    text-decoration: none;
}

.empty-state {
    text-align: center;
    padding: 40px 20px;
}

.empty-icon {
    width: 64px;
    height: 64px;
    color: #00ff88;
    margin-bottom: 20px;
}

.empty-state h4 {
    color: #fff;
    margin-bottom: 10px;
    font-weight: 600;
}

.empty-state p {
    color: #ccc;
    margin-bottom: 20px;
}

/* Mobile Styles */
@media (max-width: 768px) {
    .site-card-header {
        flex-direction: column;
        gap: 15px;
        text-align: center;
    }
    
    .site-card-header .title {
        font-size: 18px;
    }
    
    .site-btn {
        padding: 10px 20px;
        font-size: 14px;
    }
    
    .table {
        font-size: 12px;
    }
    
    .table thead th,
    .table tbody td {
        padding: 8px;
    }
    
    .action-btn {
        flex-direction: column;
        gap: 5px;
    }
    
    .site-btn-small {
        padding: 4px 8px;
        font-size: 10px;
    }
}

/* Mobile Ticket List */
.mobile-ticket-list {
    display: none;
}

@media (max-width: 768px) {
    .site-table {
        display: none;
    }
    
    .mobile-ticket-list {
        display: block;
    }
    
    .mobile-ticket-item {
        background: rgba(255, 255, 255, 0.05);
        border: 1px solid rgba(255, 255, 255, 0.1);
        border-radius: 10px;
        padding: 15px;
        margin-bottom: 15px;
    }
    
    .ticket-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 10px;
    }
    
    .ticket-id {
        color: #00ff88;
        font-weight: 600;
        font-size: 12px;
    }
    
    .ticket-title {
        color: #fff;
        font-weight: 600;
        margin-bottom: 8px;
        font-size: 16px;
    }
    
    .ticket-date {
        color: #ccc;
        font-size: 12px;
        margin-bottom: 15px;
    }
    
    .ticket-actions {
        display: flex;
        gap: 10px;
    }
    
    .ticket-actions .site-btn-small {
        flex: 1;
        text-align: center;
        padding: 8px 12px;
        font-size: 12px;
    }
}
</style>
@endpush