<?php

require __DIR__ . '/../vendor/autoload.php';

$app = require_once __DIR__ . '/../bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use Illuminate\Support\Facades\DB;

$ongoing = DB::table('invests')->where('status', 'ongoing')->count();
$completed = DB::table('invests')->where('status', 'completed')->count();

$pendingRoi = DB::table('roi_schedules')->where('status', 'pending')->count();
$readyRoi = DB::table('roi_schedules')->where('status', 'ready')->count();
$sentRoi = DB::table('roi_schedules')->where('status', 'sent')->count();
$completedRoi = DB::table('roi_schedules')->where('status', 'completed')->count();

$now = now();

// How many pending ROI schedules have timer still running (end time in future)
$pendingRunning = DB::table('roi_schedules')
    ->where('status', 'pending')
    ->where('roi_end_time', '>', $now)
    ->count();

// How many pending ROI schedules are overdue (should be ready)
$pendingOverdue = DB::table('roi_schedules')
    ->where('status', 'pending')
    ->where('roi_end_time', '<=', $now)
    ->count();

echo "Invests - ongoing: {$ongoing}\n";
echo "Invests - completed: {$completed}\n";
echo "ROI schedules - pending: {$pendingRoi}, ready: {$readyRoi}, sent: {$sentRoi}, completed: {$completedRoi}\n";
echo "ROI timer - pending running (before end): {$pendingRunning}, pending overdue (past end): {$pendingOverdue}\n";


