<?php

require __DIR__ . '/../vendor/autoload.php';

$app = require_once __DIR__ . '/../bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use Illuminate\Support\Facades\DB;

echo "Fetching Team Leader users...\n";

$users = DB::table('users as u')
    ->join('rankings as r', 'r.id', '=', 'u.ranking_id')
    ->where('r.ranking', 1) // Team Leader level
    ->select('u.id', 'u.username', 'u.first_name', 'u.last_name', 'u.email')
    ->orderBy('u.id')
    ->get();

echo "Total Team Leader users: " . $users->count() . "\n\n";

foreach ($users as $u) {
    echo sprintf("ID:%d | %s | %s %s | %s\n", $u->id, $u->username ?? '-', $u->first_name ?? '', $u->last_name ?? '', $u->email ?? '-');
}

echo "\nDone.\n";



