<?php

require __DIR__ . '/../vendor/autoload.php';

$app = require_once __DIR__ . '/../bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use Illuminate\Support\Facades\DB;

// Normalize pending ROI schedules to each schema's configured period (hours)
$fixed = 0;
$checked = 0;

DB::table('roi_schedules')
    ->select('roi_schedules.id','roi_schedules.roi_start_time','roi_schedules.roi_end_time','roi_schedules.status','schemas.roi_period')
    ->join('schemas','schemas.id','=','roi_schedules.schema_id')
    ->orderBy('roi_schedules.id')
    ->chunk(1000, function($chunk) use (&$fixed, &$checked) {
        foreach ($chunk as $row) {
            $checked++;
            if ($row->status !== 'pending') {
                continue;
            }
            $start = \Carbon\Carbon::parse($row->roi_start_time);
            $end = \Carbon\Carbon::parse($row->roi_end_time);
            $expectedMinutes = ((int)($row->roi_period ?? 24)) * 60; // roi_period is in hours
            $diff = $start->diffInMinutes($end, false);
            if ($diff !== $expectedMinutes) {
                $newEnd = $start->copy()->addMinutes($expectedMinutes);
                DB::table('roi_schedules')->where('id', $row->id)->update([
                    'roi_end_time' => $newEnd,
                ]);
                $fixed++;
            }
        }
    });

echo "Checked: {$checked}\n";
echo "Fixed to schema period: {$fixed}\n";


