<?php $__env->startSection('title'); ?>
<?php echo e(__('Withdraw Funds')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<!-- Withdraw Page -->
<div class="withdraw-page">
    <div class="withdraw-container">
        <div class="page-header">
            <h2>Withdraw Funds</h2>
            <p>Fast, secure, and reliable withdrawals to your preferred payment method</p>
        </div>

        <div class="withdraw-content">
            <!-- Balance Cards -->
            <div class="balance-cards">
                <div class="balance-card glass-effect">
                    <div class="balance-header">
                        <span>Main Wallet</span>
                        <i class="fas fa-wallet"></i>
                    </div>
                    <div class="balance-amount"><?php echo e($currencySymbol); ?><?php echo e(number_format($user->balance, 2)); ?></div>
                    <div class="balance-label">Available Balance</div>
                </div>
                
                <div class="balance-card glass-effect">
                    <div class="balance-header">
                        <span>Profit Wallet</span>
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <div class="balance-amount"><?php echo e($currencySymbol); ?><?php echo e(number_format($user->profit_balance, 2)); ?></div>
                    <div class="balance-label">Profit Balance</div>
                </div>
            </div>

            <!-- Withdraw Form -->
            <div class="withdraw-form glass-effect">
                <div class="form-header">
                    <h3>Select Withdrawal Method</h3>
                    <p>Choose your preferred withdrawal category</p>
                </div>

                <form action="<?php echo e(route('user.withdraw.simple.store')); ?>" method="post" id="withdrawForm">
                    <?php echo csrf_field(); ?>
                    
                    <!-- Method Type Selection -->
                    <div class="method-selection">
                        <div class="method-options">
                            <div class="method-option" onclick="selectMethodType('crypto')">
                                <input type="radio" name="method_type" value="crypto" id="crypto" style="display: none;">
                                <div class="method-card">
                                    <div class="method-icon">
                                        <i class="fab fa-bitcoin"></i>
                                    </div>
                                    <div class="method-content">
                                        <h4>Cryptocurrency</h4>
                                        <p>Bitcoin, Ethereum, USDT</p>
                                    </div>
                                    <div class="method-check">
                                        <div class="check-circle"></div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="method-option" onclick="selectMethodType('banking')">
                                <input type="radio" name="method_type" value="banking" id="banking" style="display: none;">
                                <div class="method-card">
                                    <div class="method-icon">
                                        <i class="fas fa-university"></i>
                                    </div>
                                    <div class="method-content">
                                        <h4>Banking Services</h4>
                                        <p>EasyPaisa, JazzCash, Bank Transfer</p>
                                    </div>
                                    <div class="method-check">
                                        <div class="check-circle"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Cryptocurrency Methods -->
                    <div class="crypto-methods" id="cryptoMethods" style="display: none;">
                        <div class="methods-header">
                            <h4>Cryptocurrency Methods</h4>
                            <p>Select your preferred crypto network</p>
                        </div>
                        <div class="methods-grid">
                            <?php $__currentLoopData = $methods['crypto']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="method-card-small" onclick="selectCryptoMethod('<?php echo e($key); ?>')">
                                <input type="radio" name="crypto_method" value="<?php echo e($key); ?>" id="<?php echo e($key); ?>" style="display: none;">
                                <div class="method-card-content">
                                    <div class="method-icon-small">
                                        <?php if(strpos($method['icon'], '.png') !== false || strpos($method['icon'], '.jpg') !== false || strpos($method['icon'], '.jpeg') !== false): ?>
                                            <img src="<?php echo e(asset($method['icon'])); ?>" alt="<?php echo e($method['name']); ?>" style="width: 24px; height: 24px; object-fit: contain;">
                                        <?php else: ?>
                                            <span style="font-size: 1.5rem;"><?php echo e($method['icon']); ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="method-details">
                                        <h5><?php echo e($method['name']); ?></h5>
                                        <div class="method-info">
                                            <span>Min: $<?php echo e($method['min_amount']); ?></span>
                                            <span>Max: $<?php echo e($method['max_amount']); ?></span>
                                            <span>Fee: <?php echo e($method['fee_percentage'] > 0 ? $method['fee_percentage'] . '%' : 'FREE'); ?></span>
                                        </div>
                                    </div>
                                    <div class="method-radio">
                                        <div class="radio-circle"></div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <!-- Banking Methods -->
                    <div class="banking-methods" id="bankingMethods" style="display: none;">
                        <div class="methods-header">
                            <h4>Banking Services</h4>
                            <p>Select your preferred banking method</p>
                        </div>
                        <div class="methods-grid">
                            <?php $__currentLoopData = $methods['banking']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="method-card-small" onclick="selectBankingMethod('<?php echo e($key); ?>')">
                                <input type="radio" name="banking_method" value="<?php echo e($key); ?>" id="<?php echo e($key); ?>" style="display: none;">
                                <div class="method-card-content">
                                    <div class="method-icon-small">
                                        <?php if(strpos($method['icon'], '.png') !== false || strpos($method['icon'], '.jpg') !== false || strpos($method['icon'], '.jpeg') !== false): ?>
                                            <img src="<?php echo e(asset($method['icon'])); ?>" alt="<?php echo e($method['name']); ?>" style="width: 24px; height: 24px; object-fit: contain;">
                                        <?php else: ?>
                                            <span style="font-size: 1.5rem;"><?php echo e($method['icon']); ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="method-details">
                                        <h5><?php echo e($method['name']); ?></h5>
                                        <div class="method-info">
                                            <span>Min: $<?php echo e($method['min_amount']); ?></span>
                                            <span>Max: $<?php echo e($method['max_amount']); ?></span>
                                            <span>Fee: <?php echo e($method['fee_percentage'] > 0 ? $method['fee_percentage'] . '%' : 'FREE'); ?></span>
                                        </div>
                                    </div>
                                    <div class="method-radio">
                                        <div class="radio-circle"></div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <!-- Amount Input -->
                    <div class="form-group">
                        <label for="amount">Withdrawal Amount</label>
                        <div class="amount-input">
                            <span class="currency-symbol"><?php echo e($currencySymbol); ?></span>
                            <input type="number" name="amount" id="amount" class="form-control" placeholder="0.00" step="0.01" min="0.01" required>
                        </div>
                        <small class="help-text">Minimum: <?php echo e($currencySymbol); ?><?php echo e(number_format(setting('min_withdraw', 'global'), 2)); ?></small>
                    </div>

                    <!-- Wallet Selection -->
                    <div class="form-group">
                        <label for="wallet">Select Wallet</label>
                        <select name="wallet" id="wallet" class="form-control" required>
                            <option value="main">Main Wallet (<?php echo e($currencySymbol); ?><?php echo e(number_format($user->balance, 2)); ?>)</option>
                            <option value="profit">Profit Wallet (<?php echo e($currencySymbol); ?><?php echo e(number_format($user->profit_balance, 2)); ?>)</option>
                        </select>
                    </div>

                    <!-- Wallet Details Section -->
                    <div class="wallet-details" id="walletDetails" style="display: none;">
                        <div class="details-header">
                            <h4>Wallet Details</h4>
                            <p>Please provide your withdrawal details</p>
                        </div>
                        
                        <!-- Crypto Wallet Details -->
                        <div class="crypto-details" id="cryptoDetails" style="display: none;">
                            <div class="form-group">
                                <label for="wallet_address">Wallet Address</label>
                                <input type="text" name="wallet_address" id="wallet_address" class="form-control" placeholder="Enter your wallet address">
                                <small class="help-text">Make sure the address is correct for the selected network</small>
                            </div>
                            
                            <div class="form-group">
                                <label for="network_type">Network Type</label>
                                <select name="network_type" id="network_type" class="form-control">
                                    <option value="">Select Network</option>
                                    <option value="mainnet">Mainnet</option>
                                    <option value="testnet">Testnet</option>
                                </select>
                            </div>
                        </div>
                        
                        <!-- Banking Details -->
                        <div class="banking-details" id="bankingDetails" style="display: none;">
                            <div class="form-group">
                                <label for="account_title">Account Title</label>
                                <input type="text" name="account_title" id="account_title" class="form-control" placeholder="Enter account holder name">
                            </div>
                            
                            <div class="form-group">
                                <label for="account_number">Account Number</label>
                                <input type="text" name="account_number" id="account_number" class="form-control" placeholder="Enter account number">
                            </div>
                            
                            <div class="form-group">
                                <label for="bank_name">Bank Name</label>
                                <input type="text" name="bank_name" id="bank_name" class="form-control" placeholder="Enter bank name">
                            </div>
                            
                            <div class="form-group">
                                <label for="branch_code">Branch Code</label>
                                <input type="text" name="branch_code" id="branch_code" class="form-control" placeholder="Enter branch code">
                            </div>
                        </div>
                        
                        <!-- Mobile Payment Details -->
                        <div class="mobile-details" id="mobileDetails" style="display: none;">
                            <div class="form-group">
                                <label for="mobile_number">Mobile Number</label>
                                <input type="text" name="mobile_number" id="mobile_number" class="form-control" placeholder="Enter mobile number">
                            </div>
                            
                            <div class="form-group">
                                <label for="account_name">Account Name</label>
                                <input type="text" name="account_name" id="account_name" class="form-control" placeholder="Enter account holder name">
                            </div>
                        </div>
                    </div>

                    <!-- Withdrawal Details -->
                    <div class="withdrawal-details" id="withdrawalDetails" style="display: none;">
                        <div class="details-header">
                            <h4>Withdrawal Details</h4>
                        </div>
                        <div class="details-content" id="detailsContent">
                            <!-- Dynamic content will be loaded here -->
                        </div>
                    </div>

                    <!-- Form Actions -->
                    <div class="form-actions">
                        <button type="button" class="btn-cancel" onclick="resetForm()">
                            <i class="fas fa-times"></i>
                            <span>Cancel</span>
                        </button>
                        <button type="submit" class="btn-withdraw">
                            <i class="fas fa-paper-plane"></i>
                            <span>Submit Withdrawal</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<style>
.withdraw-page {
    min-height: 100vh;
    background: linear-gradient(135deg, var(--background-primary) 0%, var(--background-secondary) 100%);
    padding: 20px 0;
}

.withdraw-container {
    max-width: 800px;
    margin: 0 auto;
    padding: 0 20px;
}

.page-header {
    text-align: center;
    margin-bottom: 30px;
}

.page-header h2 {
    font-size: 28px;
    font-weight: 700;
    color: var(--text-primary);
    margin-bottom: 10px;
}

.page-header p {
    color: var(--text-secondary);
    font-size: 16px;
}

.withdraw-content {
    display: grid;
    gap: 30px;
}

.balance-cards {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 20px;
    margin-bottom: 20px;
}

.balance-card {
    background: linear-gradient(135deg, rgba(15, 23, 42, 0.8) 0%, rgba(30, 41, 59, 0.6) 100%);
    backdrop-filter: blur(25px);
    border-radius: 20px;
    padding: 25px;
    border: 1px solid rgba(255, 255, 255, 0.1);
    color: white;
    text-align: center;
}

.balance-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 15px;
    font-size: 14px;
    color: rgba(255, 255, 255, 0.8);
}

.balance-amount {
    font-size: 24px;
    font-weight: 700;
    margin-bottom: 5px;
}

.balance-label {
    font-size: 12px;
    color: rgba(255, 255, 255, 0.7);
}

.withdraw-form {
    background: linear-gradient(135deg, rgba(15, 23, 42, 0.8) 0%, rgba(30, 41, 59, 0.6) 100%);
    backdrop-filter: blur(25px);
    border-radius: 20px;
    padding: 30px;
    border: 1px solid rgba(255, 255, 255, 0.1);
    color: white;
}

.form-header {
    text-align: center;
    margin-bottom: 30px;
}

.form-header h3 {
    font-size: 24px;
    font-weight: 700;
    margin-bottom: 10px;
}

.form-header p {
    color: rgba(255, 255, 255, 0.8);
    font-size: 14px;
}

.method-selection {
    margin-bottom: 30px;
}

.method-options {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 15px;
}

.method-option {
    cursor: pointer;
}

.method-card {
    background: rgba(255, 255, 255, 0.05);
    border: 2px solid rgba(255, 255, 255, 0.1);
    border-radius: 15px;
    padding: 20px;
    text-align: center;
    transition: all 0.3s ease;
    position: relative;
}

.method-card:hover {
    background: rgba(255, 255, 255, 0.1);
    border-color: rgba(255, 255, 255, 0.2);
}

.method-option.selected .method-card {
    background: rgba(102, 126, 234, 0.2);
    border-color: #667eea;
}

.method-icon {
    font-size: 32px;
    margin-bottom: 15px;
    color: #667eea;
}

.method-content h4 {
    font-size: 16px;
    font-weight: 600;
    margin-bottom: 5px;
}

.method-content p {
    font-size: 12px;
    color: rgba(255, 255, 255, 0.7);
}

.method-check {
    position: absolute;
    top: 15px;
    right: 15px;
}

.check-circle {
    width: 20px;
    height: 20px;
    border: 2px solid rgba(255, 255, 255, 0.3);
    border-radius: 50%;
    transition: all 0.3s ease;
}

.method-option.selected .check-circle {
    background: #667eea;
    border-color: #667eea;
}

.method-option.selected .check-circle::after {
    content: '✓';
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    color: white;
    font-size: 12px;
    font-weight: bold;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    margin-bottom: 8px;
    font-weight: 600;
    color: rgba(255, 255, 255, 0.9);
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    border-radius: 12px;
    border: 1px solid rgba(255, 255, 255, 0.2);
    background: rgba(255, 255, 255, 0.1);
    color: white;
    font-size: 16px;
    transition: all 0.3s ease;
    cursor: text;
    position: relative;
    z-index: 2;
}

.form-control:focus {
    outline: none;
    border-color: rgba(255, 255, 255, 0.4);
    background: rgba(255, 255, 255, 0.15);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.6);
}

.amount-input {
    position: relative;
    display: flex;
    align-items: center;
}

.currency-symbol {
    position: absolute;
    left: 15px;
    color: rgba(255, 255, 255, 0.7);
    font-weight: 600;
    z-index: 1;
    pointer-events: none;
}

.amount-input .form-control {
    padding-left: 40px;
    position: relative;
    z-index: 2;
    background: rgba(255, 255, 255, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
    color: white;
    cursor: text;
}

.help-text {
    display: block;
    margin-top: 5px;
    color: rgba(255, 255, 255, 0.7);
    font-size: 12px;
}

.withdrawal-details {
    background: rgba(255, 255, 255, 0.05);
    border-radius: 15px;
    padding: 20px;
    margin-bottom: 25px;
}

.details-header h4 {
    font-size: 18px;
    font-weight: 600;
    margin-bottom: 15px;
}

.form-actions {
    display: flex;
    gap: 15px;
    margin-top: 30px;
}

.btn-cancel, .btn-withdraw {
    flex: 1;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    padding: 12px 20px;
    border-radius: 12px;
    font-weight: 600;
    text-decoration: none;
    transition: all 0.3s ease;
    border: none;
    cursor: pointer;
    font-size: 16px;
}

.btn-cancel {
    background: rgba(255, 255, 255, 0.1);
    color: white;
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.btn-cancel:hover {
    background: rgba(255, 255, 255, 0.2);
    color: white;
    text-decoration: none;
}

.btn-withdraw {
    background: linear-gradient(135deg, #667eea, #764ba2);
    color: white;
}

.btn-withdraw:hover {
    background: linear-gradient(135deg, #5a67d8, #6b46c1);
    transform: translateY(-2px);
}

/* Methods Section Styles */
.crypto-methods, .banking-methods {
    margin-top: 30px;
    padding: 25px;
    background: rgba(255, 255, 255, 0.05);
    border-radius: 15px;
    border: 1px solid rgba(255, 255, 255, 0.1);
}

/* Wallet Details Styles */
.wallet-details {
    margin-top: 30px;
    padding: 25px;
    background: rgba(255, 255, 255, 0.05);
    border-radius: 15px;
    border: 1px solid rgba(255, 255, 255, 0.1);
}

.details-header {
    text-align: center;
    margin-bottom: 25px;
}

.details-header h4 {
    font-size: 20px;
    font-weight: 700;
    margin-bottom: 8px;
    color: rgba(255, 255, 255, 0.9);
}

.details-header p {
    color: rgba(255, 255, 255, 0.7);
    font-size: 14px;
}

.crypto-details, .banking-details, .mobile-details {
    display: grid;
    gap: 20px;
}

.crypto-details {
    grid-template-columns: 1fr 1fr;
}

.banking-details {
    grid-template-columns: 1fr 1fr;
}

.mobile-details {
    grid-template-columns: 1fr 1fr;
}

@media (max-width: 768px) {
    .crypto-details, .banking-details, .mobile-details {
        grid-template-columns: 1fr;
    }
}

.methods-header {
    text-align: center;
    margin-bottom: 25px;
}

.methods-header h4 {
    font-size: 20px;
    font-weight: 700;
    margin-bottom: 8px;
    color: rgba(255, 255, 255, 0.9);
}

.methods-header p {
    color: rgba(255, 255, 255, 0.7);
    font-size: 14px;
}

.methods-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 15px;
}

.method-card-small {
    cursor: pointer;
    transition: all 0.3s ease;
}

.method-card-content {
    background: rgba(255, 255, 255, 0.05);
    border: 2px solid rgba(255, 255, 255, 0.1);
    border-radius: 12px;
    padding: 20px;
    display: flex;
    align-items: center;
    gap: 15px;
    transition: all 0.3s ease;
    position: relative;
}

.method-card-small:hover .method-card-content {
    background: rgba(255, 255, 255, 0.1);
    border-color: rgba(255, 255, 255, 0.2);
}

.method-card-small.selected .method-card-content {
    background: rgba(102, 126, 234, 0.2);
    border-color: #667eea;
}

.method-icon-small {
    font-size: 24px;
    width: 40px;
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 10px;
}

.method-details h5 {
    font-size: 16px;
    font-weight: 600;
    margin-bottom: 8px;
    color: rgba(255, 255, 255, 0.9);
}

.method-info {
    display: flex;
    flex-direction: column;
    gap: 4px;
}

.method-info span {
    font-size: 12px;
    color: rgba(255, 255, 255, 0.7);
}

.method-radio {
    position: absolute;
    top: 15px;
    right: 15px;
}

.radio-circle {
    width: 20px;
    height: 20px;
    border: 2px solid rgba(255, 255, 255, 0.3);
    border-radius: 50%;
    transition: all 0.3s ease;
}

.method-card-small.selected .radio-circle {
    background: #667eea;
    border-color: #667eea;
}

.method-card-small.selected .radio-circle::after {
    content: '✓';
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    color: white;
    font-size: 12px;
    font-weight: bold;
}

@media (max-width: 768px) {
    .withdraw-container {
        padding: 0 15px;
    }
    
    .balance-cards {
        grid-template-columns: 1fr;
    }
    
    .method-options {
        grid-template-columns: 1fr;
    }
    
    .methods-grid {
        grid-template-columns: 1fr;
    }
    
    .form-actions {
        flex-direction: column;
    }
}
</style>

<script>
function selectMethodType(type) {
    // Remove selected class from all options
    document.querySelectorAll('.method-option').forEach(option => {
        option.classList.remove('selected');
    });
    
    // Add selected class to clicked option
    event.currentTarget.classList.add('selected');
    
    // Set radio button value
    document.querySelector(`input[name="method_type"][value="${type}"]`).checked = true;
    
    // Hide all method sections
    document.getElementById('cryptoMethods').style.display = 'none';
    document.getElementById('bankingMethods').style.display = 'none';
    
    // Show selected method section
    if (type === 'crypto') {
        document.getElementById('cryptoMethods').style.display = 'block';
    } else if (type === 'banking') {
        document.getElementById('bankingMethods').style.display = 'block';
    }
}

function selectCryptoMethod(method) {
    // Remove selected class from all crypto methods
    document.querySelectorAll('.method-card-small').forEach(card => {
        card.classList.remove('selected');
    });
    
    // Add selected class to clicked method
    event.currentTarget.classList.add('selected');
    
    // Set the selected method value
    const radioButton = document.querySelector('input[name="crypto_method"][value="' + method + '"]');
    if (radioButton) {
        radioButton.checked = true;
    }
    
    // Show wallet details
    showWalletDetails('crypto');
}

function selectBankingMethod(method) {
    // Remove selected class from all banking methods
    document.querySelectorAll('.method-card-small').forEach(card => {
        card.classList.remove('selected');
    });
    
    // Add selected class to clicked method
    event.currentTarget.classList.add('selected');
    
    // Set the selected method value
    const radioButton = document.querySelector('input[name="banking_method"][value="' + method + '"]');
    if (radioButton) {
        radioButton.checked = true;
    }
    
    // Show wallet details based on method
    if (method === 'easypaisa' || method === 'jazzcash') {
        showWalletDetails('mobile');
    } else {
        showWalletDetails('banking');
    }
}

function showWalletDetails(type) {
    // Hide all wallet detail sections
    document.getElementById('cryptoDetails').style.display = 'none';
    document.getElementById('bankingDetails').style.display = 'none';
    document.getElementById('mobileDetails').style.display = 'none';
    
    // Show wallet details section
    document.getElementById('walletDetails').style.display = 'block';
    
    // Show specific details based on type
    if (type === 'crypto') {
        document.getElementById('cryptoDetails').style.display = 'block';
    } else if (type === 'banking') {
        document.getElementById('bankingDetails').style.display = 'block';
    } else if (type === 'mobile') {
        document.getElementById('mobileDetails').style.display = 'block';
    }
}

function resetForm() {
    document.getElementById('withdrawForm').reset();
    document.querySelectorAll('.method-option').forEach(option => {
        option.classList.remove('selected');
    });
    document.querySelectorAll('.method-card-small').forEach(card => {
        card.classList.remove('selected');
    });
    document.getElementById('cryptoMethods').style.display = 'none';
    document.getElementById('bankingMethods').style.display = 'none';
    document.getElementById('walletDetails').style.display = 'none';
    document.getElementById('withdrawalDetails').style.display = 'none';
}

// Form submission
document.getElementById('withdrawForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const methodType = formData.get('method_type');
    const cryptoMethod = formData.get('crypto_method');
    const bankingMethod = formData.get('banking_method');
    const amount = formData.get('amount');
    const wallet = formData.get('wallet');
    
    // Check if method type is selected
    if (!methodType) {
        alert('Please select a withdrawal method type (Cryptocurrency or Banking Services)');
        return;
    }
    
    // Check if specific method is selected
    if (methodType === 'crypto' && !cryptoMethod) {
        alert('Please select a cryptocurrency method');
        return;
    }
    
    if (methodType === 'banking' && !bankingMethod) {
        alert('Please select a banking method');
        return;
    }
    
    // Debug: Log form data
    console.log('Form Data:', {
        methodType: methodType,
        cryptoMethod: cryptoMethod,
        bankingMethod: bankingMethod,
        amount: amount,
        wallet: wallet
    });
    
    // Debug: Log form data
    console.log('Form validation passed. Submitting data...');
    
    // Ensure amount field is focusable
    const amountField = document.getElementById('amount');
    if (amountField) {
        amountField.style.pointerEvents = 'auto';
        amountField.style.zIndex = '10';
    }
    
    // Check amount
    if (!amount || amount <= 0) {
        alert('Please enter a valid withdrawal amount');
        return;
    }
    
    // Check wallet selection
    if (!wallet) {
        alert('Please select a wallet');
        return;
    }
    
    // Check required fields based on method
    if (methodType === 'crypto') {
        const walletAddress = formData.get('wallet_address');
        if (!walletAddress) {
            alert('Please enter your wallet address');
            return;
        }
    }
    
    // Show loading state
    const submitBtn = document.querySelector('.btn-withdraw');
    const originalText = submitBtn.innerHTML;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i><span>Processing...</span>';
    submitBtn.disabled = true;
    
    // Submit form via AJAX
    console.log('Submitting form data:', Object.fromEntries(formData));
    
    fetch('<?php echo e(route("user.withdraw.simple.store")); ?>', {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        }
    })
    .then(response => {
        console.log('Response status:', response.status);
        console.log('Response headers:', response.headers);
        
        // Check if response is JSON
        const contentType = response.headers.get('content-type');
        if (!contentType || !contentType.includes('application/json')) {
            throw new Error('Server returned non-JSON response. Status: ' + response.status);
        }
        
        return response.json();
    })
    .then(data => {
        console.log('Response data:', data);
        if (data.success) {
            // Show success message
            alert('Withdrawal request submitted successfully!');
            // Redirect to success page
            window.location.href = '<?php echo e(route("user.withdraw.simple.success")); ?>';
        } else {
            // Show error message
            alert(data.message || 'Error submitting withdrawal request');
            // Reset button
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Error submitting withdrawal request: ' + error.message);
        // Reset button
        submitBtn.innerHTML = originalText;
        submitBtn.disabled = false;
    });
});

// Ensure amount field is clickable on page load
document.addEventListener('DOMContentLoaded', function() {
    const amountField = document.getElementById('amount');
    if (amountField) {
        amountField.style.pointerEvents = 'auto';
        amountField.style.zIndex = '10';
        amountField.style.cursor = 'text';
        
        // Add click event to ensure it's focusable
        amountField.addEventListener('click', function() {
            this.focus();
        });
    }
});
</script>



<?php echo $__env->make('frontend.shahdeveloper.layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digitalx/blockwavetrade.com/resources/views/frontend/shahdeveloper/user/withdraw/simple.blade.php ENDPATH**/ ?>