

<?php $__env->startSection('title'); ?>
<?php echo e(__('Withdraw Funds')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="withdraw-page">
    <div class="withdraw-container">
        <div class="page-header">
            <h2>Withdraw Funds</h2>
            <p>Fast, secure, and reliable withdrawals to your preferred payment method</p>
        </div>

        <div class="withdraw-content">
            <!-- Balance Cards -->
            <div class="balance-cards">
                <div class="balance-card glass-effect">
                    <div class="balance-header">
                        <span>Main Wallet</span>
                        <i class="fas fa-wallet"></i>
                    </div>
                    <div class="balance-amount"><?php echo e($currencySymbol); ?><?php echo e(number_format($user->balance, 2)); ?></div>
                    <div class="balance-label">Available Balance</div>
                </div>
                
                <div class="balance-card glass-effect">
                    <div class="balance-header">
                        <span>Profit Wallet</span>
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <div class="balance-amount"><?php echo e($currencySymbol); ?><?php echo e(number_format($user->profit_balance, 2)); ?></div>
                    <div class="balance-label">Profit Balance</div>
                </div>
            </div>

            <!-- Withdraw Form -->
            <div class="withdraw-form glass-effect">
                <div class="form-header">
                    <h3>Select Withdrawal Method</h3>
                    <p>Choose your preferred withdrawal method</p>
                </div>

                <form id="withdrawForm">
                    <?php echo csrf_field(); ?>
                    
                    <!-- Method Selection -->
                    <div class="method-selection">
                        <div class="methods-grid">
                            <?php $__currentLoopData = $methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type => $typeMethods): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="method-type-section">
                                <h4 class="method-type-title"><?php echo e(ucfirst($type)); ?> Methods</h4>
                                <div class="method-options">
                                    <?php $__currentLoopData = $typeMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="method-option" data-method-id="<?php echo e($method->id); ?>" data-type="<?php echo e($method->type); ?>">
                                        <input type="radio" name="withdraw_method_id" value="<?php echo e($method->id); ?>" id="method_<?php echo e($method->id); ?>" style="display: none;">
                                        <div class="method-card">
                                            <div class="method-icon">
                                                <?php if($method->icon): ?>
                                                    <?php if(strpos($method->icon, '.png') !== false || strpos($method->icon, '.jpg') !== false || strpos($method->icon, '.jpeg') !== false): ?>
                                                        <img src="<?php echo e(asset($method->icon)); ?>" alt="<?php echo e($method->name); ?>" style="width: 32px; height: 32px; object-fit: contain;">
                                                    <?php else: ?>
                                                        <span style="font-size: 1.5rem;"><?php echo e($method->icon); ?></span>
                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    <i class="fas fa-money-bill-wave"></i>
                                                <?php endif; ?>
                                            </div>
                                            <div class="method-content">
                                                <h5><?php echo e($method->name); ?></h5>
                                                <div class="method-info">
                                                    <span>Min: <?php echo e($currencySymbol); ?><?php echo e(number_format($method->min_amount, 2)); ?></span>
                                                    <span>Max: <?php echo e($currencySymbol); ?><?php echo e(number_format($method->max_amount, 2)); ?></span>
                                                    <span>Fee: <?php echo e($method->fee_percentage > 0 ? $method->fee_percentage . '%' : 'FREE'); ?></span>
                                                </div>
                                            </div>
                                            <div class="method-check">
                                                <div class="check-circle"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <!-- Amount Input -->
                    <div class="form-group">
                        <label for="amount">Withdrawal Amount</label>
                        <div class="amount-input">
                            <span class="currency-symbol"><?php echo e($currencySymbol); ?></span>
                            <input type="number" name="amount" id="amount" class="form-control" placeholder="0.00" step="0.01" min="0.01" required>
                        </div>
                        <small class="help-text">Enter the amount you want to withdraw</small>
                    </div>

                    <!-- Wallet Selection -->
                    <div class="form-group">
                        <label for="wallet_type">Select Wallet</label>
                        <select name="wallet_type" id="wallet_type" class="form-control" required>
                            <option value="main">Main Wallet (<?php echo e($currencySymbol); ?><?php echo e(number_format($user->balance, 2)); ?>)</option>
                            <option value="profit">Profit Wallet (<?php echo e($currencySymbol); ?><?php echo e(number_format($user->profit_balance, 2)); ?>)</option>
                        </select>
                    </div>

                    <!-- Method Details Section -->
                    <div class="method-details" id="methodDetails" style="display: none;">
                        <div class="details-header">
                            <h4>Payment Details</h4>
                            <p>Please provide your payment details</p>
                        </div>
                        <div class="details-content" id="detailsContent">
                            <!-- Dynamic content will be loaded here -->
                        </div>
                    </div>

                    <!-- Fee Calculation -->
                    <div class="fee-calculation" id="feeCalculation" style="display: none;">
                        <div class="fee-card">
                            <h4>Fee Calculation</h4>
                            <div class="fee-details">
                                <div class="fee-item">
                                    <span>Amount:</span>
                                    <span id="feeAmount"><?php echo e($currencySymbol); ?>0.00</span>
                                </div>
                                <div class="fee-item">
                                    <span>Fee:</span>
                                    <span id="feeFee"><?php echo e($currencySymbol); ?>0.00</span>
                                </div>
                                <div class="fee-item total">
                                    <span>You will receive:</span>
                                    <span id="feeFinal"><?php echo e($currencySymbol); ?>0.00</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Form Actions -->
                    <div class="form-actions">
                        <button type="button" class="btn-cancel" onclick="resetForm()">
                            <i class="fas fa-times"></i>
                            <span>Cancel</span>
                        </button>
                        <button type="submit" class="btn-withdraw">
                            <i class="fas fa-paper-plane"></i>
                            <span>Submit Withdrawal</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<style>
.withdraw-page {
    min-height: 100vh;
    background: linear-gradient(135deg, var(--background-primary) 0%, var(--background-secondary) 100%);
    padding: 20px 0;
}

.withdraw-container {
    max-width: 900px;
    margin: 0 auto;
    padding: 0 20px;
}

.page-header {
    text-align: center;
    margin-bottom: 30px;
}

.page-header h2 {
    font-size: 28px;
    font-weight: 700;
    color: var(--text-primary);
    margin-bottom: 10px;
}

.page-header p {
    color: var(--text-secondary);
    font-size: 16px;
}

.withdraw-content {
    display: grid;
    gap: 30px;
}

.balance-cards {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 20px;
    margin-bottom: 20px;
}

.balance-card {
    background: linear-gradient(135deg, rgba(15, 23, 42, 0.8) 0%, rgba(30, 41, 59, 0.6) 100%);
    backdrop-filter: blur(25px);
    border-radius: 20px;
    padding: 25px;
    border: 1px solid rgba(255, 255, 255, 0.1);
    color: white;
    text-align: center;
}

.balance-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 15px;
    font-size: 14px;
    color: rgba(255, 255, 255, 0.8);
}

.balance-amount {
    font-size: 24px;
    font-weight: 700;
    margin-bottom: 5px;
}

.balance-label {
    font-size: 12px;
    color: rgba(255, 255, 255, 0.7);
}

.withdraw-form {
    background: linear-gradient(135deg, rgba(15, 23, 42, 0.8) 0%, rgba(30, 41, 59, 0.6) 100%);
    backdrop-filter: blur(25px);
    border-radius: 20px;
    padding: 30px;
    border: 1px solid rgba(255, 255, 255, 0.1);
    color: white;
}

.form-header {
    text-align: center;
    margin-bottom: 30px;
}

.form-header h3 {
    font-size: 24px;
    font-weight: 700;
    margin-bottom: 10px;
}

.form-header p {
    color: rgba(255, 255, 255, 0.8);
    font-size: 14px;
}

.method-type-section {
    margin-bottom: 30px;
}

.method-type-title {
    font-size: 18px;
    font-weight: 600;
    margin-bottom: 15px;
    color: rgba(255, 255, 255, 0.9);
}

.method-options {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 15px;
}

.method-option {
    cursor: pointer;
}

.method-card {
    background: rgba(255, 255, 255, 0.05);
    border: 2px solid rgba(255, 255, 255, 0.1);
    border-radius: 15px;
    padding: 20px;
    text-align: center;
    transition: all 0.3s ease;
    position: relative;
}

.method-card:hover {
    background: rgba(255, 255, 255, 0.1);
    border-color: rgba(255, 255, 255, 0.2);
}

.method-option.selected .method-card {
    background: rgba(102, 126, 234, 0.2);
    border-color: #667eea;
}

.method-icon {
    font-size: 32px;
    margin-bottom: 15px;
    color: #667eea;
}

.method-content h5 {
    font-size: 16px;
    font-weight: 600;
    margin-bottom: 10px;
}

.method-info {
    display: flex;
    flex-direction: column;
    gap: 4px;
}

.method-info span {
    font-size: 12px;
    color: rgba(255, 255, 255, 0.7);
}

.method-check {
    position: absolute;
    top: 15px;
    right: 15px;
}

.check-circle {
    width: 20px;
    height: 20px;
    border: 2px solid rgba(255, 255, 255, 0.3);
    border-radius: 50%;
    transition: all 0.3s ease;
}

.method-option.selected .check-circle {
    background: #667eea;
    border-color: #667eea;
}

.method-option.selected .check-circle::after {
    content: '✓';
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    color: white;
    font-size: 12px;
    font-weight: bold;
}

.form-group {
    margin-bottom: 25px;
}

.form-group label {
    display: block;
    margin-bottom: 8px;
    font-weight: 600;
    color: rgba(255, 255, 255, 0.9);
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    border-radius: 12px;
    border: 1px solid rgba(255, 255, 255, 0.2);
    background: rgba(255, 255, 255, 0.1);
    color: white;
    font-size: 16px;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: rgba(255, 255, 255, 0.4);
    background: rgba(255, 255, 255, 0.15);
}

.form-control::placeholder {
    color: rgba(255, 255, 255, 0.6);
}

.amount-input {
    position: relative;
    display: flex;
    align-items: center;
}

.currency-symbol {
    position: absolute;
    left: 15px;
    color: rgba(255, 255, 255, 0.7);
    font-weight: 600;
    z-index: 1;
    pointer-events: none;
}

.amount-input .form-control {
    padding-left: 40px;
}

.help-text {
    display: block;
    margin-top: 5px;
    color: rgba(255, 255, 255, 0.7);
    font-size: 12px;
}

.method-details {
    background: rgba(255, 255, 255, 0.05);
    border-radius: 15px;
    padding: 20px;
    margin-bottom: 25px;
}

.details-header h4 {
    font-size: 18px;
    font-weight: 600;
    margin-bottom: 15px;
}

.details-header p {
    color: rgba(255, 255, 255, 0.7);
    font-size: 14px;
}

.fee-calculation {
    background: rgba(102, 126, 234, 0.1);
    border-radius: 15px;
    padding: 20px;
    margin-bottom: 25px;
    border: 1px solid rgba(102, 126, 234, 0.2);
}

.fee-card h4 {
    font-size: 18px;
    font-weight: 600;
    margin-bottom: 15px;
    color: #667eea;
}

.fee-details {
    display: flex;
    flex-direction: column;
    gap: 10px;
}

.fee-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 8px 0;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.fee-item.total {
    font-weight: 600;
    font-size: 16px;
    color: #667eea;
    border-bottom: none;
    border-top: 2px solid rgba(102, 126, 234, 0.3);
    padding-top: 15px;
    margin-top: 10px;
}

.form-actions {
    display: flex;
    gap: 15px;
    margin-top: 30px;
}

.btn-cancel, .btn-withdraw {
    flex: 1;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    padding: 12px 20px;
    border-radius: 12px;
    font-weight: 600;
    text-decoration: none;
    transition: all 0.3s ease;
    border: none;
    cursor: pointer;
    font-size: 16px;
}

.btn-cancel {
    background: rgba(255, 255, 255, 0.1);
    color: white;
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.btn-cancel:hover {
    background: rgba(255, 255, 255, 0.2);
    color: white;
    text-decoration: none;
}

.btn-withdraw {
    background: linear-gradient(135deg, #667eea, #764ba2);
    color: white;
}

.btn-withdraw:hover {
    background: linear-gradient(135deg, #5a67d8, #6b46c1);
    transform: translateY(-2px);
}

@media (max-width: 768px) {
    .withdraw-container {
        padding: 0 15px;
    }
    
    .balance-cards {
        grid-template-columns: 1fr;
    }
    
    .method-options {
        grid-template-columns: 1fr;
    }
    
    .form-actions {
        flex-direction: column;
    }
}
</style>

<script>
let selectedMethod = null;
let methodData = {};

// Method selection
document.querySelectorAll('.method-option').forEach(option => {
    option.addEventListener('click', function() {
        // Remove selected class from all options
        document.querySelectorAll('.method-option').forEach(opt => {
            opt.classList.remove('selected');
        });
        
        // Add selected class to clicked option
        this.classList.add('selected');
        
        // Set radio button
        const radio = this.querySelector('input[type="radio"]');
        radio.checked = true;
        
        // Get method data
        selectedMethod = {
            id: this.dataset.methodId,
            type: this.dataset.type
        };
        
        // Show method details
        showMethodDetails();
        updateFeeCalculation();
    });
});

// Amount input change
document.getElementById('amount').addEventListener('input', function() {
    updateFeeCalculation();
});

function showMethodDetails() {
    if (!selectedMethod) return;
    
    const detailsContainer = document.getElementById('detailsContent');
    const methodDetails = document.getElementById('methodDetails');
    
    // Show method details section
    methodDetails.style.display = 'block';
    
    // Generate form fields based on method type
    let fieldsHtml = '';
    
    if (selectedMethod.type === 'crypto') {
        fieldsHtml = `
            <div class="form-group">
                <label for="wallet_address">Wallet Address</label>
                <input type="text" name="method_details[wallet_address]" id="wallet_address" class="form-control" placeholder="Enter your wallet address" required>
                <small class="help-text">Make sure the address is correct for the selected network</small>
            </div>
            <div class="form-group">
                <label for="network_type">Network Type</label>
                <select name="method_details[network_type]" id="network_type" class="form-control" required>
                    <option value="">Select Network</option>
                    <option value="mainnet">Mainnet</option>
                    <option value="testnet">Testnet</option>
                </select>
            </div>
        `;
    } else if (selectedMethod.type === 'banking') {
        fieldsHtml = `
            <div class="form-group">
                <label for="account_title">Account Title</label>
                <input type="text" name="method_details[account_title]" id="account_title" class="form-control" placeholder="Enter account holder name" required>
            </div>
            <div class="form-group">
                <label for="account_number">Account Number</label>
                <input type="text" name="method_details[account_number]" id="account_number" class="form-control" placeholder="Enter account number" required>
            </div>
            <div class="form-group">
                <label for="bank_name">Bank Name</label>
                <input type="text" name="method_details[bank_name]" id="bank_name" class="form-control" placeholder="Enter bank name" required>
            </div>
            <div class="form-group">
                <label for="branch_code">Branch Code</label>
                <input type="text" name="method_details[branch_code]" id="branch_code" class="form-control" placeholder="Enter branch code">
            </div>
        `;
    } else if (selectedMethod.type === 'mobile') {
        fieldsHtml = `
            <div class="form-group">
                <label for="mobile_number">Mobile Number</label>
                <input type="text" name="method_details[mobile_number]" id="mobile_number" class="form-control" placeholder="Enter mobile number" required>
            </div>
            <div class="form-group">
                <label for="account_name">Account Name</label>
                <input type="text" name="method_details[account_name]" id="account_name" class="form-control" placeholder="Enter account holder name" required>
            </div>
        `;
    }
    
    detailsContainer.innerHTML = fieldsHtml;
}

function updateFeeCalculation() {
    if (!selectedMethod || !document.getElementById('amount').value) {
        document.getElementById('feeCalculation').style.display = 'none';
        return;
    }
    
    const amount = parseFloat(document.getElementById('amount').value) || 0;
    
    // For now, we'll calculate fee on frontend (in real app, this should come from backend)
    const feePercentage = 2; // 2% fee
    const feeFixed = 0; // No fixed fee
    const fee = (amount * feePercentage / 100) + feeFixed;
    const finalAmount = amount - fee;
    
    document.getElementById('feeAmount').textContent = '<?php echo e($currencySymbol); ?>' + amount.toFixed(2);
    document.getElementById('feeFee').textContent = '<?php echo e($currencySymbol); ?>' + fee.toFixed(2);
    document.getElementById('feeFinal').textContent = '<?php echo e($currencySymbol); ?>' + finalAmount.toFixed(2);
    
    document.getElementById('feeCalculation').style.display = 'block';
}

function resetForm() {
    document.getElementById('withdrawForm').reset();
    document.querySelectorAll('.method-option').forEach(option => {
        option.classList.remove('selected');
    });
    document.getElementById('methodDetails').style.display = 'none';
    document.getElementById('feeCalculation').style.display = 'none';
    selectedMethod = null;
}

// Form submission
document.getElementById('withdrawForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    if (!selectedMethod) {
        alert('Please select a withdrawal method');
        return;
    }
    
    const formData = new FormData(this);
    
    // Add the selected method ID to form data
    formData.append('withdraw_method_id', selectedMethod.id);
    
    // Debug: Log form data
    console.log('Form data being sent:');
    for (let [key, value] of formData.entries()) {
        console.log(key + ': ' + value);
    }
    
    const submitBtn = document.querySelector('.btn-withdraw');
    const originalText = submitBtn.innerHTML;
    
    // Show loading state
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i><span>Processing...</span>';
    submitBtn.disabled = true;
    
    fetch('<?php echo e(route("user.withdraw.new.store")); ?>', {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert(data.message);
            window.location.href = '<?php echo e(route("user.withdraw.new.history")); ?>';
        } else {
            alert(data.message || 'Error submitting withdrawal request');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Error submitting withdrawal request: ' + error.message);
    })
    .finally(() => {
        submitBtn.innerHTML = originalText;
        submitBtn.disabled = false;
    });
});
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('frontend.shahdeveloper.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digitalx/blockwavetrade.com/resources/views/frontend/shahdeveloper/user/withdraw/new.blade.php ENDPATH**/ ?>