<?php $__env->startSection('title'); ?>
    <?php echo e(__(ucwords($type).' Method')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('deposit_content'); ?>
    <div class="container-fluid">
        <div class="row justify-content-center">
            <div class="col-xl-8">
                <div class="site-card">
                    <div class="site-card-body">
                        <form action="<?php echo e(route('admin.deposit.method.update',$method->id)); ?>" class="row" method="post"
                              enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="type" value="<?php echo e($type); ?>">
                            <div class="col-xl-12">
                                <div class="row">
                                    <div class="col-xl-3">
                                        <div class="site-input-groups">
                                            <label class="box-input-label" for=""><?php echo e(__('Upload Logo:')); ?></label>
                                            <div class="wrap-custom-file">
                                                <input
                                                    type="file"
                                                    name="logo"
                                                    id="schema-icon"
                                                    accept=".gif, .jpg, .png"
                                                />
                                                <label for="schema-icon" class="file-ok"
                                                       style="background-image: url(<?php echo e(asset($method->logo ?? $method->gateway->logo)); ?>)">
                                                    <img
                                                        class="upload-icon"
                                                        src="<?php echo e(asset('global/materials/upload.svg')); ?>"
                                                        alt=""
                                                    />
                                                    <span><?php echo e(__('Update Logo')); ?></span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <?php if($type == 'auto'): ?>
                                <div class="col-xl-6">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for=""><?php echo e(__('Automatic Gateway:')); ?></label>
                                        <select name="gateway_id"
                                                class="form-select"
                                                id="gateway-select">
                                            <?php $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option data-currencies="<?php echo e($gateway->supported_currencies); ?>"
                                                        data-gatewayCode="<?php echo e($gateway->gateway_code); ?>"
                                                        value="<?php echo e($gateway->id); ?>" <?php if($method->gateway_id == $gateway->id): echo 'selected'; endif; ?>> <?php echo e($gateway->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-xl-6">
                                    <div class="site-input-groups">
                                        <label class="box-input-label"
                                               for=""><?php echo e(__('Gateway Supported Currency:')); ?></label>
                                        <select name="currency" class="form-select" id="currency">
                                            <?php $__currentLoopData = json_decode($supported_currencies); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option
                                                    value="<?php echo e($currency); ?>" <?php if($currency == $method->currency ): echo 'selected'; endif; ?>><?php echo e($currency); ?> </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <div class="col-xl-6">
                                <div class="site-input-groups">
                                    <label class="box-input-label" for=""><?php echo e(__('Name:')); ?></label>
                                    <input
                                        type="text"
                                        class="box-input"
                                        name="name"
                                        value="<?php echo e($method->name); ?>"
                                    />
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="site-input-groups">
                                    <label class="box-input-label" for=""><?php echo e(__('Code Name')); ?></label>
                                    <input
                                        type="text"
                                        class="box-input"
                                        disabled
                                        value="<?php echo e($method->gateway_code); ?>"
                                    />
                                </div>
                            </div>
                            <?php if($type == 'manual'): ?>
                                <div class="col-xl-6">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for=""><?php echo e(__('Currency:')); ?></label>
                                        <input
                                            type="text"
                                            class="box-input"
                                            name="currency"
                                            value="<?php echo e($method->currency); ?>"
                                            id="currency"
                                        />
                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="col-xl-6">
                                <div class="site-input-groups">
                                    <label class="box-input-label" for=""><?php echo e(__('Currency Symbol:')); ?></label>
                                    <input
                                        type="text"
                                        class="box-input"
                                        value="<?php echo e($method->currency_symbol); ?>"
                                        name="currency_symbol"
                                    />
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="site-input-groups row">
                                    <div class="col-xl-12">
                                        <label class="box-input-label" for=""><?php echo e(__('Conversion Rate:')); ?></label>
                                        <div class="input-group joint-input">
                                            <span
                                                class="input-group-text"><?php echo e('1 '.' '.setting('site_currency', 'global'). ' ='); ?> </span>
                                            <input type="text" name="rate" class="form-control"
                                                   value="<?php echo e($method->rate); ?>"/>


                                            <span class="input-group-text"
                                                  id="currency-selected"><?php echo e(is_custom_rate($method->gateway?->gateway_code) ?? $method->currency); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="site-input-groups position-relative">
                                    <label class="box-input-label" for=""><?php echo e(__('Charges:')); ?></label>
                                    <div class="position-relative">
                                        <input type="text" class="box-input"
                                               oninput="this.value = validateDouble(this.value)" name="charge"
                                               value="<?php echo e($method->charge); ?>"/>
                                        <div class="prcntcurr">
                                            <select name="charge_type" class="form-select">
                                                <option value="percentage"
                                                        <?php if($method->charge_type == 'percentage'): ?> selected <?php endif; ?>><?php echo e(__('%')); ?></option>
                                                <option value="fixed"
                                                        <?php if($method->charge_type == 'fixed'): ?> selected <?php endif; ?>><?php echo e($currencySymbol); ?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="site-input-groups">
                                    <label class="box-input-label" for=""><?php echo e(__('Minimum Deposit:')); ?></label>
                                    <div class="input-group joint-input">
                                        <input type="text" name="minimum_deposit" class="form-control"
                                               value="<?php echo e($method->minimum_deposit); ?>"/>
                                        <span class="input-group-text"><?php echo e(setting('site_currency', 'global')); ?></span>
                                    </div>

                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="site-input-groups">
                                    <label class="box-input-label" for=""><?php echo e(__('Maximum Deposit:')); ?></label>
                                    <div class="input-group joint-input">
                                        <input type="text" name="maximum_deposit" class="form-control"
                                               value="<?php echo e($method->maximum_deposit); ?>"/>
                                        <span class="input-group-text"><?php echo e(setting('site_currency', 'global')); ?></span>
                                    </div>
                                </div>
                            </div>

                            <?php if($type == 'manual'): ?>
                                <div class="col-xl-3">
                                    <a href="javascript:void(0)" id="generate"
                                       class="site-btn-xs primary-btn mb-3"><?php echo e(__('Add Field option')); ?></a>
                                </div>

                                <div class="addOptions">
                                    <?php $__currentLoopData = json_decode($method->field_options,true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="mb-4">
                                            <div class="option-remove-row row">
                                                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                                                    <div class="site-input-groups">
                                                        <input name="field_options[<?php echo e($key); ?>][name]" class="box-input"
                                                               type="text" value="<?php echo e($value['name']); ?>" required
                                                               placeholder="Field Name">
                                                    </div>
                                                </div>

                                                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                                                    <div class="site-input-groups">
                                                        <select name="field_options[<?php echo e($key); ?>][type]"
                                                                class="form-select form-select-lg mb-3">
                                                            <option value="text"
                                                                    <?php if($value['type'] == 'text'): ?> selected <?php endif; ?>>Input
                                                                Text
                                                            </option>
                                                            <option value="textarea"
                                                                    <?php if($value['type'] == 'textarea'): ?> selected <?php endif; ?>>
                                                                Textarea
                                                            </option>
                                                            <option value="file"
                                                                    <?php if($value['type'] == 'file'): ?> selected <?php endif; ?>>File
                                                                upload
                                                            </option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
                                                    <div class="site-input-groups mb-0">
                                                        <select name="field_options[<?php echo e($key); ?>][validation]"
                                                                class="form-select form-select-lg mb-1">
                                                            <option value="required"
                                                                    <?php if($value['validation'] == 'required'): ?> selected <?php endif; ?>>
                                                                Required
                                                            </option>
                                                            <option value="nullable"
                                                                    <?php if($value['validation'] == 'nullable'): ?> selected <?php endif; ?>>
                                                                Optional
                                                            </option>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-xl-1 col-lg-6 col-md-6 col-sm-6 col-12">
                                                    <button class="delete-option-row delete_desc" type="button">
                                                        <i class="fas fa-times"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>

                                <div class="col-xl-12">
                                    <div class="site-input-groups fw-normal">
                                        <label for="" class="box-input-label"><?php echo e(__('Payment Details:')); ?></label>
                                        <small class="form-text text-muted"><?php echo e(__('Configure payment details based on the method type')); ?></small>
                                    </div>
                                </div>

                                <!-- Payment Type Selection -->
                                <div class="col-xl-12">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for=""><?php echo e(__('Payment Type:')); ?> <span class="text-danger">*</span></label>
                                        <select class="form-select" name="payment_type" id="payment_type" required>
                                            <option value="">Select Payment Type</option>
                                            <option value="easypaisa" <?php echo e((json_decode($method->payment_details, true)['payment_type'] ?? '') == 'easypaisa' ? 'selected' : ''); ?>>EasyPaisa</option>
                                            <option value="jazzcash" <?php echo e((json_decode($method->payment_details, true)['payment_type'] ?? '') == 'jazzcash' ? 'selected' : ''); ?>>JazzCash</option>
                                            <option value="bank_transfer" <?php echo e((json_decode($method->payment_details, true)['payment_type'] ?? '') == 'bank_transfer' ? 'selected' : ''); ?>>Bank Transfer</option>
                                            <option value="crypto" <?php echo e((json_decode($method->payment_details, true)['payment_type'] ?? '') == 'crypto' ? 'selected' : ''); ?>>Cryptocurrency</option>
                                        </select>
                                        <small class="form-text text-muted"><?php echo e(__('Select the type of payment method')); ?></small>
                                    </div>
                                </div>

                                <!-- EasyPaisa Fields -->
                                <div id="easypaisa_fields" class="payment-type-fields" style="display: none;">
                                    <div class="col-xl-6">
                                        <div class="site-input-groups">
                                            <label class="box-input-label" for=""><?php echo e(__('EasyPaisa Account Number:')); ?> <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="easypaisa_account" value="<?php echo e(old('easypaisa_account', json_decode($method->payment_details, true)['easypaisa_account'] ?? '')); ?>" placeholder="Enter EasyPaisa account number">
                                            <small class="form-text text-muted"><?php echo e(__('EasyPaisa account number for deposits')); ?></small>
                                        </div>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="site-input-groups">
                                            <label class="box-input-label" for=""><?php echo e(__('Account Holder Name:')); ?> <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="account_holder_name" value="<?php echo e(old('account_holder_name', json_decode($method->payment_details, true)['account_holder_name'] ?? '')); ?>" placeholder="Enter account holder name">
                                            <small class="form-text text-muted"><?php echo e(__('Name of the account holder')); ?></small>
                                        </div>
                                    </div>
                                </div>

                                <!-- JazzCash Fields -->
                                <div id="jazzcash_fields" class="payment-type-fields" style="display: none;">
                                    <div class="col-xl-6">
                                        <div class="site-input-groups">
                                            <label class="box-input-label" for=""><?php echo e(__('JazzCash Account Number:')); ?> <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="jazzcash_account" value="<?php echo e(old('jazzcash_account', json_decode($method->payment_details, true)['jazzcash_account'] ?? '')); ?>" placeholder="Enter JazzCash account number">
                                            <small class="form-text text-muted"><?php echo e(__('JazzCash account number for deposits')); ?></small>
                                        </div>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="site-input-groups">
                                            <label class="box-input-label" for=""><?php echo e(__('Account Holder Name:')); ?> <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="account_holder_name" value="<?php echo e(old('account_holder_name', json_decode($method->payment_details, true)['account_holder_name'] ?? '')); ?>" placeholder="Enter account holder name">
                                            <small class="form-text text-muted"><?php echo e(__('Name of the account holder')); ?></small>
                                        </div>
                                    </div>
                                </div>

                                <!-- Bank Transfer Fields -->
                                <div id="bank_transfer_fields" class="payment-type-fields" style="display: none;">
                                    <div class="col-xl-6">
                                        <div class="site-input-groups">
                                            <label class="box-input-label" for=""><?php echo e(__('Account Number:')); ?> <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="account_number" value="<?php echo e(old('account_number', json_decode($method->payment_details, true)['account_number'] ?? '')); ?>" placeholder="Enter bank account number">
                                            <small class="form-text text-muted"><?php echo e(__('Bank account number for deposits')); ?></small>
                                        </div>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="site-input-groups">
                                            <label class="box-input-label" for=""><?php echo e(__('Account Holder Name:')); ?> <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="account_holder_name" value="<?php echo e(old('account_holder_name', json_decode($method->payment_details, true)['account_holder_name'] ?? '')); ?>" placeholder="Enter account holder name">
                                            <small class="form-text text-muted"><?php echo e(__('Name of the account holder')); ?></small>
                                        </div>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="site-input-groups">
                                            <label class="box-input-label" for=""><?php echo e(__('Bank Name:')); ?> <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="bank_name" value="<?php echo e(old('bank_name', json_decode($method->payment_details, true)['bank_name'] ?? '')); ?>" placeholder="Enter bank name">
                                            <small class="form-text text-muted"><?php echo e(__('Name of the bank')); ?></small>
                                        </div>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="site-input-groups">
                                            <label class="box-input-label" for=""><?php echo e(__('Branch Code:')); ?></label>
                                            <input type="text" class="form-control" name="branch_code" value="<?php echo e(old('branch_code', json_decode($method->payment_details, true)['branch_code'] ?? '')); ?>" placeholder="Enter branch code">
                                            <small class="form-text text-muted"><?php echo e(__('Bank branch code (optional)')); ?></small>
                                        </div>
                                    </div>
                                </div>

                                <!-- Crypto Fields -->
                                <div id="crypto_fields" class="payment-type-fields" style="display: none;">
                                    <div class="col-xl-6">
                                        <div class="site-input-groups">
                                            <label class="box-input-label" for=""><?php echo e(__('Wallet Address:')); ?> <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="wallet_address" value="<?php echo e(old('wallet_address', json_decode($method->payment_details, true)['wallet_address'] ?? '')); ?>" placeholder="Enter wallet address">
                                            <small class="form-text text-muted"><?php echo e(__('Cryptocurrency wallet address')); ?></small>
                                        </div>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="site-input-groups">
                                            <label class="box-input-label" for=""><?php echo e(__('Cryptocurrency Type:')); ?> <span class="text-danger">*</span></label>
                                            <select class="form-select" name="crypto_type">
                                                <option value="">Select Cryptocurrency</option>
                                                <option value="bitcoin" <?php echo e((json_decode($method->payment_details, true)['crypto_type'] ?? '') == 'bitcoin' ? 'selected' : ''); ?>>Bitcoin (BTC)</option>
                                                <option value="ethereum" <?php echo e((json_decode($method->payment_details, true)['crypto_type'] ?? '') == 'ethereum' ? 'selected' : ''); ?>>Ethereum (ETH)</option>
                                                <option value="usdt" <?php echo e((json_decode($method->payment_details, true)['crypto_type'] ?? '') == 'usdt' ? 'selected' : ''); ?>>Tether (USDT)</option>
                                                <option value="usdc" <?php echo e((json_decode($method->payment_details, true)['crypto_type'] ?? '') == 'usdc' ? 'selected' : ''); ?>>USD Coin (USDC)</option>
                                            </select>
                                            <small class="form-text text-muted"><?php echo e(__('Type of cryptocurrency')); ?></small>
                                        </div>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="site-input-groups">
                                            <label class="box-input-label" for=""><?php echo e(__('Network:')); ?></label>
                                            <select class="form-select" name="network">
                                                <option value="">Select Network</option>
                                                <option value="mainnet" <?php echo e((json_decode($method->payment_details, true)['network'] ?? '') == 'mainnet' ? 'selected' : ''); ?>>Mainnet</option>
                                                <option value="bep20" <?php echo e((json_decode($method->payment_details, true)['network'] ?? '') == 'bep20' ? 'selected' : ''); ?>>BEP20 (BSC)</option>
                                                <option value="erc20" <?php echo e((json_decode($method->payment_details, true)['network'] ?? '') == 'erc20' ? 'selected' : ''); ?>>ERC20 (Ethereum)</option>
                                                <option value="trc20" <?php echo e((json_decode($method->payment_details, true)['network'] ?? '') == 'trc20' ? 'selected' : ''); ?>>TRC20 (TRON)</option>
                                            </select>
                                            <small class="form-text text-muted"><?php echo e(__('Blockchain network')); ?></small>
                                        </div>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="site-input-groups">
                                            <label class="box-input-label" for=""><?php echo e(__('QR Code URL:')); ?></label>
                                            <input type="url" class="form-control" name="qr_code" value="<?php echo e(old('qr_code', json_decode($method->payment_details, true)['qr_code'] ?? '')); ?>" placeholder="Enter QR code image URL">
                                            <small class="form-text text-muted"><?php echo e(__('Optional: QR code for easy scanning')); ?></small>
                                        </div>
                                    </div>
                                </div>

                                <!-- Common Fields -->
                                <div class="col-xl-12">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for=""><?php echo e(__('Payment Instructions:')); ?></label>
                                        <textarea class="form-control" name="payment_instructions" rows="3" placeholder="Enter payment instructions for users..."><?php echo e(old('payment_instructions', json_decode($method->payment_details, true)['payment_instructions'] ?? '')); ?></textarea>
                                        <small class="form-text text-muted"><?php echo e(__('Instructions that will be shown to users')); ?></small>
                                    </div>
                                </div>
                                
                                <div class="col-xl-12">
                                    <div class="site-input-groups">
                                        <label class="box-input-label" for=""><?php echo e(__('Raw Payment Details (JSON):')); ?></label>
                                        <textarea class="form-control" name="payment_details" rows="4" placeholder='{"payment_type": "easypaisa", "easypaisa_account": "1234567890", "account_holder_name": "John Doe", "payment_instructions": "instructions"}' readonly><?php echo e(old('payment_details', $method->payment_details)); ?></textarea>
                                        <small class="form-text text-muted"><?php echo e(__('This JSON is automatically generated from the fields above')); ?></small>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <div class="col-xl-6">
                                <div class="site-input-groups">
                                    <label class="box-input-label" for=""><?php echo e(__('Status:')); ?></label>
                                    <div class="switch-field same-type">
                                        <input
                                            type="radio"
                                            id="radio-five"
                                            name="status"
                                            value="1"
                                            <?php if($method->status): ?> checked <?php endif; ?>
                                        />
                                        <label for="radio-five"><?php echo e(__('Active')); ?></label>
                                        <input
                                            type="radio"
                                            id="radio-six"
                                            name="status"
                                            value="0"
                                            <?php if(!$method->status): ?> checked <?php endif; ?>
                                        />
                                        <label for="radio-six"><?php echo e(__('Deactivate')); ?></label>
                                    </div>
                                </div>
                            </div>

                            <div class="col-xl-12">
                                <button type="submit" class="site-btn primary-btn w-100">
                                    <?php echo e(__('Save Changes')); ?>

                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        'use strict';

        var currency = <?php echo json_encode(is_custom_rate($method->gateway?->gateway_code), 15, 512) ?>;

        $("#currency").on('change', function () {
            if (currency === null) {
                $('#currency-selected').text(this.value);
            }
        });

        if (null != <?php echo json_encode($method->field_options, 15, 512) ?>) {
            var i = Object.keys(JSON.parse(<?php echo json_encode($method->field_options, 15, 512) ?>)).length;
            $("#generate").on('click', function () {
                ++i;
                var form = `<div class="mb-4">
              <div class="option-remove-row row">
                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                  <div class="site-input-groups">
                    <input name="field_options[` + i + `][name]" class="box-input" type="text" value="" required placeholder="Field Name">
                  </div>
                </div>

                <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
                  <div class="site-input-groups">
                    <select name="field_options[` + i + `][type]" class="form-select form-select-lg mb-3">
                        <option value="text">Input Text</option>
                        <option value="textarea">Textarea</option>
                        <option value="file">File upload</option>
                    </select>
                  </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12">
                  <div class="site-input-groups mb-0">
                    <select name="field_options[` + i + `][validation]" class="form-select form-select-lg mb-1">
                        <option value="required">Required</option>
                        <option value="nullable">Optional</option>
                    </select>
                  </div>
                </div>

                <div class="col-xl-1 col-lg-6 col-md-6 col-sm-6 col-12">
                  <button class="delete-option-row delete_desc" type="button">
                    <i class="fas fa-times"></i>
                  </button>
                </div>
                </div>
              </div>`;
                $('.addOptions').append(form)
            });

            $(document).on('click', '.delete_desc', function () {
                $(this).closest('.option-remove-row').parent().remove();
            });
        }

        $('#gateway-select').on('change', function () {
            var id = $(this).val();
            var url = '<?php echo e(route('admin.gateway.supported.currency',':id')); ?>';
            url = url.replace(':id', id);
            $.get(url, function (data) {
                $('#currency').html(data.view);
                $('#currency-selected').text(data.pay_currency);
                currency = data.pay_currency
            })
        })

        if (currency !== null) {
            $('#currency-selected').text(currency);
        }

        // Payment type change handler
        $('#payment_type').on('change', function() {
            const paymentType = $(this).val();
            
            // Hide all payment type fields
            $('.payment-type-fields').hide();
            
            // Show relevant fields based on selection
            if (paymentType) {
                $(`#${paymentType}_fields`).show();
            }
            
            updatePaymentDetails();
        });

        // Auto-generate JSON for payment details
        function updatePaymentDetails() {
            const paymentType = $('#payment_type').val();
            const paymentInstructions = $('textarea[name="payment_instructions"]').val();
            
            let paymentDetails = {
                payment_type: paymentType,
                payment_instructions: paymentInstructions
            };
            
            // Add fields based on payment type
            if (paymentType === 'easypaisa') {
                paymentDetails.easypaisa_account = $('input[name="easypaisa_account"]').val();
                paymentDetails.account_holder_name = $('input[name="account_holder_name"]').val();
            } else if (paymentType === 'jazzcash') {
                paymentDetails.jazzcash_account = $('input[name="jazzcash_account"]').val();
                paymentDetails.account_holder_name = $('input[name="account_holder_name"]').val();
            } else if (paymentType === 'bank_transfer') {
                paymentDetails.account_number = $('input[name="account_number"]').val();
                paymentDetails.account_holder_name = $('input[name="account_holder_name"]').val();
                paymentDetails.bank_name = $('input[name="bank_name"]').val();
                paymentDetails.branch_code = $('input[name="branch_code"]').val();
            } else if (paymentType === 'crypto') {
                paymentDetails.wallet_address = $('input[name="wallet_address"]').val();
                paymentDetails.crypto_type = $('select[name="crypto_type"]').val();
                paymentDetails.network = $('select[name="network"]').val();
                paymentDetails.qr_code = $('input[name="qr_code"]').val();
            }
            
            $('textarea[name="payment_details"]').val(JSON.stringify(paymentDetails, null, 2));
        }

        // Auto-generate QR code when wallet address changes
        $('input[name="wallet_address"]').on('input', function() {
            const walletAddress = $(this).val();
            const qrCodeInput = $('input[name="qr_code"]');
            
            if (walletAddress && !qrCodeInput.val()) {
                qrCodeInput.val(`https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=${encodeURIComponent(walletAddress)}`);
            }
            
            updatePaymentDetails();
        });

        // Event listeners for all payment detail fields
        $('input[name="easypaisa_account"], input[name="jazzcash_account"], input[name="account_number"], input[name="account_holder_name"], input[name="bank_name"], input[name="branch_code"], input[name="wallet_address"], input[name="qr_code"], select[name="crypto_type"], select[name="network"], textarea[name="payment_instructions"]').on('input change', updatePaymentDetails);
        
        // Initial setup
        const initialPaymentType = $('#payment_type').val();
        if (initialPaymentType) {
            $(`#${initialPaymentType}_fields`).show();
        }
        updatePaymentDetails();

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.deposit.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digitalx/blockwavetrade.com/resources/views/backend/deposit/edit_method.blade.php ENDPATH**/ ?>