<?php $__env->startSection('title'); ?>
    <?php echo e(__('Create New Ticket')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="desktop-screen-show">
    <div class="row">
        <div class="col-xl-8">
            <div class="site-card">
                <div class="site-card-header">
                    <h3 class="title"><?php echo e(__('Create New Ticket')); ?></h3>
                    <a href="<?php echo e(route('user.ticket.index')); ?>" class="site-btn">
                        <i icon-name="arrow-left"></i><?php echo e(__('Back to Tickets')); ?>

                    </a>
                </div>
                <div class="site-card-body">
                    <form action="<?php echo e(route('user.ticket.store')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-xl-12 col-md-12 col-sm-12">
                                <div class="site-input-groups">
                                    <label for="title" class="box-input-label"><?php echo e(__('Subject')); ?> <span class="text-danger">*</span></label>
                                    <div class="box-input">
                                        <input type="text" 
                                               class="box-input-field" 
                                               id="title" 
                                               name="title" 
                                               placeholder="<?php echo e(__('Enter ticket subject')); ?>"
                                               value="<?php echo e(old('title')); ?>"
                                               required>
                                    </div>
                                    <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            
                            <div class="col-xl-12 col-md-12 col-sm-12">
                                <div class="site-input-groups">
                                    <label for="message" class="box-input-label"><?php echo e(__('Message')); ?> <span class="text-danger">*</span></label>
                                    <div class="box-input">
                                        <textarea class="box-input-field" 
                                                  id="message" 
                                                  name="message" 
                                                  rows="6" 
                                                  placeholder="<?php echo e(__('Describe your issue in detail')); ?>"
                                                  required><?php echo e(old('message')); ?></textarea>
                                    </div>
                                    <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            
                            <div class="col-xl-12 col-md-12 col-sm-12">
                                <div class="site-input-groups">
                                    <label for="attach" class="box-input-label"><?php echo e(__('Attachment')); ?> (<?php echo e(__('Optional')); ?>)</label>
                                    <div class="box-input">
                                        <input type="file" 
                                               class="box-input-field" 
                                               id="attach" 
                                               name="attach" 
                                               accept="image/*,.pdf,.doc,.docx">
                                        <small class="text-muted"><?php echo e(__('Supported formats: JPG, PNG, PDF, DOC, DOCX')); ?></small>
                                    </div>
                                    <?php $__errorArgs = ['attach'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            
                            <div class="col-xl-12 col-md-12 col-sm-12">
                                <div class="site-input-groups">
                                    <button type="submit" class="site-btn">
                                        <i icon-name="send"></i><?php echo e(__('Create Ticket')); ?>

                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        <div class="col-xl-4">
            <div class="site-card">
                <div class="site-card-header">
                    <h3 class="title"><?php echo e(__('Support Guidelines')); ?></h3>
                </div>
                <div class="site-card-body">
                    <div class="support-guidelines">
                        <div class="guideline-item">
                            <i icon-name="info" class="guideline-icon"></i>
                            <div class="guideline-content">
                                <h6><?php echo e(__('Be Specific')); ?></h6>
                                <p><?php echo e(__('Provide detailed information about your issue for faster resolution.')); ?></p>
                            </div>
                        </div>
                        
                        <div class="guideline-item">
                            <i icon-name="clock" class="guideline-icon"></i>
                            <div class="guideline-content">
                                <h6><?php echo e(__('Response Time')); ?></h6>
                                <p><?php echo e(__('We typically respond within 24 hours during business days.')); ?></p>
                            </div>
                        </div>
                        
                        <div class="guideline-item">
                            <i icon-name="file-text" class="guideline-icon"></i>
                            <div class="guideline-content">
                                <h6><?php echo e(__('Attachments')); ?></h6>
                                <p><?php echo e(__('Include relevant screenshots or documents to help us understand your issue.')); ?></p>
                            </div>
                        </div>
                        
                        <div class="guideline-item">
                            <i icon-name="mail" class="guideline-icon"></i>
                            <div class="guideline-content">
                                <h6><?php echo e(__('Email Notifications')); ?></h6>
                                <p><?php echo e(__('You will receive email updates when we respond to your ticket.')); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('mobile-screen-show'); ?>
<div class="mobile-screen-show">
    <div class="row">
        <div class="col-xl-12">
            <div class="site-card">
                <div class="site-card-header">
                    <h3 class="title"><?php echo e(__('Create New Ticket')); ?></h3>
                    <a href="<?php echo e(route('user.ticket.index')); ?>" class="site-btn">
                        <i icon-name="arrow-left"></i><?php echo e(__('Back')); ?>

                    </a>
                </div>
                <div class="site-card-body">
                    <form action="<?php echo e(route('user.ticket.store')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="site-input-groups">
                            <label for="title" class="box-input-label"><?php echo e(__('Subject')); ?> <span class="text-danger">*</span></label>
                            <div class="box-input">
                                <input type="text" 
                                       class="box-input-field" 
                                       id="title" 
                                       name="title" 
                                       placeholder="<?php echo e(__('Enter ticket subject')); ?>"
                                       value="<?php echo e(old('title')); ?>"
                                       required>
                            </div>
                            <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div class="site-input-groups">
                            <label for="message" class="box-input-label"><?php echo e(__('Message')); ?> <span class="text-danger">*</span></label>
                            <div class="box-input">
                                <textarea class="box-input-field" 
                                          id="message" 
                                          name="message" 
                                          rows="6" 
                                          placeholder="<?php echo e(__('Describe your issue in detail')); ?>"
                                          required><?php echo e(old('message')); ?></textarea>
                            </div>
                            <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div class="site-input-groups">
                            <label for="attach" class="box-input-label"><?php echo e(__('Attachment')); ?> (<?php echo e(__('Optional')); ?>)</label>
                            <div class="box-input">
                                <input type="file" 
                                       class="box-input-field" 
                                       id="attach" 
                                       name="attach" 
                                       accept="image/*,.pdf,.doc,.docx">
                                <small class="text-muted"><?php echo e(__('Supported formats: JPG, PNG, PDF, DOC, DOCX')); ?></small>
                            </div>
                            <?php $__errorArgs = ['attach'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div class="site-input-groups">
                            <button type="submit" class="site-btn w-100">
                                <i icon-name="send"></i><?php echo e(__('Create Ticket')); ?>

                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
<style>
.site-card {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border-radius: 15px;
    border: 1px solid rgba(255, 255, 255, 0.1);
    margin-bottom: 20px;
}

.site-card-header {
    padding: 20px;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.site-card-header .title {
    color: #fff;
    margin: 0;
    font-weight: 600;
}

.site-card-body {
    padding: 20px;
}

.site-btn {
    background: linear-gradient(135deg, #00ff88, #00cc6a);
    border: none;
    padding: 12px 24px;
    border-radius: 8px;
    color: #000;
    font-weight: 600;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    transition: all 0.3s ease;
}

.site-btn:hover {
    background: linear-gradient(135deg, #00cc6a, #00ff88);
    color: #000;
    text-decoration: none;
    transform: translateY(-2px);
}

.site-input-groups {
    margin-bottom: 20px;
}

.box-input-label {
    color: #fff;
    font-weight: 600;
    margin-bottom: 8px;
    display: block;
}

.box-input-field {
    width: 100%;
    padding: 12px 16px;
    border: 1px solid rgba(255, 255, 255, 0.2);
    border-radius: 8px;
    background: rgba(255, 255, 255, 0.05);
    color: #fff;
    font-size: 14px;
    transition: all 0.3s ease;
}

.box-input-field:focus {
    outline: none;
    border-color: #00ff88;
    background: rgba(255, 255, 255, 0.1);
}

.box-input-field::placeholder {
    color: #ccc;
}

.text-danger {
    color: #ff6b6b !important;
    font-size: 12px;
    margin-top: 5px;
    display: block;
}

.text-muted {
    color: #ccc;
    font-size: 12px;
    margin-top: 5px;
    display: block;
}

.support-guidelines {
    padding: 0;
}

.guideline-item {
    display: flex;
    align-items: flex-start;
    margin-bottom: 20px;
    padding-bottom: 20px;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.guideline-item:last-child {
    margin-bottom: 0;
    padding-bottom: 0;
    border-bottom: none;
}

.guideline-icon {
    width: 20px;
    height: 20px;
    color: #00ff88;
    margin-right: 15px;
    margin-top: 2px;
    flex-shrink: 0;
}

.guideline-content h6 {
    margin-bottom: 5px;
    color: #fff;
    font-weight: 600;
}

.guideline-content p {
    margin: 0;
    color: #ccc;
    font-size: 14px;
    line-height: 1.5;
}

/* Mobile Responsive */
@media (max-width: 768px) {
    .site-card-header {
        flex-direction: column;
        gap: 15px;
        text-align: center;
    }
    
    .site-card-header .title {
        font-size: 18px;
    }
    
    .site-btn {
        padding: 10px 20px;
        font-size: 14px;
    }
    
    .w-100 {
        width: 100% !important;
    }
    
    .box-input-field {
        font-size: 16px; /* Prevent zoom on iOS */
    }
    
    .support-guidelines {
        display: none; /* Hide guidelines on mobile */
    }
}
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('frontend::layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digitalx/blockwavetrade.com/resources/views/frontend/ticket/new.blade.php ENDPATH**/ ?>