<?php $__env->startSection('title'); ?>
    <?php echo e(__('Deposit Logs')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="deposit-logs-container">
    <!-- Header Section -->
    <div class="page-header">
        <div class="header-content">
            <h1 class="page-title"><?php echo e(__('Deposit Logs')); ?></h1>
            <p class="page-subtitle"><?php echo e(__('Track all your deposit transactions')); ?></p>
        </div>
        <?php if(session('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>
    </div>

    <!-- Search and Filter Section -->
    <div class="search-section">
        <form action="<?php echo e(route('user.deposit.log')); ?>" method="get" class="search-form">
            <div class="search-inputs">
                <div class="input-group">
                    <input type="text" id="search" placeholder="Search transactions..." 
                           value="<?php echo e(request('query')); ?>" name="query" class="search-input">
                    <i class="fas fa-search search-icon"></i>
                </div>
                <div class="input-group">
                    <input type="date" name="date" value="<?php echo e(request()->get('date')); ?>" class="date-input">
                </div>
                <button type="submit" class="search-btn">
                    <i class="fas fa-search"></i>
                    <span><?php echo e(__('Search')); ?></span>
                </button>
            </div>
        </form>
    </div>

    <!-- Desktop Table View -->
    <div class="desktop-table-container">
        <div class="table-card">
            <div class="table-header">
                <h3><?php echo e(__('All Deposit Transactions')); ?></h3>
            </div>
            <div class="table-responsive">
                <table class="deposits-table">
                    <thead>
                        <tr>
                            <th><?php echo e(__('Date')); ?></th>
                            <th><?php echo e(__('Description')); ?></th>
                            <th><?php echo e(__('Transaction ID')); ?></th>
                            <th><?php echo e(__('Amount')); ?></th>
                            <th><?php echo e(__('Fee')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('Method')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $raw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="date-cell">
                                    <div class="date-info">
                                        <span class="date"><?php echo e(optional($raw->created_at)->format('M d, Y')); ?></span>
                                        <span class="time"><?php echo e(optional($raw->created_at)->format('H:i')); ?></span>
                                    </div>
                                </td>
                                <td class="description-cell">
                                    <strong><?php echo e($raw->description); ?></strong>
                                </td>
                                <td class="txn-cell">
                                    <code class="txn-id"><?php echo e($raw->tnx); ?></code>
                                </td>
                                <td class="amount-cell">
                                    <span class="amount positive">+<?php echo e($raw->amount.' '.$currency); ?></span>
                                </td>
                                <td class="fee-cell">
                                    <span class="fee">-<?php echo e($raw->charge); ?> <?php echo e($currency); ?></span>
                                </td>
                                <td class="status-cell">
                                    <?php switch($raw->status->value):
                                        case ('pending'): ?>
                                            <span class="status-badge pending"><?php echo e(__('Pending')); ?></span>
                                            <?php break; ?>
                                        <?php case ('success'): ?>
                                            <span class="status-badge success"><?php echo e(__('Success')); ?></span>
                                            <?php break; ?>
                                        <?php case ('failed'): ?>
                                            <span class="status-badge failed"><?php echo e(__('Failed')); ?></span>
                                            <?php break; ?>
                                    <?php endswitch; ?>
                                </td>
                                <td class="method-cell">
                                    <span class="method"><?php echo e(ucfirst($raw->method)); ?></span>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Mobile Card View -->
    <div class="mobile-cards-container">
        <?php $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $raw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="deposit-card">
                <div class="card-header">
                    <div class="transaction-info">
                        <h4 class="description"><?php echo e($raw->description); ?></h4>
                        <p class="txn-id"><?php echo e($raw->tnx); ?></p>
                    </div>
                    <div class="amount-section">
                        <span class="amount positive">+<?php echo e($raw->amount.' '.$currency); ?></span>
                        <?php switch($raw->status->value):
                            case ('pending'): ?>
                                <span class="status-badge pending"><?php echo e(__('Pending')); ?></span>
                                <?php break; ?>
                            <?php case ('success'): ?>
                                <span class="status-badge success"><?php echo e(__('Success')); ?></span>
                                <?php break; ?>
                            <?php case ('failed'): ?>
                                <span class="status-badge failed"><?php echo e(__('Failed')); ?></span>
                                <?php break; ?>
                        <?php endswitch; ?>
                    </div>
                </div>
                <div class="card-body">
                    <div class="info-row">
                        <span class="label"><?php echo e(__('Date')); ?>:</span>
                        <span class="value"><?php echo e(optional($raw->created_at)->format('M d, Y H:i')); ?></span>
                    </div>
                    <div class="info-row">
                        <span class="label"><?php echo e(__('Fee')); ?>:</span>
                        <span class="value fee">-<?php echo e($raw->charge); ?> <?php echo e($currency); ?></span>
                    </div>
                    <div class="info-row">
                        <span class="label"><?php echo e(__('Method')); ?>:</span>
                        <span class="value"><?php echo e(ucfirst($raw->method)); ?></span>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <!-- Pagination -->
    <div class="pagination-container">
        <?php echo e($deposits->links()); ?>

    </div>
</div>

<style>
.deposit-logs-container {
    padding: 20px;
    max-width: 1200px;
    margin: 0 auto;
}

.page-header {
    margin-bottom: 30px;
}

.page-title {
    font-size: 2rem;
    font-weight: 700;
    color: var(--text-primary);
    margin: 0 0 8px 0;
}

.page-subtitle {
    color: var(--text-secondary);
    margin: 0;
    font-size: 1rem;
}

.alert {
    padding: 12px 16px;
    border-radius: 8px;
    margin: 16px 0;
    border: 1px solid;
}

.alert-success {
    background: rgba(0, 255, 136, 0.1);
    color: #00ff88;
    border-color: rgba(0, 255, 136, 0.3);
}

.search-section {
    margin-bottom: 30px;
}

.search-form {
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 12px;
    padding: 20px;
    backdrop-filter: blur(10px);
}

.search-inputs {
    display: flex;
    gap: 12px;
    flex-wrap: wrap;
}

.input-group {
    flex: 1;
    min-width: 200px;
    position: relative;
}

.search-input, .date-input {
    width: 100%;
    padding: 12px 16px;
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 8px;
    color: var(--text-primary);
    font-size: 14px;
}

.search-input:focus, .date-input:focus {
    outline: none;
    border-color: #00ff88;
    box-shadow: 0 0 0 2px rgba(0, 255, 136, 0.2);
}

.search-icon {
    position: absolute;
    right: 12px;
    top: 50%;
    transform: translateY(-50%);
    color: var(--text-secondary);
}

.search-btn {
    padding: 12px 24px;
    background: linear-gradient(135deg, #00ff88, #00cc6a);
    border: none;
    border-radius: 8px;
    color: #000;
    font-weight: 600;
    cursor: pointer;
    display: flex;
    align-items: center;
    gap: 8px;
    transition: all 0.3s ease;
}

.search-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 255, 136, 0.3);
}

/* Desktop Table Styles */
.desktop-table-container {
    display: block;
}

.table-card {
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 12px;
    overflow: hidden;
    backdrop-filter: blur(10px);
}

.table-header {
    padding: 20px;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.table-header h3 {
    margin: 0;
    color: var(--text-primary);
    font-size: 1.25rem;
    font-weight: 600;
}

.table-responsive {
    overflow-x: auto;
}

.deposits-table {
    width: 100%;
    border-collapse: collapse;
}

.deposits-table th {
    padding: 16px 12px;
    text-align: left;
    color: var(--text-secondary);
    font-weight: 600;
    font-size: 14px;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    white-space: nowrap;
}

.deposits-table td {
    padding: 16px 12px;
    border-bottom: 1px solid rgba(255, 255, 255, 0.05);
    vertical-align: middle;
}

.date-info {
    display: flex;
    flex-direction: column;
    gap: 2px;
}

.date {
    font-weight: 600;
    color: var(--text-primary);
}

.time {
    font-size: 12px;
    color: var(--text-secondary);
}

.txn-id {
    background: rgba(255, 255, 255, 0.05);
    padding: 4px 8px;
    border-radius: 4px;
    font-family: monospace;
    font-size: 12px;
    color: var(--text-secondary);
}

.amount {
    font-weight: 700;
    font-size: 16px;
}

.amount.positive {
    color: #00ff88;
}

.fee {
    color: #ff6b6b;
    font-weight: 600;
}

.status-badge {
    padding: 4px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.status-badge.pending {
    background: rgba(255, 193, 7, 0.15);
    color: #ffc107;
    border: 1px solid rgba(255, 193, 7, 0.4);
}

.status-badge.success {
    background: rgba(0, 255, 136, 0.15);
    color: #00ff88;
    border: 1px solid rgba(0, 255, 136, 0.4);
}

.status-badge.failed {
    background: rgba(255, 107, 107, 0.15);
    color: #ff6b6b;
    border: 1px solid rgba(255, 107, 107, 0.4);
}

.method {
    color: var(--text-primary);
    font-weight: 600;
}

/* Mobile Card Styles */
.mobile-cards-container {
    display: none;
}

.deposit-card {
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 12px;
    margin-bottom: 16px;
    backdrop-filter: blur(10px);
    overflow: hidden;
}

.card-header {
    padding: 16px;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    gap: 12px;
}

.transaction-info {
    flex: 1;
}

.transaction-info .description {
    margin: 0 0 4px 0;
    font-size: 16px;
    font-weight: 600;
    color: var(--text-primary);
}

.transaction-info .txn-id {
    margin: 0;
    font-size: 12px;
    color: var(--text-secondary);
    font-family: monospace;
}

.amount-section {
    display: flex;
    flex-direction: column;
    align-items: flex-end;
    gap: 8px;
}

.card-body {
    padding: 16px;
}

.info-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 8px;
}

.info-row:last-child {
    margin-bottom: 0;
}

.info-row .label {
    color: var(--text-secondary);
    font-size: 14px;
}

.info-row .value {
    color: var(--text-primary);
    font-weight: 600;
    font-size: 14px;
}

.pagination-container {
    margin-top: 30px;
    display: flex;
    justify-content: center;
}

/* Responsive Design */
@media (max-width: 768px) {
    .deposit-logs-container {
        padding: 16px;
    }
    
    .page-title {
        font-size: 1.5rem;
    }
    
    .search-inputs {
        flex-direction: column;
    }
    
    .input-group {
        min-width: auto;
    }
    
    .search-btn {
        width: 100%;
        justify-content: center;
    }
    
    .desktop-table-container {
        display: none;
    }
    
    .mobile-cards-container {
        display: block;
    }
}

@media (max-width: 480px) {
    .deposit-logs-container {
        padding: 12px;
    }
    
    .card-header {
        flex-direction: column;
        align-items: stretch;
    }
    
    .amount-section {
        align-items: flex-start;
        margin-top: 12px;
    }
    
    .info-row {
        flex-direction: column;
        align-items: flex-start;
        gap: 4px;
    }
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.shahdeveloper.layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digitalx/blockwavetrade.com/app/Providers/../../resources/views/frontend/shahdeveloper/deposit/log.blade.php ENDPATH**/ ?>