<?php $__env->startSection('title'); ?>
    <?php echo e(__('Ticket Details')); ?> - <?php echo e($ticket->title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="desktop-screen-show">
    <div class="row">
        <div class="col-xl-12">
            <div class="site-card">
                <div class="site-card-header">
                    <div class="ticket-header-info">
                        <h3 class="title"><?php echo e($ticket->title); ?></h3>
                        <div class="ticket-meta">
                            <span class="ticket-id">#<?php echo e($ticket->uuid); ?></span>
                            <?php if($ticket->status == 'open'): ?>
                                <span class="site-badge success"><?php echo e(__('Open')); ?></span>
                            <?php elseif($ticket->status == 'closed'): ?>
                                <span class="site-badge warning"><?php echo e(__('Closed')); ?></span>
                            <?php else: ?>
                                <span class="site-badge pending"><?php echo e(ucfirst($ticket->status)); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="ticket-actions">
                        <a href="<?php echo e(route('user.ticket.index')); ?>" class="site-btn">
                            <i icon-name="arrow-left"></i><?php echo e(__('Back to Tickets')); ?>

                        </a>
                        <?php if($ticket->status == 'open'): ?>
                            <a href="<?php echo e(route('user.ticket.close', $ticket->uuid)); ?>" 
                               class="site-btn warning-btn"
                               onclick="return confirm('Are you sure you want to close this ticket?')">
                                <i icon-name="x-circle"></i><?php echo e(__('Close Ticket')); ?>

                            </a>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="site-card-body">
                    <!-- Ticket Details -->
                    <div class="ticket-details">
                        <div class="ticket-info-grid">
                            <div class="info-item">
                                <label><?php echo e(__('Created')); ?>:</label>
                                <span><?php echo e($ticket->created_at); ?></span>
                            </div>
                            <div class="info-item">
                                <label><?php echo e(__('Last Updated')); ?>:</label>
                                <span><?php echo e($ticket->updated_at->format('M d, Y H:i')); ?></span>
                            </div>
                            <div class="info-item">
                                <label><?php echo e(__('Priority')); ?>:</label>
                                <span class="priority-<?php echo e($ticket->priority ?? 'medium'); ?>">
                                    <?php echo e(ucfirst($ticket->priority ?? 'medium')); ?>

                                </span>
                            </div>
                        </div>
                    </div>

                    <!-- Messages Section -->
                    <div class="ticket-messages">
                        <h4 class="section-title"><?php echo e(__('Conversation')); ?></h4>
                        
                        <!-- Original Message -->
                        <div class="message-item user-message">
                            <div class="message-header">
                                <div class="message-author">
                                    <i icon-name="user" class="author-icon"></i>
                                    <span class="author-name"><?php echo e(__('You')); ?></span>
                                </div>
                                <div class="message-time"><?php echo e($ticket->created_at); ?></div>
                            </div>
                            <div class="message-content">
                                <p><?php echo e($ticket->message); ?></p>
                                <?php if($ticket->attach): ?>
                                    <div class="message-attachment">
                                        <i icon-name="paperclip"></i>
                                        <a href="<?php echo e(asset('storage/tickets/' . $ticket->attach)); ?>" target="_blank">
                                            <?php echo e($ticket->attach); ?>

                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Admin Replies -->
                        <?php if($ticket->messages && $ticket->messages->count() > 0): ?>
                            <?php $__currentLoopData = $ticket->messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reply): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="message-item admin-message">
                                    <div class="message-header">
                                        <div class="message-author">
                                            <i icon-name="shield-check" class="author-icon admin-icon"></i>
                                            <span class="author-name"><?php echo e(__('Admin')); ?></span>
                                        </div>
                                        <div class="message-time"><?php echo e($reply->created_at); ?></div>
                                    </div>
                                    <div class="message-content">
                                        <p><?php echo e($reply->message); ?></p>
                                        <?php if($reply->attach): ?>
                                            <div class="message-attachment">
                                                <i icon-name="paperclip"></i>
                                                <a href="<?php echo e(asset('storage/tickets/' . $reply->attach)); ?>" target="_blank">
                                                    <?php echo e($reply->attach); ?>

                                                </a>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <div class="no-replies">
                                <i icon-name="message-circle" class="no-replies-icon"></i>
                                <p><?php echo e(__('No admin replies yet. We will respond soon.')); ?></p>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Reply Form (Only if ticket is open) -->
                    <?php if($ticket->status == 'open'): ?>
                        <div class="reply-section">
                            <h4 class="section-title"><?php echo e(__('Reply to Ticket')); ?></h4>
                            <form action="<?php echo e(route('user.ticket.reply')); ?>" method="POST" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="ticket_id" value="<?php echo e($ticket->id); ?>">
                                
                                <div class="site-input-groups">
                                    <label for="reply_message" class="box-input-label"><?php echo e(__('Your Message')); ?> <span class="text-danger">*</span></label>
                                    <div class="box-input">
                                        <textarea class="box-input-field" 
                                                  id="reply_message" 
                                                  name="message" 
                                                  rows="4" 
                                                  placeholder="<?php echo e(__('Type your reply here...')); ?>"
                                                  required></textarea>
                                    </div>
                                    <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                
                                <div class="site-input-groups">
                                    <label for="reply_attach" class="box-input-label"><?php echo e(__('Attachment')); ?> (<?php echo e(__('Optional')); ?>)</label>
                                    <div class="box-input">
                                        <input type="file" 
                                               class="box-input-field" 
                                               id="reply_attach" 
                                               name="attach" 
                                               accept="image/*,.pdf,.doc,.docx">
                                        <small class="text-muted"><?php echo e(__('Supported formats: JPG, PNG, PDF, DOC, DOCX')); ?></small>
                                    </div>
                                    <?php $__errorArgs = ['attach'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                
                                <div class="site-input-groups">
                                    <button type="submit" class="site-btn">
                                        <i icon-name="send"></i><?php echo e(__('Send Reply')); ?>

                                    </button>
                                </div>
                            </form>
                        </div>
                    <?php else: ?>
                        <div class="ticket-closed-notice">
                            <i icon-name="lock"></i>
                            <p><?php echo e(__('This ticket is closed. You cannot reply to closed tickets.')); ?></p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('mobile-screen-show'); ?>
<div class="mobile-screen-show">
    <div class="row">
        <div class="col-xl-12">
            <div class="site-card">
                <div class="site-card-header">
                    <div class="ticket-header-info">
                        <h3 class="title"><?php echo e($ticket->title); ?></h3>
                        <div class="ticket-meta">
                            <span class="ticket-id">#<?php echo e($ticket->uuid); ?></span>
                            <?php if($ticket->status == 'open'): ?>
                                <span class="site-badge success"><?php echo e(__('Open')); ?></span>
                            <?php elseif($ticket->status == 'closed'): ?>
                                <span class="site-badge warning"><?php echo e(__('Closed')); ?></span>
                            <?php else: ?>
                                <span class="site-badge pending"><?php echo e(ucfirst($ticket->status)); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="site-card-body">
                    <!-- Mobile Messages -->
                    <div class="mobile-messages">
                        <!-- Original Message -->
                        <div class="mobile-message user-message">
                            <div class="message-header">
                                <span class="author-name"><?php echo e(__('You')); ?></span>
                                <span class="message-time"><?php echo e($ticket->created_at); ?></span>
                            </div>
                            <div class="message-content">
                                <p><?php echo e($ticket->message); ?></p>
                                <?php if($ticket->attach): ?>
                                    <div class="message-attachment">
                                        <i icon-name="paperclip"></i>
                                        <a href="<?php echo e(asset('storage/tickets/' . $ticket->attach)); ?>" target="_blank">
                                            <?php echo e($ticket->attach); ?>

                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Admin Replies -->
                        <?php if($ticket->messages && $ticket->messages->count() > 0): ?>
                            <?php $__currentLoopData = $ticket->messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reply): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="mobile-message admin-message">
                                    <div class="message-header">
                                        <span class="author-name"><?php echo e(__('Admin')); ?></span>
                                        <span class="message-time"><?php echo e($reply->created_at); ?></span>
                                    </div>
                                    <div class="message-content">
                                        <p><?php echo e($reply->message); ?></p>
                                        <?php if($reply->attach): ?>
                                            <div class="message-attachment">
                                                <i icon-name="paperclip"></i>
                                                <a href="<?php echo e(asset('storage/tickets/' . $reply->attach)); ?>" target="_blank">
                                                    <?php echo e($reply->attach); ?>

                                                </a>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <div class="no-replies">
                                <i icon-name="message-circle"></i>
                                <p><?php echo e(__('No admin replies yet.')); ?></p>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Mobile Reply Form -->
                    <?php if($ticket->status == 'open'): ?>
                        <div class="mobile-reply-form">
                            <h4><?php echo e(__('Reply')); ?></h4>
                            <form action="<?php echo e(route('user.ticket.reply')); ?>" method="POST" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="ticket_id" value="<?php echo e($ticket->id); ?>">
                                
                                <div class="form-group">
                                    <textarea class="form-control" 
                                              name="message" 
                                              rows="3" 
                                              placeholder="<?php echo e(__('Type your reply...')); ?>"
                                              required></textarea>
                                </div>
                                
                                <div class="form-group">
                                    <input type="file" 
                                           class="form-control" 
                                           name="attach" 
                                           accept="image/*,.pdf,.doc,.docx">
                                </div>
                                
                                <button type="submit" class="btn btn-primary w-100">
                                    <i icon-name="send"></i><?php echo e(__('Send')); ?>

                                </button>
                            </form>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
<style>
/* Desktop Styles */
.site-card {
    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(20px);
    border-radius: 15px;
    border: 1px solid rgba(255, 255, 255, 0.1);
    margin-bottom: 20px;
}

.site-card-header {
    padding: 20px;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    gap: 20px;
}

.ticket-header-info {
    flex: 1;
}

.ticket-header-info .title {
    color: #fff;
    margin: 0 0 10px 0;
    font-weight: 600;
    font-size: 20px;
}

.ticket-meta {
    display: flex;
    align-items: center;
    gap: 15px;
    flex-wrap: wrap;
}

.ticket-id {
    color: #00ff88;
    font-weight: 600;
    font-size: 14px;
}

.ticket-actions {
    display: flex;
    gap: 10px;
    flex-wrap: wrap;
}

.site-btn {
    background: linear-gradient(135deg, #00ff88, #00cc6a);
    border: none;
    padding: 12px 24px;
    border-radius: 8px;
    color: #000;
    font-weight: 600;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    transition: all 0.3s ease;
}

.site-btn:hover {
    background: linear-gradient(135deg, #00cc6a, #00ff88);
    color: #000;
    text-decoration: none;
    transform: translateY(-2px);
}

.site-btn.warning-btn {
    background: linear-gradient(135deg, #ffc107, #ff8f00);
    color: #000;
}

.site-btn.warning-btn:hover {
    background: linear-gradient(135deg, #ff8f00, #ffc107);
    color: #000;
}

.site-card-body {
    padding: 20px;
}

.ticket-details {
    margin-bottom: 30px;
    padding: 20px;
    background: rgba(255, 255, 255, 0.03);
    border-radius: 10px;
    border: 1px solid rgba(255, 255, 255, 0.05);
}

.ticket-info-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 15px;
}

.info-item {
    display: flex;
    flex-direction: column;
    gap: 5px;
}

.info-item label {
    color: #00ff88;
    font-weight: 600;
    font-size: 12px;
    text-transform: uppercase;
    margin: 0;
}

.info-item span {
    color: #fff;
    font-size: 14px;
}

.priority-high {
    color: #ff4757;
    font-weight: 600;
}

.priority-medium {
    color: #ffa502;
    font-weight: 600;
}

.priority-low {
    color: #00ff88;
    font-weight: 600;
}

.section-title {
    color: #fff;
    font-size: 18px;
    font-weight: 600;
    margin-bottom: 20px;
    padding-bottom: 10px;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.ticket-messages {
    margin-bottom: 30px;
}

.message-item {
    margin-bottom: 20px;
    padding: 20px;
    border-radius: 10px;
    border: 1px solid rgba(255, 255, 255, 0.1);
}

.user-message {
    background: rgba(0, 255, 136, 0.1);
    border-left: 4px solid #00ff88;
}

.admin-message {
    background: rgba(255, 255, 255, 0.05);
    border-left: 4px solid #ffc107;
}

.message-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 15px;
}

.message-author {
    display: flex;
    align-items: center;
    gap: 8px;
}

.author-icon {
    width: 20px;
    height: 20px;
    color: #00ff88;
}

.admin-icon {
    color: #ffc107;
}

.author-name {
    color: #fff;
    font-weight: 600;
    font-size: 14px;
}

.message-time {
    color: #ccc;
    font-size: 12px;
}

.message-content p {
    color: #fff;
    margin: 0;
    line-height: 1.6;
}

.message-attachment {
    margin-top: 15px;
    padding: 10px;
    background: rgba(255, 255, 255, 0.05);
    border-radius: 6px;
    display: flex;
    align-items: center;
    gap: 8px;
}

.message-attachment i {
    color: #00ff88;
    width: 16px;
    height: 16px;
}

.message-attachment a {
    color: #00ff88;
    text-decoration: none;
    font-size: 14px;
}

.message-attachment a:hover {
    text-decoration: underline;
}

.no-replies {
    text-align: center;
    padding: 40px 20px;
    color: #ccc;
}

.no-replies-icon {
    width: 48px;
    height: 48px;
    color: #00ff88;
    margin-bottom: 15px;
}

.reply-section {
    background: rgba(255, 255, 255, 0.03);
    padding: 20px;
    border-radius: 10px;
    border: 1px solid rgba(255, 255, 255, 0.05);
}

.site-input-groups {
    margin-bottom: 20px;
}

.box-input-label {
    display: block;
    margin-bottom: 8px;
    color: #fff;
    font-weight: 600;
    font-size: 14px;
}

.text-danger {
    color: #ff4757;
}

.box-input {
    position: relative;
}

.box-input-field {
    width: 100%;
    padding: 12px 16px;
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 8px;
    color: #fff;
    font-size: 14px;
    transition: all 0.3s ease;
}

.box-input-field:focus {
    outline: none;
    border-color: #00ff88;
    background: rgba(255, 255, 255, 0.08);
}

.box-input-field::placeholder {
    color: #999;
}

.text-muted {
    color: #999;
    font-size: 12px;
    margin-top: 5px;
    display: block;
}

.ticket-closed-notice {
    text-align: center;
    padding: 30px;
    background: rgba(255, 193, 7, 0.1);
    border: 1px solid rgba(255, 193, 7, 0.3);
    border-radius: 10px;
    color: #ffc107;
}

.ticket-closed-notice i {
    width: 32px;
    height: 32px;
    margin-bottom: 10px;
}

/* Mobile Styles */
@media (max-width: 768px) {
    .site-card-header {
        flex-direction: column;
        gap: 15px;
    }
    
    .ticket-actions {
        width: 100%;
        justify-content: center;
    }
    
    .site-btn {
        flex: 1;
        justify-content: center;
        padding: 10px 16px;
        font-size: 14px;
    }
    
    .ticket-info-grid {
        grid-template-columns: 1fr;
    }
    
    .message-item {
        padding: 15px;
    }
    
    .message-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 5px;
    }
    
    .reply-section {
        padding: 15px;
    }
    
    .box-input-field {
        font-size: 16px; /* Prevent iOS zoom */
    }
}

/* Mobile Messages */
.mobile-messages {
    display: none;
}

@media (max-width: 768px) {
    .ticket-messages {
        display: none;
    }
    
    .mobile-messages {
        display: block;
    }
    
    .mobile-message {
        margin-bottom: 15px;
        padding: 15px;
        border-radius: 8px;
        border: 1px solid rgba(255, 255, 255, 0.1);
    }
    
    .mobile-message.user-message {
        background: rgba(0, 255, 136, 0.1);
        border-left: 3px solid #00ff88;
    }
    
    .mobile-message.admin-message {
        background: rgba(255, 255, 255, 0.05);
        border-left: 3px solid #ffc107;
    }
    
    .mobile-message .message-header {
        display: flex;
        justify-content: space-between;
        margin-bottom: 10px;
    }
    
    .mobile-message .author-name {
        font-weight: 600;
        font-size: 14px;
        color: #fff;
    }
    
    .mobile-message .message-time {
        font-size: 12px;
        color: #ccc;
    }
    
    .mobile-message .message-content p {
        color: #fff;
        margin: 0;
        line-height: 1.5;
    }
    
    .mobile-reply-form {
        background: rgba(255, 255, 255, 0.03);
        padding: 15px;
        border-radius: 8px;
        margin-top: 20px;
    }
    
    .mobile-reply-form h4 {
        color: #fff;
        margin-bottom: 15px;
        font-size: 16px;
    }
    
    .mobile-reply-form .form-group {
        margin-bottom: 15px;
    }
    
    .mobile-reply-form .form-control {
        width: 100%;
        padding: 10px;
        background: rgba(255, 255, 255, 0.05);
        border: 1px solid rgba(255, 255, 255, 0.1);
        border-radius: 6px;
        color: #fff;
        font-size: 16px;
    }
    
    .mobile-reply-form .form-control:focus {
        outline: none;
        border-color: #00ff88;
    }
    
    .mobile-reply-form .form-control::placeholder {
        color: #999;
    }
    
    .mobile-reply-form .btn {
        padding: 12px;
        border: none;
        border-radius: 6px;
        font-weight: 600;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
    }
    
    .mobile-reply-form .btn-primary {
        background: linear-gradient(135deg, #00ff88, #00cc6a);
        color: #000;
    }
    
    .w-100 {
        width: 100% !important;
    }
}
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('frontend::layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digitalx/blockwavetrade.com/resources/views/frontend/ticket/show.blade.php ENDPATH**/ ?>