<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title'); ?> - <?php echo e(setting('site_name', 'ShahBlock')); ?></title>
    <meta name="description" content="<?php echo $__env->yieldContent('description', setting('site_description', 'global')); ?>">
    <meta name="keywords" content="<?php echo $__env->yieldContent('keywords', setting('site_keywords', 'global')); ?>">
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="<?php echo e(asset('frontend/theme_base/shahdeveloper/images/favicon.png')); ?>">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <?php echo $__env->yieldContent('style'); ?>
    <?php echo $__env->yieldPushContent('style'); ?>
</head>
<body>
    <!-- InvestFlow Header (default/global) -->
    <?php echo $__env->make('frontend.shahdeveloper.include.__shahdeveloper_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <!-- InvestFlow Styles -->
    <?php echo $__env->make('frontend.shahdeveloper.include.__shahdeveloper_styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <!-- Content Area -->
    <div class="content-wrapper">
        <?php echo $__env->yieldContent('content'); ?>
    </div>
    
    <!-- Bottom Navigation Menu -->
    <div class="bottom-nav">
        <a href="<?php echo e(route('user.dashboard')); ?>" class="nav-item <?php echo e(request()->routeIs('user.dashboard') ? 'active' : ''); ?>">
            <i class="fas fa-home"></i>
            <span>Home</span>
        </a>
        <a href="<?php echo e(route('user.schema')); ?>" class="nav-item <?php echo e(request()->routeIs('user.schema*') ? 'active' : ''); ?>">
            <i class="fas fa-chart-pie"></i>
            <span>Plans</span>
        </a>
        <a href="<?php echo e(route('user.deposit')); ?>" class="nav-item <?php echo e(request()->routeIs('user.deposit*') ? 'active' : ''); ?>">
            <i class="fas fa-plus"></i>
            <span>Deposit</span>
        </a>
        <a href="<?php echo e(route('user.deposit.log')); ?>" class="nav-item <?php echo e(request()->routeIs('user.deposit.log*') ? 'active' : ''); ?>">
            <i class="fas fa-list"></i>
            <span>Logs</span>
        </a>
        <a href="<?php echo e(route('user.withdraw.new.index')); ?>" class="nav-item <?php echo e(request()->routeIs('user.withdraw.new*') || request()->routeIs('user.withdraw.history') ? 'active' : ''); ?>">
            <i class="fas fa-minus"></i>
            <span>Withdraw</span>
        </a>
    </div>
    
    <!-- InvestFlow Scripts -->
    <?php echo $__env->make('frontend.shahdeveloper.include.__shahdeveloper_scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <?php echo $__env->yieldContent('script'); ?>
</body>
</html>


<?php /**PATH /home/digitalx/blockwavetrade.com/app/Providers/../../resources/views/frontend/shahdeveloper/layouts/app.blade.php ENDPATH**/ ?>